/**
* nlsmenuext_xml.js v.1.0
* Copyright 2005-2007, addobject.com. All Rights Reserved
* Author Jack Hermanto, www.addobject.com
*/
var $nls_ieXML=["MSXML2.DOMDocument.4.0", "MSXML2.DOMDocument.3.0", "MSXML2.DOMDocument", "Microsoft.XmlDom"];

function NlsMenuUtil() {}
var NLSMNUTIL=NlsMenuUtil.prototype;

function $aonvl(v, c) { if(v)return v; else return c; };
function $aonevl(v, c) { if(!v || v=="")return c; else return v; };

NlsMenuUtil.createFromXML=function(xml) {
  var rt=xml.documentElement;
  var mgr=new NlsMenuManager(rt.getAttribute("id"));
  mgr.flowOverFormElement=$aonevl(rt.getAttribute("flowoverformelement"), false);
  mgr.defaultEffect=$aonevl(rt.getAttribute("defaulteffect"), null);
  mgr.icPath=$aonvl(rt.getAttribute("icpath"), "");
  mgr.memorizeSel=$aonevl(rt.getAttribute("memorizesel"), false);

  var dm=rt.getElementsByTagName("menubar")[0];
  NlsMenuUtil.createMenu(dm, mgr);

  var mns=rt.getElementsByTagName("menus")[0];
  if(mns){
    for (var i=0;i<mns.childNodes.length;i++){
      dm=mns.childNodes[i];
      if(dm.nodeType!=1)continue;
      if(dm.nodeName=="menu") {
        NlsMenuUtil.createMenu(dm, mgr);
      }
    }
  }
  return mgr;
};

NlsMenuUtil.createMenu=function(dm, mgr, pc) {
  var id=dm.getAttribute("id"), mn=nlsMenu[id];
  if(mn) {
    if(pc!==true) {
      mn.items=new Object(); mn.srItems=[];
      mn.useEffect(mgr.defaultEffect);
    }
  } else mn=(dm.nodeName=="menubar"?mgr.createMenubar(id):mgr.createMenu(id));
  var a=dm.attributes, n, v;
  for(var i=0;i<a.length;i++) {
    n=a[i].nodeName; v=a[i].nodeValue;
    switch(n) {
      case "orient":mn.orient=v;break;
      case "showicon":mn.showIcon=(v=="true");break;
      case "showsubicon":mn.showSubIcon=(v=="true");break;
      case "target":mn.target=v;break;
      case "stlprf":mn.stlprf=v;break;
      case "submenuic": if(v && v!="") mn.subMenuIc=eval(v); break;
      case "icpath":mn.icPath=v;
      case "itemspc":mn.itemSpc=v;
      case "droponclick":if(mn.isMenubar) {mn.dropOnClick=(v=="true");}
    };
  }

  var its=dm.getElementsByTagName("items")[0].childNodes, ic="", itm;
  for(var i=0;i<its.length;i++) {
    a=its[i]; if(a.nodeType!=1) continue;
    if(a.nodeName=="separator") {mn.addSeparator(); continue;}
    ic=a.getAttribute("ico");
    itm=mn.addItem(a.getAttribute("id"),
      a.childNodes[0].nodeValue,
      $aonvl(a.getAttribute("url"),null),
      (!ic || ic==""?null:eval(ic)),
      (!a.getAttribute("enb")?null:a.getAttribute("enb")=="true"),
      null, $aonvl(a.getAttribute("title"),null)
    );
    itm.stlprf=$aonvl(a.getAttribute("stlprf"), "");
    itm.target=a.getAttribute("target");
    if(itm.target=="") itm.target=null;
    if(a.getAttribute("subid")) {
      mn.addSubmenu(a.getAttribute("id"),
        a.getAttribute("subid"),
        (!a.getAttribute("crsframe")?null:a.getAttribute("crsframe")=="true"),
        (!a.getAttribute("subframe")?null:eval(a.getAttribute("subframe"))),
        (!a.getAttribute("subpos")?null:eval(a.getAttribute("subpos"))),
        (!a.getAttribute("subposadj")?null:eval(a.getAttribute("subposadj"))),
        (!a.getAttribute("subdir")?null:eval(a.getAttribute("subdir")))
      );

      if(a.getAttribute("suburl")) {
        mn.setSubmenuUrl(a.getAttribute("id"), NlsMenuUtil.formatRequest(a.getAttribute('suburl')));
      }
    }
  }
  return mn;
};

NlsMenuUtil.createFromXMLString=function(sXml) {;
  var xml=NlsMenuUtil.createXMLDom(sXml);
  return NlsMenuUtil.createFromXML(xml);
};

NlsMenuUtil.createFromXMLFile=function(fName) {
  var xmlDom=NlsMenuUtil.$createDoc();
  xmlDom.async=false;
  xmlDom.load(fName);
  return NlsMenuUtil.createFromXML(xmlDom);
};

NlsMenuUtil.formatRequest = function ($url) {
	return $url += ($url.indexOf('?') ? '&' : '?') + 'ajax=yes';
}
/*mCnt: menu container/placeholder*/
NlsMenuUtil.loadFromXMLFile=function(fName, mCnt) {
  var req=NlsMenuUtil.createXMLRequest();
  req.open("get", NlsMenuUtil.formatRequest(fName), true);
  req.onreadystatechange=function() {
    if(req.readyState==4) {
      if(req.status==200 || req.status==304) {
        var s="";
        var mgr=NlsMenuUtil.createFromXML(req.responseXML);
        for (it in mgr.menus) { s+=mgr.menus[it].renderMenu(); }
        if(s!="") NlsMenuUtil.$createMenuDom(s);
        if(mgr.menubar) mgr.renderMenubar(mCnt);
      }
    }
  };
  req.send(null);
}

NlsMenuUtil.createXMLDom=function(sXml) {
  var xmlDom=null;
  if (typeof DOMParser != "undefined") {
    var parser=new DOMParser(); //gecko browser xml dom
    xmlDom=parser.parseFromString(sXml, "text/xml");
  } else {
    xmlDom=NlsMenuUtil.$createDoc();
    xmlDom.loadXML(sXml);
  }
  return xmlDom;
};

NlsMenuUtil.$createDoc=function() {
  var xmlDom=null;
  if(nls_isIE) {
    for (var i=0;i<$nls_ieXML.length;i++) {
      try {
        xmlDom=new ActiveXObject($nls_ieXML[i]);
        break;
      } catch (e) {}
    }
  } else {
    xmlDom=document.implementation.createDocument("","",null);
  }
  return xmlDom;
};

NlsMenuUtil.createXMLRequest=function() {
  if (typeof XMLHttpRequest != "undefined") { //for mozilla
    var httpReq=new XMLHttpRequest();
    return httpReq;
  } else {
    var arrObj=["MSXML2.XMLHttp.4.0", "MSXML2.XMLHttp.3.0", "MSXML2.XMLHttp", "Microsoft.XMHttp"];
    var oXml=null;
    for (var i=0; i<arrObj.length; i++) {
      try {
        oXml=new ActiveXObject(arrObj[i]);
        return oXml;
      } catch (e) { }
    }
  }
};

/*AJAX Menu*/
NlsMnMgr.loadingText="Loading menu, please wait...";

NLSMENU.addAJAXSubmenu=function(key, subId, url, crsFrame, subFrame, subPos, subPosAdj, subDir) {
  var it=this.addSubmenu(key, subId, crsFrame, subFrame, subPos, subPosAdj, subDir);
  this.setSubmenuUrl(key, url);
};

NLSMENU.setSubmenuUrl=function(key, url) {
  var it=this.items[this.mId+"_"+key];
  it.rt.subUrl=url;
  it.rt.loaded=0;
};

NlsMenuUtil.$createMenuDom=function(s) {
  var dv=document.createElement("div");
  dv.innerHTML=s;
  document.body.insertBefore(dv, document.body.childNodes[0]);
}

NlsMenuUtil.loadAJAXMenu=function(mn, it) {
  var mgr=mn.mgr;
  var req=NlsMenuUtil.createXMLRequest();
  req.open("get", it.rt.subUrl, true);
  req.onreadystatechange=function() {
    if(req.readyState==4) {
      if(req.status==200 || req.status==304) {
        var de=req.responseXML.documentElement;

        if(!de||de.childNodes.length==0) { //if no submenu
        } else {
          de=de.childNodes; var sub=null, main=null; subs=new Object(), smenu="";
          for(var i=0;i<de.length;i++){
            if(de[i].nodeType!=1) continue;
            sub=NlsMenuUtil.createMenu(de[i], mn.mgr);
            if(sub.mId==it.subMenuId) { main=sub; } else { subs[sub.mId]=sub;}
          }
          for (var x in subs) { smenu+=subs[x].renderMenu(); }
          if(smenu) {NlsMenuUtil.$createMenuDom(smenu);}
          if(main) {
            main.prIt=it.intKey; main.reload(true);
            if(main.rt.active)NlsMenu.$showMenu(mn, it);
            it.rt.loaded=2;
          }
        }
      }
    }
  };
  var smn=mgr.createMenu(it.subMenuId); smn.effect=null;
  smn.addItem("ajaxload", mgr.loadingText);
  NlsMenuUtil.$createMenuDom(smn.renderMenu());
  NlsMenu.$showMenu(mn, it);
  it.rt.loaded=1; //loading
  req.send(null);
}






