<!--##
<NAME>Add Article Review</NAME>
<DESC>Form for submitting Article Review</DESC>
<SECTION>Platform||Articles</SECTION>
##-->

<inp2:m_RequireLogin login_template="platform/login/register" permissions="NEWS.REVIEW|NEWS.REVIEW.PENDING"/>

<!--## PAGE TITLE ELEMENT ##-->
<inp2:m_DefineElement name="page_title">
	<inp2:n_Field name="Title"/>
</inp2:m_DefineElement>
<!--## //PAGE TITLE ELEMENT ##-->

<!--## SIDE-BAR ELEMENT ##-->
<inp2:m_DefineElement name="sidebar">
	<div class="movable-area">
		<div class="movable-element">
			<inp2:m_RenderElement name="platform/elements/side_boxes/login.elm" design="blue_box"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="platform/elements/side_boxes/search.elm" design="blue_box"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="in-news/elements/side_boxes/action_box.elm" item_actions="1" design="blue_box"/>
		</div>
	</div>
</inp2:m_DefineElement>
<!--## //SIDE-BAR ELEMENT ##-->

<inp2:m_DefineElement name="content">
	<div class="movable-area">
		<div class="movable-element">
			<inp2:m_include template="platform/elements/navigation_bar.elm" titles="__item__,lu_title_Reviews" templates="__default__,in-news/articles/add_review" show_category="1"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement design="content_box">
				<inp2:m_Capture to_var="header">
					<inp2:m_phrase name="lu_title_ArticleDetails"/>
				</inp2:m_Capture>

				<table class="fullwidth table-border">
					<tr><td class="item-padding">

				<table>
					<tr>
						<td width="25" valign="top">
							<img src="<inp2:m_TemplatesBase module="In-News"/>img/articles_icon.gif" width="16" height="23" alt="" />
						</td>
						<td valign="top">

							<span class="text-title"><inp2:n_Field name="Title"/></span>

							<inp2:m_if check="n_Field" name="IsHot"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/icon_hot.gif" alt="<inp2:m_Phrase name="lu_Hot" no_editing="1"/>"/></inp2:m_if>
							<inp2:m_if check="n_Field" name="IsNew"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/icon_new.gif" alt="<inp2:m_Phrase name="lu_New" no_editing="1"/>"/></inp2:m_if>
							<inp2:m_if check="n_Field" name="IsPop"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/icon_popular.gif" alt="<inp2:m_Phrase name="lu_Pop" no_editing="1"/>"/></inp2:m_if>
							<inp2:m_if check="n_IsEditorsPick"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/icon_pick.gif" alt="<inp2:m_Phrase name="lu_Pick" no_editing="1"/>"/></inp2:m_if>
							<inp2:m_if check="n_IsFavorite"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/icon_favorite.gif" alt="<inp2:m_Phrase name="lu_Favorite" no_editing="1"/>"/></inp2:m_if>
							<inp2:n_VotesIndicator render_as="rating_element"/>

							<br />

							<span class="item-statistics">
								<inp2:m_phrase name="lu_Added"/>: <inp2:n_Field name="CreatedOn" format="_regional_DateFormat"/>,
								<inp2:m_phrase name="lu_Hits"/>: <inp2:n_Field name="Hits"/>,
								<inp2:m_phrase name="lu_Rating"/>: <inp2:n_Field name="CachedRating"/>,
								<inp2:m_phrase name="lu_Reviews"/>: <inp2:n_Field name="CachedReviewsQty"/>,
								<inp2:m_phrase name="lu_Votes"/>: <inp2:n_Field name="CachedVotesQty"/>
							</span>
						</td>
					</tr>
				</table>

				<table>
					<tr>
						<td class="picture-padding" style="padding-left:25px" valign="top">
							<inp2:m_if check="n_ImageSrc" MaxWidth="fullsize">
								<a href="<inp2:n_ImageSrc MaxWidth='fullsize' DefaultImage='platform/img/no_picture.gif'/>" class="form-manager-window" rel="article-images" title="<inp2:n_Field name='Title' html_escape='1'/>">
									<inp2:n_Image render_as="image_element" Primary="1" MaxWidth="thumbnail" DefaultImage="platform/img/no_picture.gif"/><br />
								</a>
							<inp2:m_else/>
								<inp2:n_Image render_as="image_element" Primary="1" MaxWidth="thumbnail" DefaultImage="platform/img/no_picture.gif"/><br />
							</inp2:m_if>
						</td>
						<td class="text-padding" valign="top">
							<inp2:n_Field name="Excerpt" nl2br="1"/>
						</td>
					</tr>
				</table>
			</td></tr></table>
			</inp2:m_RenderElement>
			</div>

			<div class="movable-element">
			<inp2:m_RenderElement design="content_box">
				<inp2:m_Capture to_var="header">
					<inp2:m_phrase name="lu_title_ReviewThisArticle"/>
				</inp2:m_Capture>


				<inp2:m_if check="n_HasPermission" permissions="NEWS.REVIEW|NEWS.REVIEW.PENDING">
					<inp2:m_if check="n-rev_AlreadyReviewed">
						<inp2:m_Phrase label="lu_ErrorAlreadyReviewed"/>
						<table>
							<inp2:n-rev_PrintList render_as="review_element" type="current_user" per_page="-1"/>
						</table>
						<inp2:m_include template="platform/elements/pagination.elm" prefix="n-rev"/>
					<inp2:m_else/>
						<inp2:n-rev_PresetFormFields/>
						<span class="field-required">*</span> <inp2:m_phrase name="lu_IndicatesRequired"/><br /><br />

						<inp2:m_if check="n-rev_HasError" field="any">
							<inp2:m_RenderElement name="error_message" />
						</inp2:m_if>

						<img src="<inp2:m_TemplatesBase module="In-Portal"/>img/grey_pix.gif" width="100%" height="1" align="absmiddle" alt="" /><br /><br />

						<form method="post" action="<inp2:m_FormAction/>">
							<table class="form-data fullwidth">
								<inp2:m_RenderElement name="inp_edit_radio" prefix="n-rev" field="Rating" title="lu_fld_Rating"/>
								<inp2:m_RenderElement name="inp_edit_textarea" prefix="n-rev" field="ReviewText" rows="8" cols="40" title="lu_fld_ReviewText" is_last="1"/>

								<inp2:m_RenderElement design="inp_edit_buttons">
									<input type="hidden" name="success_template" value="in-news/articles/add_review_confirm"/>
									<input type="hidden" name="success_pending_template" value="in-news/articles/add_review_pending_confirm"/>
									<input class="button" type="submit" name="events[n-rev][OnCreate]" value="<inp2:m_Phrase label="lu_btn_Create" no_editing="1"/>"/>
								</inp2:m_RenderElement>
							</table>
						</form>
					</inp2:m_if>
				<inp2:m_else/>
					<inp2:m_phrase name="lu_text_NoArticleReviewPermission"/>
				</inp2:m_if>
			</inp2:m_RenderElement>
			<!-- // add review -->
		</div>
	</div>
</inp2:m_DefineElement>

<inp2:m_include template="platform/designs/default_design.des" pass_params="1"/>