<?php
/**
* @version	$Id: install.php 12363 2009-08-22 19:05:04Z alex $
* @package	In-News
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/
	$module_folder = 'in-news';

	if (!defined('IS_INSTALL')) {
		// separate module install
		define('IS_INSTALL', 1);
		define('ADMIN', 1);
		define('REL_PATH', $module_folder);
		define('FULL_PATH', realpath(dirname(__FILE__) . '/..') );

		include_once(FULL_PATH . '/core/kernel/startup.php');
		require_once FULL_PATH . '/core/install/install_toolkit.php';

		$toolkit = new kInstallToolkit();
	}
	else {
		// install, using installation wizard
		$toolkit =& $this->toolkit;
		/* @var $toolkit kInstallToolkit */
	}

	$application =& kApplication::Instance();
	$application->Init();

	if ($application->RecallVar('user_id') != -1) {
		die('restricted access!');
	}

	$category =& $toolkit->createModuleCategory('News', 'News Articles', '/in-news/designs/section', 'in-news/img/menu_articles.gif');

	$toolkit->RunSQL('/' . $module_folder . '/install/install_schema.sql');
	$toolkit->RunSQL('/' . $module_folder . '/install/install_data.sql', '{NewsCatId}', $category->GetID());
	$toolkit->ImportLanguage('/' . $module_folder . '/install/english');

	$toolkit->SetModuleRootCategory($module_folder, $category->GetID());

	$toolkit->linkCustomFields($module_folder, 'n', 2); // to create Custom Fields for News
	$toolkit->linkCustomFields('KERNEL', 'c', 1); // to create ItemTemplate custom field
	$toolkit->setModuleItemTemplate($category, 'n', 'in-news/articles/article_detail');

	$toolkit->finalizeModuleInstall($module_folder, true);