<?php
/**
* @version	$Id: censorship_config.php 16384 2016-08-11 08:15:32Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'censorship',
	'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'kDBEventHandler', 'file' => '', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
		5 => 'mode',
	),

	'IDField' => 'CensorshipId',

	'TableName' => TABLE_PREFIX.'Censorship',

	'TitleField' => 'BadWord',

	'TitlePresets' => Array (
		'default' => Array (
			'new_status_labels' => Array ('censorship' => '!la_title_AddingCensorship!'),
			'edit_status_labels' => Array ('censorship' => '!la_title_EditingCensorship!'),
		),

		'censorship_list' => Array ('prefixes' => Array ('censorship_List'), 'format' => "!la_tab_ConfigCensorship!"),
		'censorship_edit' => Array ('prefixes' => Array ('censorship'), 'format' => "#censorship_status# '#censorship_titlefield#'"),
	),

	'PermSection' => Array ('main' => 'in-bulletin:configuration_censorship'),

	'Sections' => Array (
		'in-bulletin:configuration_censorship' => Array (
			'parent' => 'in-bulletin:setting_folder',
			'icon' => 'conf_censorship',
			'label' => 'la_tab_ConfigCensorship',
			'url' => Array ('t' => 'in-bulletin/censorship/censorship_list', 'pass' => 'm'),
			'permissions' => Array ('view', 'add', 'edit', 'delete'),
			'priority' => 1,
			'type' => stTREE,
		),
	),

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s',
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('BadWord' => 'asc'),
		)
	),

	'Fields' => Array (
		'CensorshipId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'BadWord' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'required' => 1, 'default' => ''),
		'Replacement' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'required' => 1, 'default' => ''),
	),

	'Grids' => Array (
		'Default' => Array (
			'Icons' => Array (
				'default' => 'icon16_item.png',
				0 => 'icon16_disabled.png',
				1 => 'icon16_item.png',
				'module' => 'core',
			),
			'Fields' => Array (
				'CensorshipId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter',  'width' => 50),
				'BadWord' => Array ('filter_block' => 'grid_like_filter', 'width' => 250),
				'Replacement' => Array ('filter_block' => 'grid_like_filter', 'width' => 250),
			),
		),
	),
);