<?php
/**
* @version	$Id: poll_answers_config.php 14581 2011-09-23 14:27:22Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config = Array ( 'Prefix' => 'poll-answer',

		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'kDBEventHandler', 'file' => '', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),
		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
		),
		'IDField' => 'AnswerId',
		'TableName' => TABLE_PREFIX . 'PollsAnswers',

		'ParentPrefix' => 'poll',
		'ForeignKey'  => 'PollId',
		'ParentTableKey' => 'PollId',
		'AutoDelete' => true,
		'AutoClone' => true,

		'TitleField' => 'Answer',
		'StatusField' => Array ('Status'),

		// key - special, value - list select sql
		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s
					FROM %1$s
					',
				),

		'ItemSQLs' => Array ('' => 'SELECT * FROM %s'),

		'ListSortings' => Array (
			'' => Array(
				'ForcedSorting' => Array('Priority' => 'desc'),
				'Sorting' => Array('Answer' => 'asc'),
			)
		),

		'Fields' => Array (
		    'AnswerId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'PollId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'Answer'	=>	Array('type' => 'string', 'formatter' => 'kMultiLanguage', 'not_null' => 1, 'using_fck' => 1, 'default' => '', 'required' => 1),
		    'VotesQty' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'Priority' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		  	'Status' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_Active', 0 => 'la_opt_Disabled'), 'use_phrases' => 1, 'required' => 1, 'not_null' => 1, 'default' => 1),
		),

		'Grids' => Array (
						'Default' => Array (
							'Icons' => Array (
								'default' => 'icon16_item.png',
								0 => 'icon16_disabled.png',
								1 => 'icon16_item.png',
								2 => 'icon16_pending.png',
								'module' => 'core',
							),
							'Fields' => Array (
								'AnswerId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
								'Answer' => Array ('data_block' => 'grid_priority_td', 'filter_block' => 'grid_like_filter', 'width' => 300, ),
								'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 100, ),
								'VotesQty' => Array ('title' => 'la_col_VoteCount', 'filter_block' => 'grid_like_filter', 'width' => 100, ),

							),
						),
		),

	);