<?php
/**
* @version	$Id: listing_types_event_handler.php 15150 2012-03-04 09:05:14Z alex $
* @package	In-Link
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class ListingTypesEventHandler extends kDBEventHandler  {

		/**
		 * Allows to override standard permission mapping
		 *
		 * @return void
		 * @access protected
		 * @see kEventHandler::$permMapping
		 */
		protected function mapPermissions()
		{
			parent::mapPermissions();

			$permissions = Array (
				'OnItemBuild' => Array ('self' => true),
			);

			$this->permMapping = array_merge($this->permMapping, $permissions);
		}

		/**
		 * Set's selected category to listing type
		 *
		 * @param kEvent $event
		 */
		function OnProcessSelected($event)
		{
			$object = $event->getObject();
			$selected_ids = $this->Application->GetVar('selected_ids');

			$object->SetDBField($this->Application->RecallVar('dst_field'), $selected_ids['c']);
			$this->RemoveRequiredFields($object);
			$object->Update();

			$this->finalizePopup($event);
		}


		function OnPreSaveListingType($event)
		{
			$event->redirect = false;
			$object = $event->getObject( Array('skip_autoload' => true) );
			$this->RemoveRequiredFields($object);
			$event->CallSubEvent('OnPreSave');
			$this->Application->SetVar($event->getPrefixSpecial(true).'_id', $object->GetID());
		}

		/**
		 * Prepare temp tables and populate it
		 * with items selected in the grid
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnEdit(kEvent $event)
		{
			if ( $this->Application->prefixRegistred('p') ) {
				$this->Application->recallObject('p', null, Array ('skip_autoload' => true));
			}

			parent::OnEdit($event);
		}

		/**
		 * Makes shopping cart name required, when buying is enabled
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnBeforeItemUpdate(kEvent $event)
		{
			parent::OnBeforeItemUpdate($event);

			$object = $event->getObject();
			/* @var $object kDBItem */

			$object->setRequired('ShopCartName', $object->GetDBField('EnableBuying'));
		}
	}