# ===== v 4.3.9 =====
INSERT INTO Events VALUES (DEFAULT, 'LINK.VALIDATION.RESULTS', NULL, 1, 0, 'In-Link', 'la_event_link.validation.results', 1);

INSERT INTO ImportScripts VALUES (DEFAULT, 'Links from CSV file [In-Link]', '', 'l', 'In-Link', '', 'CSV', '1');

UPDATE CustomField
SET ValueList = '=+||<SQL>SELECT DestAbbr AS OptionValue, DestName AS OptionName FROM <PREFIX>StdDestinations WHERE DestType = 2 AND (DestParentId = 225 OR DestParentId = 38) ORDER BY DestParentId DESC, DestAbbr ASC</SQL>'
WHERE FieldName = 'LinkState';

UPDATE CustomField
SET ValueList = '=+||<SQL>SELECT DestAbbr AS OptionValue, DestName AS OptionName FROM <PREFIX>StdDestinations WHERE DestType = 1 ORDER BY DestAbbr ASC</SQL>'
WHERE FieldName = 'LinkCountry';

# ===== v 5.0.0 =====
INSERT INTO Counters VALUES (DEFAULT, 'linkhits_count', 'SELECT ROUND(SUM(Hits)) FROM <%PREFIX%>Link', NULL, NULL, '300', '0', '|Link|');
UPDATE Category SET Template = '/in-link/designs/section' WHERE Template = 'inlink/index';
UPDATE Category SET CachedTemplate = '/in-link/designs/section' WHERE CachedTemplate = 'inlink/index';

UPDATE ConfigurationValues SET VariableValue = '/in-link/designs/section' WHERE VariableName = 'l_CategoryTemplate';
UPDATE ConfigurationValues SET VariableValue = 'in-link/designs/detail' WHERE VariableName = 'l_ItemTemplate';

INSERT INTO Permissions VALUES (DEFAULT, 'in-link:links.view', 11, 1, 1, 0);
INSERT INTO Permissions VALUES (DEFAULT, 'in-link:setting_folder.view', 11, 1, 1, 0);
DELETE FROM Permissions WHERE Permission LIKE 'in-link:inlink_general.%';

UPDATE Events SET Description = 'la_event_link.owner.modify' WHERE  Description = 'la_event_link.modify.modify';
UPDATE Events SET Description = 'la_event_link.owner.modify.pending' WHERE  Description = 'la_event_link.modify.modify.pending';

UPDATE Phrase SET Module = 'In-Link' WHERE ((Phrase LIKE '%Links%' OR Phrase LIKE '%Listing%') AND (Module = 'Core') AND Phrase NOT IN ('la_section_QuickLinks'));

UPDATE Phrase SET Module = 'In-Link', PhraseType = 1 WHERE ( (Phrase LIKE '%Validation%' OR Phrase LIKE 'la_title_In-Link') AND (Module = 'Core') AND Phrase NOT IN ('la_ValidationEmail', 'la_prompt_validation'));

# ===== v 5.0.1 =====
UPDATE ConfigurationValues SET VariableValue = 'in-link/links/link_detail' WHERE VariableName = 'l_ItemTemplate';

UPDATE ConfigurationAdmin SET ValueList = 'ReviewText=la_opt_CommentText,CreatedOn=la_opt_CreatedOn'
WHERE VariableName IN ('Link_ReviewsSort', 'Link_ReviewsSort2');

UPDATE ConfigurationAdmin SET ValueList = 'ASC=la_common_Ascending,DESC=la_common_Descending'
WHERE VariableName IN ('Link_ReviewsOrder', 'Link_ReviewsOrder2');

UPDATE ConfigurationAdmin SET ValueList = 'Name=la_Link_Name,Description=la_Link_Description,Url=la_Link_URL,CreatedOn=la_opt_CreatedOn,Hits=la_Link_Hits,CachedRating=la_opt_Rating,<SQL>SELECT Prompt AS OptionName, CONCAT("cust_", FieldName) AS OptionValue FROM <PREFIX>CustomField WHERE (Type = 4) AND (IsSystem = 0)</SQL>'
WHERE VariableName IN ('Link_SortField', 'Link_SortField2');

UPDATE ConfigurationAdmin
SET ValueList = '1=la_opt_Sec,60=la_opt_Min,3600=la_opt_Hour,86400=la_opt_Day,604800=la_opt_Week,2419200=la_opt_Month,29030400=la_opt_Year'
WHERE VariableName IN ('link_ReviewDelay_Interval', 'link_RatingDelay_Interval');

UPDATE CustomField SET FieldLabel = 'la_fld_cust_l_ItemTemplate', Prompt = 'la_fld_cust_l_ItemTemplate' WHERE FieldName = 'l_ItemTemplate';

INSERT INTO Events VALUES(DEFAULT, 'LINK.REVIEW.ADD.PENDING', NULL, 1, 0, NULL, 'In-Link', 'la_event_link.review.add.pending', 1);

UPDATE ConfigurationAdmin SET ValueList = 'style="width: 50px;"' WHERE VariableName IN ('link_ReviewDelay_Value', 'link_RatingDelay_Value');

# ===== v 5.0.2-B1 =====
ALTER TABLE ListingTypes CHANGE Description Description text NULL;
ALTER TABLE LinkValidation CHANGE ValidationTime ValidationTime INT NULL DEFAULT NULL;
ALTER TABLE LinkVisits CHANGE VisitTimestamp VisitTimestamp INT(11) NULL DEFAULT NULL;

# ===== v 5.0.2-B2 =====

# ===== v 5.0.2-RC1 =====

# ===== v 5.0.2 =====

# ===== v 5.0.3-B1 =====
UPDATE Phrase
SET Module = 'In-Link'
WHERE Phrase IN (
	'lu_PermName_Link.Add.Pending_desc', 'lu_PermName_Link.Add_desc', 'lu_PermName_Link.Delete_desc',
	'lu_PermName_Link.Modify.Pending_desc', 'lu_PermName_Link.Modify_desc', 'lu_PermName_Link.Owner.Delete_desc',
	'lu_PermName_Link.Owner.Modify.Pending_desc', 'lu_PermName_Link.Owner.Modify_desc', 'lu_PermName_Link.Rate_desc',
	'lu_PermName_Link.Review_Pending_desc', 'lu_PermName_Link.View_desc'
);

# ===== v 5.0.3-B2 =====

# ===== v 5.0.3-RC1 =====

# ===== v 5.0.3 =====

# ===== v 5.0.4-B1 =====

# ===== v 5.0.4-B2 =====

# ===== v 5.0.4 =====

# ===== v 5.1.0-B1 =====
UPDATE Modules SET Path = 'modules/in-link/' WHERE `Name` = 'In-Link';
DELETE FROM ConfigurationValues WHERE VariableName IN ('StartValidationTime', 'LastExpirationTime', 'Link_Root');

UPDATE CustomField
SET ValueList = '=+||<SQL+>SELECT IsoCode AS OptionValue, l%3$s_Name AS OptionName FROM <PREFIX>CountryStates WHERE Type = 2 ORDER BY StateCountryId DESC, IsoCode ASC</SQL>'
WHERE ValueList = '=+||<SQL>SELECT DestAbbr AS OptionValue, DestName AS OptionName FROM <PREFIX>StdDestinations WHERE DestType = 2 AND (DestParentId = 225 OR DestParentId = 38) ORDER BY DestParentId DESC, DestAbbr ASC</SQL>';

UPDATE CustomField
SET ValueList = '=+||<SQL+>SELECT IsoCode AS OptionValue, l%3$s_Name AS OptionName FROM <PREFIX>CountryStates WHERE Type = 1 ORDER BY IsoCode ASC</SQL>'
WHERE ValueList = '=+||<SQL>SELECT DestAbbr AS OptionValue, DestName AS OptionName FROM <PREFIX>StdDestinations WHERE DestType = 1 ORDER BY DestAbbr ASC</SQL>';

DELETE FROM Permissions WHERE Permission LIKE 'in-link:configuration_email%';

# ===== v 5.1.0-RC1 =====

# ===== v 5.1.0 =====

# ===== v 5.1.1-B1 =====
ALTER TABLE Link
	CHANGE CreatedById CreatedById INT(11) NULL DEFAULT NULL ,
	CHANGE ModifiedById ModifiedById INT(11) NULL DEFAULT NULL;

# ===== v 5.1.1-B2 =====
UPDATE Events
SET l<%PRIMARY_LANGUAGE%>_Body = REPLACE(l<%PRIMARY_LANGUAGE%>_Body, '<inp2:<inp2:', '<inp2:')
WHERE Event LIKE 'LINK.ADD.PENDING' AND `Type` = 1;

# ===== v 5.1.1-RC1 =====

# ===== v 5.1.1 =====

# ===== v 5.1.2-B1 =====

# ===== v 5.1.2-RC1 =====

# ===== v 5.1.2 =====

# ===== v 5.1.3-B1 =====

# ===== v 5.1.3-RC1 =====
UPDATE ConfigurationValues
SET VariableValue = 'in-link/links/link_detail'
WHERE VariableName = 'l_ItemTemplate' AND VariableValue = 'in-link/designs/detail';

# ===== v 5.1.3-RC2 =====

# ===== v 5.1.3 =====
UPDATE Phrase
SET `Module` = 'Core'
WHERE PhraseKey IN ('LA_FLD_LISTINGID', 'LA_FLD_LISTINGTYPE');

# ===== v 5.2.0-B1 =====
UPDATE SearchConfig
SET ForeignField = 'PortalUser.Username'
WHERE ForeignField = 'PortalUser.Login' AND ModuleName = 'In-Link';

UPDATE SearchConfig
SET DisplayName = REPLACE(DisplayName, 'lu_', 'lc_')
WHERE DisplayName IN ('lu_field_linkid', 'lu_field_url');

UPDATE SystemSettings
SET Section = 'in-portal:configure_advanced', ModuleOwner = 'In-Portal', Heading = 'la_section_Settings3rdPartyAPI', DisplayOrder = 80.02
WHERE VariableName = 'l_GoogleMapsAPIKey';

UPDATE SystemSettings
SET DisplayOrder = DisplayOrder - 0.01
WHERE VariableName IN ('l_EnableLinkContactForm', 'ReciprocalLinkChecking');

UPDATE LanguageLabels
SET Module = 'In-Link'
WHERE PhraseKey IN ('LA_LINK_CREATEDON', 'LA_LINK_DESCRIPTION', 'LA_LINK_HITS', 'LA_LINK_NAME', 'LA_LINK_URL');

DELETE FROM LanguageLabels
WHERE PhraseKey IN (
	'LA_LINK_URLSTATUS_PROMPT', 'LA_TEXT_LINK_SEARCH', 'LA_LINK_CATCHEDRATING',
	'LA_LINK_CATCHEDREVIEWSQTY', 'LA_LINK_CATCHEDVOTESQTY'
);

DELETE FROM SystemSettings
WHERE VariableName IN (
	'Link_Highlight_OpenTag', 'Link_Highlight_CloseTag', 'Link_RatingToPop', 'Link_UrlStatus',
	'Search_Link_CatchedRating', 'Search_Link_CatchedReviewsQty', 'Search_Link_CatchedVotesQty',
	'Search_Link_CreatedOn', 'Search_Link_Description', 'Search_Link_EditorsPick', 'Search_Link_Hits',
	'Search_Link_HotItem', 'Search_Link_LinkId', 'Search_Link_Name', 'Search_Link_NewItem', 'Search_Link_PopItem',
	'Search_Link_Priority', 'Search_Link_ResourceId', 'Search_Link_ReviewById', 'Search_Link_Status', 'Search_Link_Url'
);

UPDATE SystemSettings
SET DisplayOrder = DisplayOrder - 0.01
WHERE VariableName IN (
	'link_ReviewDelay_Value', 'link_ReviewDelay_Interval', 'link_RatingDelay_Value', 'link_RatingDelay_Interval',
	'l_MaxCategories', 'l_EnableGoogleMaps', 'l_EnableLinkContactForm', 'ReciprocalLinkChecking'
);

UPDATE SearchConfig
SET ForeignField = 'Users.Username'
WHERE ForeignField = 'PortalUser.Username' AND ModuleName = 'In-Link';

# ===== v 5.2.0-B2 =====
UPDATE Link main_table
SET main_table.CachedReviewsQty = (SELECT COUNT(*) FROM <%TABLE_PREFIX%>CatalogReviews review_table WHERE review_table.ItemId = main_table.ResourceId);

# ===== v 5.2.0-B3 =====

# ===== v 5.2.0-RC1 =====

# ===== v 5.2.0 =====
INSERT INTO Permissions VALUES(DEFAULT, 'in-link:configuration_output.add', 11, 1, 1, 0);

# ===== v 5.2.1-B1 =====

# ===== v 5.2.1-B2 =====
UPDATE Modules
SET ClassNamespace = 'Intechnic\\InPortal\\Modules\\InLink'
WHERE `Name` = 'In-Link';
