<?php
/**
* @version	$Id: l-visits_config.php 14254 2011-03-16 21:30:58Z alex $
* @package	In-Link
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'l-visit',
		'ItemClass'			=>	Array('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'EventHandlerClass'	=>	Array('class' => 'LinkVisitEventHandler', 'file' => 'l-visit_eh.php', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'Hooks' => Array (
			Array (
				'Mode' => hAFTER,
				'Conditional' => false,
				'HookToPrefix' => 'u',
				'HookToSpecial' => '-item', // from OnMassDelete event
				'HookToEvent' => Array('OnAfterItemDelete'),
				'DoPrefix' => '',
				'DoSpecial' => '*',
				'DoEvent' => 'OnDeleteVisits',
			),

			Array (
				'Mode' => hAFTER,
				'Conditional' => false,
				'HookToPrefix' => 'l',
				'HookToSpecial' => '-item', // from "Catalog"
				'HookToEvent' => Array('OnAfterItemDelete'),
				'DoPrefix' => '',
				'DoSpecial' => '*',
				'DoEvent' => 'OnDeleteVisits',
			),

			Array (
				'Mode' => hAFTER,
				'Conditional' => false,
				'HookToPrefix' => 'l',
				'HookToSpecial' => 'showall-item', // from "Advanced View"
				'HookToEvent' => Array('OnAfterItemDelete'),
				'DoPrefix' => '',
				'DoSpecial' => '*',
				'DoEvent' => 'OnDeleteVisits',
			),
		),

		'QueryString' => Array (
			1	=>	'id',
			2	=>	'Page',
			3	=>	'PerPage',
			4	=>	'event',
		),

		'IDField' => 'VisitId',
		'TableName' => TABLE_PREFIX.'LinkVisits',

		'AutoDelete' => true,

		'ListSQLs' => Array ('' => 'SELECT * FROM %s'),
		'ItemSQLs' => Array ('' => 'SELECT * FROM %s'),

		'ListSortings' => Array (
			'' => Array(
				'Sorting' => Array('VisitTimestamp' => 'desc'),
			)
		),

	    'Fields' => Array (
	    	'VisitId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'ResourceId' => Array ('type' => 'int', 'default' => NULL),
		    'PortalUserId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'VisitTimestamp' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
        ),
	);