<?php
/**
* @version	$Id: upgrades.php 15391 2012-06-12 16:32:02Z alex $
* @package	In-Link
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$upgrade_class = 'InLinkUpgrades';

	/**
	 * Class, that holds all upgrade scripts for "In-Link" module
	 *
	 */
	class InLinkUpgrades extends kUpgradeHelper {

		public function __construct()
		{
			parent::__construct();

			$this->dependencies = Array (
				'4.3.9' => Array ('Core' => '4.3.9'),
				'5.0.0' => Array ('Core' => '5.0.0'),
				'5.0.1' => Array ('Core' => '5.0.1'),
				'5.0.2-B1' => Array ('Core' => '5.0.2-B1'),
				'5.0.2-B2' => Array ('Core' => '5.0.2-B2'),
				'5.0.2-RC1' => Array ('Core' => '5.0.2-RC1'),
				'5.0.2' => Array ('Core' => '5.0.2'),
				'5.0.3-B1' => Array ('Core' => '5.0.3-B1'),
				'5.0.3-B2' => Array ('Core' => '5.0.3-B2'),
				'5.0.3-RC1' => Array ('Core' => '5.0.3-RC1'),
				'5.0.3' => Array ('Core' => '5.0.3'),
				'5.0.4-B1' => Array ('Core' => '5.0.4-B1'),
				'5.0.4-B2' => Array ('Core' => '5.0.4-B2'),
				'5.0.4' => Array ('Core' => '5.0.4'),
				'5.1.0-B1' => Array ('Core' => '5.1.0-B1'),
				'5.1.0-RC1' => Array ('Core' => '5.1.0-RC1'),
				'5.1.0' => Array ('Core' => '5.1.0'),
				'5.1.1-B1' => Array ('Core' => '5.1.1-B1'),
				'5.1.1-B2' => Array ('Core' => '5.1.1-B2'),
				'5.1.1-RC1' => Array ('Core' => '5.1.1-RC1'),
				'5.1.1' => Array ('Core' => '5.1.1'),
				'5.1.2-B1' => Array ('Core' => '5.1.2-B1'),
				'5.1.2-RC1' => Array ('Core' => '5.1.2-RC1'),
				'5.1.2' => Array ('Core' => '5.1.2'),
				'5.1.3-B1' => Array ('Core' => '5.1.3-B2'),
				'5.1.3-RC1' => Array ('Core' => '5.1.3-RC1'),
				'5.1.3-RC2' => Array ('Core' => '5.1.3-RC2'),
				'5.1.3' => Array ('Core' => '5.1.3'),
				'5.2.0-B1' => Array ('Core' => '5.2.0-B1'),
				'5.2.0-B2' => Array ('Core' => '5.2.0-B2'),
				'5.2.0-B3' => Array ('Core' => '5.2.0-B3'),
				'5.2.0-RC1' => Array ('Core' => '5.2.0-RC1'),
			);
		}

		/**
		 * Changes table structure, where multilingual fields of TEXT type are present
		 *
		 * @param string $mode when called mode {before, after)
		 */
		function Upgrade_5_0_0($mode)
		{
			if ($mode == 'after') {
				$root_category = $this->Application->findModule('Name', 'In-Link', 'RootCat');

				$sql = 'UPDATE ' . $this->Application->getUnitOption('c', 'TableName') . '
						SET UseMenuIconUrl = 1, MenuIconUrl = "in-link/img/menu_links.gif"
						WHERE ' . $this->Application->getUnitOption('c', 'IDField') . ' = ' . $root_category;
				$this->Conn->Query($sql);

				$this->_updateDetailTemplate('l', 'inlink/detail', 'in-link/designs/detail');

				// copy link name and description to their multilingual equivalents
				$this->_copyToMultilingual();
			}
		}

		/**
		 * Copy link values from normal fields to multilingual
		 *
		 */
		function _copyToMultilingual()
		{
			$fields = Array ('Name', 'Description');
			$primary_language = $this->Application->GetDefaultLanguageId();

			$set_clause = Array ();
			foreach ($fields as $field) {
				$set_clause[] = 'l' . $primary_language . '_' . $field . ' = ' . $field;
			}

			$sql = 'UPDATE ' . TABLE_PREFIX . 'Link
					SET ' . implode(', ', $set_clause);
			$this->Conn->Query($sql);
		}

		/**
		 * Update to 5.0.1
		 *
		 * @param string $mode when called mode {before, after)
		 */
		function Upgrade_5_0_1($mode)
		{
			if ($mode == 'after') {
				$this->_updateDetailTemplate('l', 'in-link/designs/detail', 'in-link/links/link_detail');

				// delete old events
				$events_to_delete = Array ( 'LINK.OWNER.MODIFY.PENDING', 'LINK.OWNER.MODIFY' );

				$sql = 'SELECT EventId FROM ' . TABLE_PREFIX . 'Events
							WHERE Event IN ("' . implode('","', $events_to_delete) . '")';
				$event_ids = $this->Conn->GetCol($sql);

				if ($event_ids) {
					$sql = 'DELETE FROM ' . TABLE_PREFIX . 'EmailMessage
								WHERE EventId IN (' . implode(',', $event_ids) . ')';
					$this->Conn->Query($sql);

					$sql = 'DELETE FROM ' . TABLE_PREFIX . 'Events
								WHERE EventId IN (' . implode(',', $event_ids) . ')';
					$this->Conn->Query($sql);

					$sql = 'DELETE FROM ' . TABLE_PREFIX . 'Phrase
								WHERE Phrase IN ("la_event_link.owner.modify", "la_event_link.owner.modify.pending")';
					$this->Conn->Query($sql);
				}
			}
		}

		/**
		 * Update to 5.0.4-B1
		 *
		 * @param string $mode when called mode {before, after)
		 */
		function Upgrade_5_0_4_B1($mode)
		{
			if ($mode == 'after') {
				// check in-link custom fields if need to add to search config
				$custom_fields = Array (
					'LinkAddress' => "('CustomField', 'LinkAddress', 1, 1, 'la_fld_LinkAddress', 'lu_fld_LinkAddress', 'In-Link', 'la_section_BusinessLocation', 1, DEFAULT, 0, 'text', NULL, NULL, NULL, NULL, NULL, NULL, {CUSTOM_FIELD_ID})",
					'LinkCity' => "('CustomField', 'LinkCity', 1, 1, 'la_fld_LinkCity', 'lu_fld_LinkCity', 'In-Link', 'la_section_BusinessLocation', 2, DEFAULT, 0, 'text', NULL, NULL, NULL, NULL, NULL, NULL, {CUSTOM_FIELD_ID})",
					'LinkState' => "('CustomField', 'LinkState', 1, 1, 'la_fld_LinkState', 'lu_fld_LinkState', 'In-Link', 'la_section_BusinessLocation', 3, DEFAULT, 0, 'select', NULL, NULL, NULL, NULL, NULL, NULL, {CUSTOM_FIELD_ID})",
					'LinkZipCode' => "('CustomField', 'LinkZipCode', 1, 1, 'la_fld_LinkZipCode', 'lu_fld_LinkZipCode', 'In-Link', 'la_section_BusinessLocation', 4, DEFAULT, 0, 'text', NULL, NULL, NULL, NULL, NULL, NULL, {CUSTOM_FIELD_ID})",
					'LinkCountry' => "('CustomField', 'LinkCountry', 1, 1, 'la_fld_LinkCountry', 'lu_fld_LinkCountry', 'In-Link', 'la_section_BusinessLocation', 5, DEFAULT, 0, 'select', NULL, NULL, NULL, NULL, NULL, NULL, {CUSTOM_FIELD_ID})",
					'LinkPhone' => "('CustomField', 'LinkPhone', 1, 1, 'la_fld_LinkPhone', 'lu_fld_LinkPhone', 'In-Link', 'la_section_BusinessLocation', 6, DEFAULT, 0, 'text', NULL, NULL, NULL, NULL, NULL, NULL, {CUSTOM_FIELD_ID})",
				);

				// get all in-link custom fields ides at once
				$sql = 'SELECT CustomFieldId, FieldName
						FROM ' . TABLE_PREFIX . 'CustomField
						WHERE Type = 4 AND IsSystem = 0';
				$custom_field_ids = $this->Conn->GetCol($sql, 'FieldName');

				foreach ($custom_fields as $field_name => $custom_field_sql) {
					$sql = 'SELECT FieldName
							FROM ' . TABLE_PREFIX . 'SearchConfig
							WHERE (FieldName = ' . $this->Conn->qstr($field_name) . ') AND (LOWER(ModuleName) = "in-link")';
					$found = $this->Conn->GetOne($sql);

					if (!$found) {
						// replace sql and insert new search config record
						$sql = str_replace('{CUSTOM_FIELD_ID}', $custom_field_ids[$field_name], $custom_field_sql);
						$sql = 'INSERT INTO ' . TABLE_PREFIX . 'SearchConfig VALUES ' . $sql;
						$this->Conn->Query($sql);
					}
				}
			}
		}
	}