<?php
/**
* @version	$Id: link_helper.php 14253 2011-03-16 21:29:15Z alex $
* @package	In-Link
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class LinkHelper extends kHelper {

		/**
		 * Checks, that we have link to our website on given site url
		 *
		 * @param string $url
		 * @return bool
		 */
		function CheckReciprocalURL($url)
		{
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_TIMEOUT, 10);
			$html = curl_exec($ch);

			if (curl_errno($ch) != 0) {
				// connection error
				return false;
			}

			$info = curl_getinfo($ch);
			if ($info['http_code'] != 200) {
				// http error
				return false;
			}
			curl_close($ch);

			$reciprocal_url = rtrim($this->Application->BaseURL());

			if (preg_match('/<a[^<]*href=(["\']?)' . preg_quote($reciprocal_url, '/') . '[\\/]?.*(\\1).*>(.*)<\\/a.*>/sUi', $html, $ret)) {
				return true;
			}

			return false;
		}


		/**
		 * Returns grouping fields for "Duplicate Checker" section
		 *
		 * @param string $prefix_special
		 * @return Array
		 */
		function getGrouping($prefix_special)
		{
			// cut "sub" postfix from special
			$prefix_special = preg_replace('/(.*)-sub$/', '\\1', $prefix_special);
			$grouping = $this->Application->RecallVar($prefix_special . '_dupe_fields');

			if (!$grouping) {
				$grouping = '|Url|';
				$this->Application->StoreVar($prefix_special . '_dupe_fields', $grouping);
			}

			return explode('|', substr($grouping, 1, -1));
		}

	}