CREATE TABLE Link (
  LinkId int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) NOT NULL DEFAULT '',
  l1_Name varchar(255) NOT NULL DEFAULT '',
  l2_Name varchar(255) NOT NULL DEFAULT '',
  l3_Name varchar(255) NOT NULL DEFAULT '',
  l4_Name varchar(255) NOT NULL DEFAULT '',
  l5_Name varchar(255) NOT NULL DEFAULT '',
  AutomaticFilename tinyint(3) unsigned NOT NULL DEFAULT '1',
  Description text,
  l1_Description text,
  l2_Description text,
  l3_Description text,
  l4_Description text,
  l5_Description text,
  MetaKeywords varchar(255) DEFAULT NULL,
  MetaDescription text,
  Url varchar(255) NOT NULL DEFAULT '',
  CreatedOn int(10) unsigned DEFAULT NULL,
  Modified int(10) unsigned DEFAULT NULL,
  Expire int(10) unsigned DEFAULT NULL,
  Hits double(20,6) NOT NULL DEFAULT '0.000000',
  CachedRating varchar(10) NOT NULL DEFAULT '0',
  CachedVotesQty int(11) NOT NULL DEFAULT '0',
  CachedReviewsQty int(11) NOT NULL DEFAULT '0',
  CreatedById int(11) DEFAULT NULL,
  ModifiedById int(11) DEFAULT NULL,
  Priority int(11) NOT NULL DEFAULT '0',
  `Status` tinyint(4) NOT NULL DEFAULT '2',
  EditorsPick tinyint(4) NOT NULL DEFAULT '0',
  ResourceId int(11) DEFAULT NULL,
  HotItem tinyint(4) NOT NULL DEFAULT '2',
  PopItem tinyint(4) NOT NULL DEFAULT '2',
  NewItem tinyint(4) NOT NULL DEFAULT '2',
  OrgId int(11) DEFAULT NULL,
  CustomTemplate varchar(255) NOT NULL DEFAULT '',
  ReciprocalLinkFound tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (LinkId),
  UNIQUE KEY ResourceId (ResourceId),
  KEY sorting (Priority,`Name`),
  KEY Hits (Hits),
  KEY `Name` (`Name`),
  KEY l1_Name (l1_Name),
  KEY l2_Name (l2_Name),
  KEY l3_Name (l3_Name),
  KEY l4_Name (l4_Name),
  KEY l5_Name (l5_Name),
  KEY Description (Description(5)),
  KEY l1_Description (l1_Description(5)),
  KEY l2_Description (l2_Description(5)),
  KEY l3_Description (l3_Description(5)),
  KEY l4_Description (l4_Description(5)),
  KEY l5_Description (l5_Description(5)),
  KEY EditorsPick (EditorsPick),
  KEY CreatedOn (CreatedOn),
  KEY Modified (Modified,CreatedOn),
  KEY `Status` (`Status`),
  KEY HotItem (HotItem),
  KEY PopItem (PopItem),
  KEY NewItem (NewItem)
);

CREATE TABLE LinkValidation (
  LinkValidationId int(11) NOT NULL AUTO_INCREMENT,
  LinkId int(11) NOT NULL DEFAULT '0',
  ValidationTime int(11) DEFAULT NULL,
  ValidationCode varchar(50) DEFAULT NULL,
  ValidationStatus tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (LinkValidationId),
  UNIQUE KEY LinkId (LinkId),
  KEY ValidationStatus (ValidationStatus),
  KEY ValidationTime (ValidationTime)
);

CREATE TABLE Listings (
  ListingId int(11) NOT NULL auto_increment,
  ListingTypeId int(11) default '0',
  ItemResourceId int(11) default NULL,
  PurchasedOn int(11) default NULL,
  ExpiresOn int(11) default NULL,
  `Status` TINYINT(4) UNSIGNED NOT NULL DEFAULT '2',
  PendingRenewal tinyint(4) NOT NULL default '0',
  RenewalReminderSent tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (ListingId),
  KEY ListingTypeId (ListingTypeId),
  KEY ItemResourceId (ItemResourceId),
  KEY PurchasedOn (PurchasedOn),
  KEY ExpiresOn (ExpiresOn),
  KEY Status (Status),
  KEY RenewalReminderSent (RenewalReminderSent)
);

CREATE TABLE ListingTypes (
  ListingTypeId int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) NOT NULL DEFAULT '',
  Description text,
  Duration int(11) NOT NULL DEFAULT '0',
  DurationType int(11) NOT NULL DEFAULT '0',
  OnPurchaseEdPick tinyint(4) NOT NULL DEFAULT '3',
  OnPurchaseNew tinyint(4) NOT NULL DEFAULT '3',
  OnPurchasePop tinyint(4) NOT NULL DEFAULT '3',
  OnPurchaseHot tinyint(4) NOT NULL DEFAULT '3',
  OnPurchasePriorityAction tinyint(4) NOT NULL DEFAULT '0',
  OnPurchasePriorityValue tinyint(4) NOT NULL DEFAULT '1',
  OnPurchaseAddToCatEnabled tinyint(4) NOT NULL DEFAULT '0',
  OnPurchaseAddToCat int(11) NOT NULL DEFAULT '0',
  OnPurchaseCustomTemplate varchar(255) NOT NULL DEFAULT '',
  OnPurchaseStatus tinyint(4) NOT NULL DEFAULT '3',
  OnExpireEdPick tinyint(4) NOT NULL DEFAULT '3',
  OnExpireNew tinyint(4) NOT NULL DEFAULT '3',
  OnExpirePop tinyint(4) NOT NULL DEFAULT '3',
  OnExpireHot tinyint(4) NOT NULL DEFAULT '3',
  OnExpirePriorityAction tinyint(4) NOT NULL DEFAULT '0',
  OnExpirePriorityValue tinyint(4) NOT NULL DEFAULT '1',
  OnExpireRemoveFromCatEnabled tinyint(4) NOT NULL DEFAULT '0',
  OnExpireRemoveFromCat int(11) NOT NULL DEFAULT '0',
  OnExpireCustomTemplate varchar(255) NOT NULL DEFAULT '',
  OnExpireStatus tinyint(4) NOT NULL DEFAULT '3',
  RenewalReminder int(11) NOT NULL DEFAULT '0',
  EnableBuying tinyint(4) NOT NULL DEFAULT '0',
  ShopCartName varchar(255) DEFAULT NULL,
  Price double DEFAULT NULL,
  Recurring tinyint(4) NOT NULL DEFAULT '0',
  VirtualProductId int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (ListingTypeId),
  KEY VirtualProductId (VirtualProductId)
);

CREATE TABLE LinkCustomData (
  CustomDataId int(11) NOT NULL auto_increment,
  ResourceId int(10) unsigned NOT NULL default '0',
  KEY ResourceId (ResourceId),
  PRIMARY KEY  (CustomDataId)
);

CREATE TABLE LinkVisits (
  VisitId int(11) NOT NULL AUTO_INCREMENT,
  ResourceId int(11) DEFAULT NULL,
  PortalUserId int(11) NOT NULL DEFAULT '0',
  VisitTimestamp int(11) DEFAULT NULL,
  PRIMARY KEY (VisitId),
  KEY ResourceId (ResourceId),
  KEY PortalUserId (PortalUserId),
  KEY VisitTimestamp (VisitTimestamp)
);
