<?php
/**
* @version	$Id: install.php 12918 2009-11-12 19:15:51Z alex $
* @package	In-Link
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/
	$module_folder = 'in-link';

	if (!defined('IS_INSTALL')) {
		// separate module install
		define('IS_INSTALL', 1);
		define('ADMIN', 1);
		define('REL_PATH', $module_folder);
		define('FULL_PATH', realpath(dirname(__FILE__) . '/..') );

		include_once(FULL_PATH . '/core/kernel/startup.php');
		require_once FULL_PATH . '/core/install/install_toolkit.php';

		$toolkit = new kInstallToolkit();
	}
	else {
		// install, using installation wizard
		$toolkit =& $this->toolkit;
		/* @var $toolkit kInstallToolkit */
	}

	$application =& kApplication::Instance();
	$application->Init();

	if ($application->RecallVar('user_id') != -1) {
		die('restricted access!');
	}

	$category =& $toolkit->createModuleCategory('Directory', 'Link Directory', '#in-link/section_design#', 'in-link/img/menu_links.gif');

	$toolkit->RunSQL('/' . $module_folder . '/install/install_schema.sql');
	$toolkit->RunSQL('/' . $module_folder . '/install/install_data.sql', '{LinkCatId}', $category->GetID());
	$toolkit->ImportLanguage('/' . $module_folder . '/install/english');

	$toolkit->SetModuleRootCategory($module_folder, $category->GetID());

	$toolkit->linkCustomFields($module_folder, 'l', 4); // to create Custom Fields for Links
	$toolkit->linkCustomFields('KERNEL', 'c', 1); // to create ItemTemplate custom field
	$toolkit->setModuleItemTemplate($category, 'l', '#in-link/item_design#');

	$toolkit->finalizeModuleInstall($module_folder, true);