<!--##
<NAME>Links - Search Results</NAME>
<DESC>List of Links Search Results</DESC>
<SECTION>Platform||Links</SECTION>
##-->

<!--## PAGE TITLE ELEMENT ##-->
<inp2:m_DefineElement name="page_title">
	<inp2:m_Phrase label="lu_title_LinkSearchResults"/>
</inp2:m_DefineElement>
<!--## //PAGE TITLE ELEMENT ##-->

<!--## SIDE-BAR ELEMENT ##-->
<inp2:m_DefineElement name="sidebar">
	<div class="movable-area">
		<div class="movable-element">
			<inp2:m_RenderElement name="platform/elements/side_boxes/login.elm" design="blue_box"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="platform/elements/side_boxes/search.elm" design="blue_box"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="in-link/elements/side_boxes/quick_search.elm" design="blue_box"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="in-link/elements/side_boxes/action_box.elm" design="blue_box"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="in-link/elements/side_boxes/new.elm" design="blue_box" data_exists="1"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="in-link/elements/side_boxes/pop.elm" design="blue_box" data_exists="1"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="in-link/elements/side_boxes/pick.elm" design="blue_box" data_exists="1"/>
		</div>
	</div>
</inp2:m_DefineElement>
<!--## //SIDE-BAR ELEMENT ##-->

<inp2:m_DefineElement name="content">
	<div class="movable-area">
		<div class="movable-element">
			<inp2:m_include template="platform/elements/navigation_bar.elm" titles="lu_title_LinkSearchResults" templates="in-link/search/search_results"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement design="content_box">
				<inp2:l_InitList list_name="link_search_results" types="search" parent_cat_id="any" recursive="1"/>

				<inp2:m_Capture to_var="header">
					<inp2:m_Phrase label="lu_title_LinkSearchResults"/> (<inp2:l_TotalRecords list_name="link_search_results"/>)
				</inp2:m_Capture>

				<inp2:m_include template="in-link/elements/sorting.elm" list_name="link_search_results"/>

				<inp2:m_include template="in-link/elements/links.elm"/>
				<inp2:m_include template="platform/elements/search_results.elm"/>

				<!-- SEARCH SUGGESTION -->
				<inp2:m_if check="c_SpellingSuggestions">
					<div id="didyoumean">
						<strong>Did you mean:</strong> <a href="<inp2:c_SuggestionLink/>"><inp2:c_SpellingSuggestions/></a>
					</div>
				</inp2:m_if>
				<!-- //SEARCH SUGGESTION -->


				<!--## THESAURUS CONTENT ##-->
				<inp2:m_DefineElement name="thesaurus">
					<inp2:m_DefineElement name="narrow_search_elem">
						<li><a href="<inp2:m_Param name='url'/>"><inp2:m_Param name="term"/></a></li>
					</inp2:m_DefineElement>

					<inp2:m_if check="thesaurus_HasThesaurus">
						<div id="popularSearchTerms" class="highlightBox">
							<h2>Narrow Search By</h2>
							<ul>
								<inp2:thesaurus_PrintThesaurus render_as="narrow_search_elem"/>
							</ul>
						</div>
					</inp2:m_if>
				</inp2:m_DefineElement>
				<!--## /THESAURUS CONTENT ##-->

				<inp2:m_RenderElement name="thesaurus"/>


				<table class="fullwidth item-listing table-border">
					<inp2:l_ListLinks list_name="link_search_results" render_as="link_element" show_relevance="1"/>
				</table>

				<inp2:m_include template="platform/elements/pagination.elm" prefix="l" list_name="link_search_results"/>
			</inp2:m_RenderElement>
		</div>
	</div>
</inp2:m_DefineElement>

<inp2:m_include template="platform/designs/default_design.des" pass_params="1"/>