<?php
/**
* @version	$Id: listings_config.php 12499 2009-09-15 16:27:38Z dmitrya $
* @package	In-Link
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'ls',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'ListingsEventHandler','file'=>'listings_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'ListingsTagProcessor','file'=>'listings_tag_processor.php','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,

					'Hooks'				=>	Array(
												Array(
													'Mode' => hAFTER,
													'Conditional' => false,
													'HookToPrefix' => 'l',
													'HookToSpecial' => '*',
													'HookToEvent' => Array('OnBeforeDeleteOriginal'),
													'DoPrefix' => '',
													'DoSpecial' => '*',
													'DoEvent' => 'OnMoveEnhancement',
												),
											),

					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'page',
												3	=>	'event',
												4	=>	'mode',
											),

					'RegularEvents'		=>	Array(
													'listings_expiration' => Array('EventName' => 'OnCheckExpiredPaidListings', 'RunInterval' => 1800, 'Type' => reAFTER),
											),

   					'IDField' 			=>	'ListingId',
   					'StatusField'		=>	Array('Status', 'PendingRenewal'),
   					'TitleField'		=>	'LinkName',

					'TitlePresets'		=>	Array(
												'default'	=>	Array(	'new_status_labels'		=> Array('ls'=>'!la_title_AddingListing!'),
																		'edit_status_labels'	=> Array('ls'=>'!la_title_EditingListing!'),
																		'new_titlefield'		=> Array('ls'=>'!la_title_NewListing!'),
																),

												'listing_list' => Array('prefixes' => Array('ls_List'), 'format' => "!la_title_PaidListings!",),
												'listing_edit' => Array('prefixes' => Array('ls'), 'format' => "#ls_status# '#ls_titlefield#' - !la_title_General!",),
											),

					'PermSection'		=>	Array('main' => 'in-link:paid_listings'),

					'Sections'			=>	Array(
						'in-link:paid_listings_folder'	=>	Array(
							'parent'		=>	'in-link',
							'icon'			=>	'paid_listings',
							'label'			=>	'la_tab_PaidListings',
							'use_parent_header' => 1,
							'permissions'	=>	Array(),
							'priority'		=>	1,
							'type'			=>	stTREE,
						),

						'in-link:paid_listings'	=>	Array(
							'parent'		=>	'in-link:paid_listings_folder',
							'icon'			=>	'paid_listings',
							'label'			=>	'la_tab_Listings',
							'url'			=>	Array('t' => 'in-link/paid_listings/paid_listings_list', 'pass' => 'm'),
							'permissions'	=>	Array('view', 'add', 'edit', 'delete', 'advanced:approve', 'advanced:decline'),
							'priority'		=>	1.1, // <parent_priority>.<own_priority>, because this section replaces parent in tree
							'type'			=>	stTAB,
						),
					),

					'TableName'			=>	TABLE_PREFIX.'Listings',

					'ListSQLs'			=>	Array(	''=>'	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'Link item_table ON item_table.ResourceId = %1$s.ItemResourceId
															LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON u.PortalUserId = item_table.CreatedById'),

					'ItemSQLs'			=>	Array(	''=>'	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'Link item_table ON item_table.ResourceId = %1$s.ItemResourceId
															LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON u.PortalUserId = item_table.CreatedById'),

					'ListSortings'	=> 	Array(
												''	=>	Array(
																'Sorting' => Array('PurchasedOn' => 'desc'),
														)
										),

					'CalculatedFields'	=>	Array (
													''	=>	Array (
																	'LinkName'	=>	'CONCAT(item_table.Name, " (", item_table.Url, ")")',
																	'LinkOwner'	=>	'IF (ISNULL(u.Login), IF (item_table.CreatedById = -1, "root", IF (item_table.CreatedById = -2, "Guest", "n/a")), u.Login)',
															),
											),
					'Fields' => Array
						        (
						            'ListingId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0,),
						            'ListingTypeId' => Array('type' => 'int', 'formatter'=>'kOptionsFormatter', 'options_sql'=>'SELECT %s FROM '.TABLE_PREFIX.'ListingTypes ORDER BY Name', 'option_key_field'=>'ListingTypeId', 'option_title_field'=>'Name', 'default' => 0,),
						            'ItemResourceId' => Array('type' => 'int', 'required' => 1, 'unique' => Array('ItemResourceId'), 'error_field' => 'LinkName', 'default' => NULL),
						            'PurchasedOn' => Array('type' => 'int', 'formatter'=>'kDateFormatter','default'=>'#NOW#'),
						            'ExpiresOn' => Array('type' => 'int', 'formatter'=>'kDateFormatter','default' => '#NOW#','required'=>1),
						            'Status' => Array('type' => 'int', 'not_null' => 1, 'default' => 2, 'formatter'=>'kOptionsFormatter','options' => Array(1 => 'la_Active', 2 => 'la_Pending', 0 => 'la_Disabled'),'use_phrases' => 1),
						            'PendingRenewal' => Array('type' => 'int','formatter'=>'kOptionsFormatter','options' => Array(0 => 'la_NotPendingRenewal', 1 => 'la_PendingRenewal'),'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
						            'RenewalReminderSent' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
						        ),

					'VirtualFields'	=>	Array (
												'LinkName'	=>	Array ('type' => 'string'),
												'LinkOwner'	=>	Array ('type' => 'string'),
										),

					'FilterMenu'		=>	Array(
												'Groups' => Array(
													Array('mode' => 'AND', 'filters' => Array(0,1,2), 'type' => WHERE_FILTER),
													Array('mode' => 'AND', 'filters' => Array(3), 'type' => WHERE_FILTER),
												),

												'Filters' => Array(
													0	=>	Array('label' =>'la_Enabled', 'on_sql' => '', 'off_sql' => '%1$s.Status != 1' ),
													1	=>	Array('label' => 'la_Disabled', 'on_sql' => '', 'off_sql' => '%1$s.Status != 0'  ),
													2	=>	Array('label' => 'la_Pending', 'on_sql' => '', 'off_sql' => '%1$s.Status != 2'  ),
													3	=>	Array('label' => 'la_PendingRenewal', 'on_sql' => '', 'off_sql' => '%1$s.PendingRenewal != 1'  ),
												)
											),

					'Grids'	=> Array(
						'Default' => Array(
							'Icons' => Array(
								'default' => 'icon16_item.png',
								'1_0' => 'icon16_link.png',
								'0_0' => 'icon16_link_disabled.png',
								'2_0' => 'icon16_link_pending.png',
								'1_1' => 'icon16_link_pending.png',
								'0_1' => 'icon16_link_disabled.png',
								'2_1' => 'icon16_link_pending.png'),
								'module' => 'core',

							'Fields' => Array(
								'ListingId' => Array( 'title'=>'la_col_Id' , 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
								'LinkName' => Array( 'title'=>'la_col_LinkName' , 'data_block' => 'link_td', 'filter_block' => 'grid_like_filter', 'width' => 170, ),
								'ListingTypeId' => Array( 'title'=>'la_col_ListingTypeName' , 'data_block' => 'listing_type_td', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
								'LinkOwner' => Array( 'title'=>'la_col_LinkOwner', 'filter_block' => 'grid_like_filter', 'width' => 115, ),
								'PendingRenewal' => Array( 'title'=>'la_col_PendingRenewal', 'filter_block' => 'grid_options_filter', 'width' => 143, ),
								'PurchasedOn' => Array( 'title'=>'la_col_PurchasedOn', 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
								'ExpiresOn' => Array( 'title'=>'la_col_ExpiresOn', 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
							),
						),
					),

	);