<?php
/**
* @version	$Id: link_tag_processor.php 12304 2009-08-17 01:54:29Z dmitrya $
* @package	In-Link
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class LinkTagProcessor extends kCatDBTagProcessor {


	/**
	 * Returns object used in tag processor
	 *
	 * @access public
	 * @return kDBBase
	 */
	/*function &getObject($params = Array())
	{
		$object =& parent::getObject($params);

		// Forces item loading (compatibility with old theme)
		if (is_subclass_of($object, 'kDBItem')) {
			// force reload when using from old code
			$id = $this->Application->GetVar($this->Prefix.'_id');
			if ($object->isLoaded() && $id && ($object->GetID() != $id)) {
				$object->Load($id);
			}
		}

		return $object;
	}*/

	function getListingInfo($resource_id, $field = null)
	{
		$sql = 'SELECT *
				FROM '.$this->Application->getUnitOption('ls', 'TableName').'
				WHERE ItemResourceId = '.$resource_id;
		$listing_info = $this->Conn->GetRow($sql);
		return isset($field) ? $listing_info[$field] : $listing_info;
	}

	/**
	 * Detects listing enhancement status (enhanced or not)
	 *
	 * @param Array $params
	 * @return int
	 */
	function LinkIsEnhanced($params)
	{
		$object =& $this->getObject();
		/* @var $object kDBItem */

		if ($object->GetDBField('Status') == STATUS_PENDING || $object->GetDBField('Status') == STATUS_PENDING_EDITING) {
			return false;
		}

		$listing_type_id = $this->getListingInfo($object->GetDBField('ResourceId'), 'ListingTypeId');

		$this->Application->SetVar('lst_id', $listing_type_id); // compatibility with old-theme
		return $listing_type_id ? 1 : 0;
	}

	/**
	 * Detects if enhancement is pending approval
	 *
	 * @param Array $params
	 * @return int
	 */
	function EnhancementIsPending($params)
	{
		$object =& $this->getObject();
		/* @var $object kDBItem */

		$status = $this->getListingInfo($object->GetDBField('ResourceId'), 'Status');

		return $status == STATUS_PENDING ? 1 : 0;
	}

	function ListingTypeField($params)
	{
		$object =& $this->getObject();
		/* @var $object kDBItem */

		$lst_id = $this->getListingInfo($object->GetDBField('ResourceId'), 'ListingTypeId');

		$lst_object =& $this->Application->recallObject('lst', null, Array('skip_autoload' => true));
		$lst_object->Load($lst_id);

		return $lst_object->GetField( $this->SelectParam($params, 'name,field') );
	}

	function EnhancementField($params)
	{
		$object =& $this->getObject();
		/* @var $object kDBItem */

		$listing_id = $this->getListingInfo($object->GetDBField('ResourceId'), 'ListingId');

		$listing_object =& $this->Application->recallObject('ls', null, Array('skip_autoload' => true));
		$listing_object->Load($listing_id);

		return $listing_object->GetField( $this->SelectParam($params, 'name,field') );
	}

	function IsRenewalPeriod($params)
	{
		$object =& $this->getObject();
		/* @var $object kDBItem */

		$listing_info = $this->getListingInfo($object->GetDBField('ResourceId'));

		$sql = 'SELECT RenewalReminder
				FROM '.$this->Application->getUnitOption('lst', 'TableName').'
				WHERE ListingTypeId = '.$listing_info['ListingTypeId'];
		$renewal_interval = $this->Conn->GetOne($sql) * 3600 * 24;

		return ($listing_info['ExpiresOn'] - adodb_mktime() < $renewal_interval) ? 1 : 0;
	}

	function FirstListingType($params)
	{
		static $first = true;
		if ($first) {
			$first = false;
			return true;
		}
		else {
			return false;
		}
	}

	function IsReocurringEnhancement($params)
	{
		$params['name'] = 'Recurring';
		return $this->ListingTypeField($params);
	}

	function EnhanceUsingInCommerce($params)
	{
		if (!$this->Application->isModuleEnabled('In-Commerce')) {
			return 0;
		}

		$object =& $this->getObject();
		/* @var $object kDBItem */

		$listtype_id = $this->getListingInfo($object->GetDBField('ResourceId'), 'ListingTypeId');

		$lst_object =& $this->Application->recallObject('lst', null, Array('skip_autoload' => true));
		$lst_object->Load($listtype_id);

		return $lst_object->GetDBField('EnableBuying');
	}

	function ClickLink($params)
	{
		$object =& $this->getObject($params);

		return $this->Application->HREF($params['t'], '', Array('l_id' => $object->GetID(), 'pass'=>'all,l' ));
	}

	function ListRelatedLinks($params)
	{
		return $this->PrintList2($params);
	}

	function LinkLink($params)
	{
		return $this->ItemLink($params, 'link');
	}

	function ListingDescription($params)
	{
		$listing_type =& $this->Application->recallObject('lst');
		/* @var $listing_type kDBItem */

		return $listing_type->GetDBField('Description');
	}

	function ListingTypeDetailsLink($params)
	{
		$listing_type =& $this->Application->recallObject('lst', null, Array ('raise_warnings' => 0));
		/* @var $listing_type kDBList */

		$params['lst_id'] = $listing_type->isLoaded() ? $listing_type->GetID() : $this->Application->Parser->GetParam('key');

		return $this->Application->ProcessParsedTag('m', 'Link', $params);
	}

	/**
	 * Register hit & go to link url
	 *
	 * @param Array $params
	 */
	function FollowLocation($params)
	{
		$object =& $this->getObject();
		/* @var $object kCatDBItem */

		if (!$object->isLoaded()) {
			trigger_error('No Link ID for redirect', E_USER_ERROR);
		}

		$object->RegisterHit();

		// save user and time
		if (!$this->Application->IsAdmin() && $this->Application->LoggedIn()) {
			$resource_id = $object->GetDBField('ResourceId');
			$user_id = $this->Application->RecallVar('user_id');

			$link_visit = $this->Application->recallObject('l-visit', null, Array ('skip_autoload' => true));
			/* @var $link_visit kDBItem */

			$link_visit->Load( Array ('ResourceId' => $resource_id, 'PortalUserId' => $user_id) );
			if ($link_visit->isLoaded()) {
				// for existing visits update date
				$link_visit->SetDBField('VisitTimestamp_date', adodb_mktime());
				$link_visit->SetDBField('VisitTimestamp_time', adodb_mktime());
			}
			else {
				// for new visits set user & link, visit will be set as default value
				$link_visit->SetDBField('ResourceId', $resource_id);
				$link_visit->SetDBField('PortalUserId', $user_id);
			}

			$status = $link_visit->isLoaded() ? $link_visit->Update() : $link_visit->Create();
		}

		$url = $object->GetDBField('Url');
		if (!preg_match('/^(http|ftp|mailto:)(.*)/U', $url)) {
			$url = 'http://'.$url;
		}

		$this->Application->Redirect('external:'.$url);
	}

	/**
	 * Returns formatted address (from custom fields) for using with google
	 *
	 * @param Array $params
	 * @return string
	 */
	function GetGoogleAddress($params)
	{
		$object =& $this->getObject();

		if (isset($params['display_info']) && $params['display_info']) {
			$ret = $object->GetField('cust_LinkAddress') ? $object->GetField('cust_LinkAddress').'<BR/>' : '';
			$ret .= $object->GetField('cust_LinkCity') ? $object->GetField('cust_LinkCity').',' : '';
			$ret .= $object->GetField('cust_LinkState') ? $object->GetField('cust_LinkState') : '';
			$ret .= $object->GetField('cust_LinkZipCode') ? $object->GetField('cust_LinkZipCode').'<BR/>' : '';
			$ret .= $object->GetField('cust_LinkCountry') ? $object->GetField('cust_LinkCountry').'<BR/>' : '';
			$ret .= $object->GetField('cust_LinkPhone') ? '<b>'.$this->Application->Phrase('lu_fld_LinkPhone').':</b> '.$object->GetField('cust_LinkPhone') : '';

			return $ret;
		}

		$ret = $object->GetField('cust_LinkAddress') ? $object->GetField('cust_LinkAddress').',' : '';
		$ret .= $object->GetField('cust_LinkCity') ? $object->GetField('cust_LinkCity').',' : '';
		$ret .= $object->GetField('cust_LinkState') ? $object->GetField('cust_LinkState').',' : '';
		$ret .= $object->GetField('cust_LinkZipCode') ? $object->GetField('cust_LinkZipCode').',' : '';
		$ret .= $object->GetField('cust_LinkCountry') ? $object->GetField('cust_LinkCountry') : '';

		return $ret;
	}

	/**
	 * Returns timestamp of last link visit for logged in users only.
	 *
	 * @param Array $params
	 * @return string
	 */
	function LastVisited($params)
	{
		if (!$this->Application->LoggedIn()) {
			// we don't gather link visit statistics for Guests
			return '';
		}

		static $link_visited = Array ();

		$object =& $this->getObject();
		/* @var $object kDBList */

		if (!isset($link_visited[$this->Special])) {
			$resource_ids = $object->GetCol('ResourceId');
			$user_id = $this->Application->RecallVar('user_id');

			$table_name = $this->Application->getUnitOption('l-visit', 'TableName');
			$sql = 'SELECT VisitTimestamp, ResourceId
					FROM '.$table_name.'
					WHERE (PortalUserId = '.$user_id.') AND (ResourceId IN ('.implode(',', $resource_ids).'))';
			$link_visited[$this->Special] = $this->Conn->GetCol($sql, 'ResourceId');
		}

		if (!isset($link_visited[$this->Special][$object->GetDBField('ResourceId')])) {
			// link has no visit information for current user
			return '';
		}

		$link_visit = $link_visited[$this->Special][$object->GetDBField('ResourceId')];

		if (isset($params['formatted']) && $params['formatted']) {
			// format the date
			$lang =& $this->Application->recallObject('lang.current');

			if (isset($params['display_time']) && $params['display_time']) {
				$display_format = $lang->GetDBField('DateFormat').' @ '.$lang->GetDBField('TimeFormat');
			}
			else {
				$display_format = $lang->GetDBField('DateFormat');
			}

			return adodb_date($display_format, $link_visit);
		}

		return $link_visit;
	}

	/**
	 * Checks if specified Custom Fields and condition are true
	 *
	 * @param Array $params
	 * @return string
	 */
	function HasValue($params)
	{
		$condition = isset($params['condition']) ? strtolower($params['condition']) : false;
		$fields = isset($params['fields']) ? $params['fields'] : false;
		if (!$fields || !in_array($condition, Array('or', 'and'))) {
			// required parameters not passed
			return false;
		}

		$fields = explode(',', $fields);

		$object =& $this->getObject();
		/* @var $object kDBList */

		switch ($condition) {
			case 'or':
				foreach ($fields as $field) {
					if (strlen($object->GetDBField($field))) {
						return true;
					}
				}
				break;

			case 'and':
				foreach ($fields as $field) {
					if (!strlen($object->GetDBField($field))) {
						return false;
					}
				}
				break;
		}

		return $condition == 'and' ? true : false;
	}

	/**
	 * Gets and parses custom details template or default one
	 *
	 * @param Array $params
	 * @return string
	 */
	function DisplayDetailTemplate($params)
	{
		$object =& $this->getObject($params);
		/* @var $object kDBItem */

		$template_name = $object->GetDBField('CustomTemplate');
		if (!$template_name || !$this->Application->TemplatesCache->TemplateExists($template_name)) {
			$template_name = $params['default_template'];
		}

		$block_params['name'] = $template_name;

		// parse template
		return $this->Application->ParseBlock($block_params);
	}

	/**
	 * Changes title preset of "Duplicate checker" section to show current grouping
	 *
	 * @param Array $params
	 */
	function ModifyUnitConfig($params)
	{
		$grid = array_key_exists('grid', $params) ? $params['grid'] : false;
		if ($grid != 'Duplicates') {
			// only for "Duplicate Checker" section
			return ;
		}

		$link_helper =& $this->Application->recallObject('LinkHelper');
		/* @var $link_helper LinkHelper */

		// 1. get current grouping
		$grouping = $link_helper->getGrouping( $this->getPrefixSpecial() );

		// 2. replace field names in grouping with their corresponding column titles
		$grids = $this->Application->getUnitOption($this->Prefix, 'Grids');
		foreach ($grouping as $index => $group_field) {
			$group_field = preg_replace('/^l[\d]+_/', '', $group_field); // remove ml prefix
			$grouping[$index] = $this->Application->Phrase($grids[$grid]['Fields'][$group_field]['title']);
		}

		// 3. patch resulting title preset
		$concat_with = "' " . $this->Application->Phrase('la_and') . " '";
		$title_presets = $this->Application->getUnitOption($this->Prefix, 'TitlePresets');
		$title_presets['duplicate_links'] = str_replace('%s', "'" . implode($concat_with, $grouping) . "'", $title_presets['duplicate_links']);

		$this->Application->setUnitOption($this->Prefix, 'TitlePresets', $title_presets);
	}

	/**
	 * Allows to modify block params & current list record before PrintList parses record
	 *
	 * @param kDBList $object
	 * @param Array $block_params
	 */
	function PrepareListElementParams(&$object, &$block_params)
	{
		$grid = array_key_exists('grid', $block_params) ? $block_params['grid'] : false;
		if ($grid != 'Duplicates') {
			// only for "Duplicate Checker" section
			return ;
		}

		static $grouping = null;

		if (!isset($grouping)) {
			$link_helper =& $this->Application->recallObject('LinkHelper');
			/* @var $link_helper LinkHelper */

			// 1. get current grouping
			$grouping = $link_helper->getGrouping( $this->getPrefixSpecial() );
		}

		$fields_hash =& $object->getCurrentRecord();

		$key_fields = Array ();
		foreach ($grouping as $group_field) {
			$key_fields[$group_field] = $fields_hash[$group_field];
		}

		$fields_hash['LinkId'] = base64_encode( serialize($key_fields) );
	}
}