<?php
/**
* @version	$Id: link_validation_config.php 12488 2009-09-15 04:05:23Z dmitrya $
* @package	In-Link
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'link-validation',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'LinkValidationEventHandler', 'file' => 'link_validation_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'LinkValidationTagProcessor', 'file' => 'link_validation_tp.php', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'Hooks' => Array (
			Array (
				'Mode' => hAFTER,
				'Conditional' => true,
				'HookToPrefix' => 'l',
				'HookToSpecial' => '*',
				'HookToEvent' => Array('OnAfterConfigRead'),
				'DoPrefix' => '',
				'DoSpecial' => '*',
				'DoEvent' => 'OnPrepareLinkEditing',
			),
		),

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'event',
			4 => 'mode',
		),

		'RegularEvents' => Array (
			'link_validation' => Array ('EventName' => 'OnCronValidation', 'RunInterval' => 3600*24, 'Type' => reAFTER),
		),

		'IDField' => 'LinkValidationId',

		'TableName' => TABLE_PREFIX.'LinkValidation',

		'StatusField' => Array ('ValidationStatus', 'LinkStatus'),

		'TitlePresets' => Array (
			'link_validation_list' => Array ('prefixes' => Array ('link-validation_List'), 'format' => "!la_tab_LinkValidation!"),
			'link_validation_progress' => Array ('format' => '!la_tab_ValidatingLinks!'),
		),

		'PermSection' => Array('main' => 'in-link:link_validation'),

		'Sections' => Array (
			'in-link:link_validation' => Array (
				'parent'		=>	'in-link',
				'icon'			=>	'in-link:validate',
				'label'			=>	'la_tab_LinkValidation',
				'url'			=>	Array('t' => 'in-link/link_validation/link_validation_list', 'pass' => 'm'),
				'permissions'	=>	Array('view', 'advanced:continue', 'advanced:restart', 'advanced:validate', 'advanced:reset'),
				'priority'		=>	3,
				'type'			=>	stTREE,
			),
		),

		'FilterMenu' => Array (
			'Groups' => Array(
				Array('mode' => 'AND', 'filters' => Array('show_valid', 'show_invalid', 'show_not_validated'), 'type' => WHERE_FILTER),
			),

			'Filters' => Array (
				'show_valid' => Array ('label' =>'la_Text_Valid', 'on_sql' => '', 'off_sql' => '%1$s.ValidationStatus != ' . LINK_VALIDATION_VALID . ' OR %1$s.ValidationStatus IS NULL'),
				'show_invalid' => Array ('label' => 'la_Text_Invalid', 'on_sql' => '', 'off_sql' => '%1$s.ValidationStatus != ' . LINK_VALIDATION_INVALID . ' OR %1$s.ValidationStatus IS NULL'),
				'show_not_validated' => Array ('label' => 'la_Text_Not_Validated', 'on_sql' => '', 'off_sql' => '%1$s.ValidationStatus != ' . LINK_VALIDATION_NOT_VALIDATED . ' OR %1$s.ValidationStatus IS NOT NULL'),
			)
		),

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s
					FROM ' . TABLE_PREFIX . 'Link l
					LEFT JOIN %1$s ON %1$s.LinkId = l.LinkId
					LEFT JOIN ' . TABLE_PREFIX . 'CategoryItems ci ON ci.ItemResourceId = l.ResourceId
					LEFT JOIN '.TABLE_PREFIX.'Category c ON c.CategoryId = ci.CategoryId',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('LinkValidationId' => 'desc'),
			)
		),

		'CalculatedFields' => Array (
			'' => Array (
				'ForeignLinkId' => 'l.LinkId',
				'LinkName' => 'l.Name',
				'LinkUrl' => 'l.Url',
				'LinkCreatedOn' => 'l.CreatedOn',
				'LinkStatus' => 'l.Status',
				'LinkValidationStatus' => 'IF(%1$s.ValidationStatus IS NULL, ' . LINK_VALIDATION_NOT_VALIDATED . ', %1$s.ValidationStatus)',

				'CategoryId' => 'ci.CategoryId',
			),
		),

		'Fields' => Array (
			'LinkValidationId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'LinkId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'ValidationTime' => Array ('type' => 'float', 'formatter' => 'kDateFormatter', 'not_null' => 1, 'default' => 0),
			'ValidationCode' => Array (
				'type' => 'string',
				'formatter' => 'kOptionsFormatter', 'options' => Array (200 => '200 OK', 301 => '301 Moved Permanently', 302 => '302 Found', 400 => '400 Bad Request', 403 => '403 Forbidden', 404 => '404 Not Found', 500 => '500 Internal Server Error'),
				'max_len' => 50, 'default' => NULL
			),
			'ValidationStatus' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_Text_Not_Validated', 1 => 'la_Text_Valid', 2 => 'la_Text_Invalid'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0
			),
		),

		'VirtualFields' => Array (
			'ForeignLinkId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'LinkName' => Array('type' => 'string', /*'formatter' => 'kMultiLanguage',*/ 'not_null' => 1, 'max_len' => 255, 'default' => ''),
			'LinkUrl' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
			'LinkCreatedOn' => Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
			'LinkStatus' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Active', 2 => 'la_Pending', 0 => 'la_Disabled'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 2),
			'LinkValidationStatus' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_Text_Not_Validated', 1 => 'la_Text_Valid', 2 => 'la_Text_Invalid'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0
			),

			// for category path drawing
			'CategoryId' => Array ('type' => 'int', 'default' => 0),
			'CachedNavbar' => Array ('type' => 'string', 'default' => ''),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array (
					'default' => 'icon16_link.png',
					// for valid links
					LINK_VALIDATION_VALID . '_' . STATUS_DISABLED => 'icon16_valid_disabled.gif',
					LINK_VALIDATION_VALID . '_' . STATUS_ACTIVE => 'icon16_valid.gif',
					LINK_VALIDATION_VALID . '_' . STATUS_PENDING => 'icon16_valid_pend.gif',

					// for invalid links
					LINK_VALIDATION_INVALID . '_' . STATUS_DISABLED => 'icon16_invalid_disabled.gif',
					LINK_VALIDATION_INVALID . '_' . STATUS_ACTIVE => 'icon16_invalid.gif',
					LINK_VALIDATION_INVALID . '_' . STATUS_PENDING => 'icon16_invalid_pend.gif',

					// for not validated links
					LINK_VALIDATION_NOT_VALIDATED . '_' . STATUS_DISABLED => 'icon16_not_validated_disabled.gif',
					LINK_VALIDATION_NOT_VALIDATED . '_' . STATUS_ACTIVE => 'icon16_not_validated.gif',
					LINK_VALIDATION_NOT_VALIDATED . '_' . STATUS_PENDING => 'icon16_not_validated_pend.gif',

					'_' . STATUS_DISABLED => 'icon16_not_validated_disabled.gif',
					'_' . STATUS_ACTIVE => 'icon16_not_validated.gif',
					'_' . STATUS_PENDING => 'icon16_not_validated_pend.gif',
				),

				'Fields' => Array (
					'ForeignLinkId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'module' => 'In-Link', 'width' => 60, ),
					'LinkName' => Array ('title' => 'la_col_LinkName', 'data_block' => 'grid_link_name_td', 'filter_block' => 'grid_like_filter', 'first_chars' => 30, 'width' => 180, ),
					'LinkUrl' => Array ('title' => 'la_col_LinkUrl', 'data_block' => 'grid_url_td', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
					'LinkValidationStatus' => Array ('title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 87, ),
					'ValidationCode' => Array ('title' => 'la_col_ValidationCode', 'filter_block' => 'grid_options_filter', 'width' => 155, ),
					'ValidationTime' => Array ('title' => 'la_col_ValidatedOn', 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
					'LinkCreatedOn' => Array ('title' => 'la_col_CreatedOn', 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
				),
			),
		),
	);