<?php
/**
* @version	$Id: listings_tag_processor.php 16517 2017-01-20 14:12:38Z alex $
* @package	In-Link
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class ListingsTagProcessor extends kDBTagProcessor  {

	/**
	 * Returns a link for editing product
	 *
	 * @param Array $params
	 * @return string
	 */
	function ListingTypeLink($params)
	{
		/** @var kDBItem $object */
		$object = $this->getObject($params);

		return $this->Application->HREF($params['edit_template'],'', Array(
				'm_opener'		=>	'd',
				'lst_mode'		=>	't',
				'lst_event'		=>	'OnEdit',
				'lst_id'		=>	$object->GetDBField('ListingTypeId'),
				'pass'			=>	'all,lst'
			), 'index.php');
	}

	function LinkEditLink($params)
	{
		/** @var kDBItem $object */
		$object = $this->getObject($params);

		$sql = 'SELECT '.$this->Application->getUnitOption('l', 'IDField').'
				FROM '.$this->Application->getUnitOption('l', 'TableName').'
				WHERE ResourceId = '.$object->GetDBField('ItemResourceId');

		return $this->Application->HREF($params['edit_template'],'', Array(
				'm_opener'	=>	'd',
				'l_mode'	=>	't',
				'l_event'	=>	'OnEdit',
				'l_id'		=>	$this->Conn->GetOne($sql),
				'pass'		=>	'all,l'
			));
	}

	protected function ExpirationDate($params)
	{
		return $this->_expirationField($params, 'DateFormat');
	}

	protected function ExpirationTime($params)
	{
		return $this->_expirationField($params, 'TimeFormat');
	}

	protected function _expirationField($params, $format_field)
	{
		/** @var kDBItem $object */
		$object = $this->getObject($params);

		/** @var kDBItem $listing_type */
		$listing_type = $this->Application->recallObject( 'lst', 'lst', $params );

		$dur_type_mapping = Array (
			1 => 1, 2 => 60, 3 => 3600, 4 => 3600 * 24,
			5 => 3600 * 24 * 7, 6 => 3600 * 24 * 365 / 12, 7 => 3600 * 24 * 365
		);

		$duration = $listing_type->GetDBField('Duration');
		$duration_type = $listing_type->GetDBField('DurationType');
		$expiration_interval = $duration * $dur_type_mapping[$duration_type];
		$expiration_date = adodb_mktime() + $expiration_interval;

		/** @var LanguagesItem $lang */
		$lang = $this->Application->recallObject('lang.current');

		return adodb_date($lang->GetDBField($format_field), $expiration_date);
	}
}