<?php
/**
* @version	$Id: admin_config.php 15718 2013-03-25 17:18:24Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'adm',
		'ItemClass' => Array ('class' => 'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
		'EventHandlerClass' => Array ('class' => 'AdminEventsHandler', 'file' => 'admin_events_handler.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'AdminTagProcessor', 'file' => 'admin_tag_processor.php', 'build_event' => 'OnBuild'),

		'QueryString' => Array (
			1 => 'event',
		),

		'ScheduledTasks' => Array(
			'optimize_performance' => Array('EventName' => 'OnOptimizePerformance', 'RunSchedule' => '0 0 * * *'),
		),

		'TitlePresets' => Array (
			'tree_root'		=>	Array ('format' => '!la_section_overview!'),

			'tree_reports'	=>	Array ('format' => '!la_section_overview!'),

			'tree_system'	=>	Array ('format' => '!la_section_overview!'),

			'tree_tools'	=>	Array ('format' => '!la_section_overview!'),

			'system_tools'	=>	Array ('format' => '!la_title_SystemTools!'),

			'backup'		=>	Array ('format' => '!la_performing_backup! - !la_Step! <span id="step_number"></span>'),
			'import'		=>	Array ('format' => '!la_performing_import! - !la_Step! <span id="step_number"></span>'),
			'restore'		=>	Array ('format' => '!la_performing_restore! - !la_Step! <span id="step_number"></span>'),
			'server_info'	=>	Array ('format' => '!la_tab_ServerInfo!'),
			'sql_query'		=>	Array ('format' => '!la_tab_QueryDB!'),

			'no_permissions'	=>	Array ('format' => '!la_title_NoPermissions!'),

			'column_picker'	=>	Array ('format' => '!la_title_ColumnPicker!'),
			'csv_export'	=>	Array ('format' => '!la_title_CSVExport!'),
			'csv_import'	=>	Array ('format' => '!la_title_CSVImport!'),
		),


		'PermSection' => Array ('main' => 'in-portal:service'),

		'Sections' => Array (
			'in-portal:root'	=>	Array (
				'parent'		=>	null,
				'icon'			=>	'site',
				'label'			=>	'SITE_NAME',
				'url'			=>	Array ('t' => 'index', 'pass' => 'm', 'pass_section' => true, 'no_amp' => 1),
				'permissions'	=>	Array ('view'),
				'priority'		=>	0,
				'container'		=>	true,
				'type'			=>	stTREE,
				'icon_module' => 'core',
			),

			'in-portal:service'	=>	Array (
				'parent'		=>	'in-portal:tools',
				'icon'			=>	'service',
				'label'			=>	'la_tab_Service',
				'url'			=>	Array ('t' => 'tools/system_tools', 'pass' => 'm'),
				'permissions'	=>	Array ('view', 'edit'),
				'priority'		=>	6,
				'type'			=>	stTREE,
			),
		),

		'ListSQLs' => Array (
			'' => '', // to prevent warning
		),

		'Fields' => Array (), // we need empty array because kernel doesn't use virtual fields else
		'VirtualFields' => Array (
			'ImportFile' => Array (
				'type' => 'string',
				'formatter' => 'kUploadFormatter', 'max_size' => MAX_UPLOAD_SIZE, // in Bytes !
				'error_msgs' => Array (
					'cant_open_file' => '!la_error_CantOpenFile!',
					'no_matching_columns' => '!la_error_NoMatchingColumns!',
				),
				'file_types' => '*.csv', 'files_description' => '!la_hint_CSVFiles!',
				'upload_dir' => '/system/import/', // relative to project's home
				'multiple' => false, 'direct_links' => false,
				'default' => null,
			),

			'Content' => Array ('type' => 'string', 'default' => ''),
		),
	);
