<?php
/**
* @version	$Id: filesize_formatter.php 14748 2011-11-09 09:35:48Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class kFilesizeFormatter extends kFormatter {

	/**
	 * Formats value of a given field
	 *
	 * @param string $value
	 * @param string $field_name
	 * @param kDBItem|kDBList $object
	 * @param string $format
	 * @return string
	 */
	function Format($value, $field_name, &$object, $format=null)
	{
		if ($value >= 1099511627776) {
			$return = round($value / 1024 / 1024 / 1024 / 1024, 2);
			$suffix = "Tb";
		} elseif ($value >= 1073741824) {
			$return = round($value / 1024 / 1024 / 1024, 2);
			$suffix = "Gb";
		} elseif ($value >= 1048576) {
			$return = round($value / 1024 / 1024, 2);
			$suffix = "Mb";
		} elseif ($value >= 1024) {
			$return = round($value / 1024, 2);
			$suffix = "Kb";
		} else {
			$return = $value;
			$suffix = "B";
		}
		$return .= ' '.$suffix;
		return $return;
	}
}