<?php
/**
* @version	$Id: scheduled_tasks_config.php 15433 2012-07-12 14:51:05Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'scheduled-task',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'ScheduledTaskEventHandler', 'file' => 'scheduled_task_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
			5 => 'mode',
		),

		'Hooks'	=>	Array (
			Array (
				'Mode' => hAFTER,
				'Conditional' => false,
				'HookToPrefix' => 'adm',
				'HookToSpecial' => '*',
				'HookToEvent' => Array ('OnAfterCacheRebuild'),
				'DoPrefix' => '',
				'DoSpecial' => '*',
				'DoEvent' => 'OnRefresh',
			),
		),

		'IDField' => 'ScheduledTaskId',

		'TableName' => TABLE_PREFIX . 'ScheduledTasks',

		'TitleField' => 'Name',

		'StatusField' => Array ('Status'),

		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array ('scheduled-task' => '!la_title_AddingScheduledTask!'),
				'edit_status_labels' => Array ('scheduled-task' => '!la_title_EditingScheduledTask!'),
				'new_titlefield' => Array ('scheduled-task' => '!la_title_NewScheduledTask!'),
			),

			'scheduled_task_list' => Array (
				'prefixes' => Array ('scheduled-task_List'), 'format' => "!la_title_ScheduledTasks!",
				'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'approve', 'decline', 'process', 'cancel', 'view', 'dbl-click'),
				),

			'scheduled_task_edit' => Array (
				'prefixes' => Array ('scheduled-task'), 'format' => "#scheduled-task_status# '#scheduled-task_titlefield#'",
				'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
			),
		),

		'PermSection' => Array('main' => 'in-portal:scheduled_tasks'),

		'Sections' => Array (
			'in-portal:scheduled_tasks' => Array (
				'parent'		=>	'in-portal:website_setting_folder',
				'icon'			=>	'conf_agents',
				'label'			=>	'la_title_ScheduledTasks',
				'url'			=>	Array('t' => 'scheduled_tasks/scheduled_task_list', 'pass' => 'm'),
				'permissions'	=>	Array('view', 'add', 'edit', 'delete'),
				'priority'		=>	6,
				'type'			=>	stTREE,
			),
		),

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s FROM %1$s',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('Name' => 'asc'),
			)
		),

		'Fields' => Array (
			'ScheduledTaskId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),

			'Name' => Array (
				'type' => 'string', 'max_len' => 255,
				'unique' => Array (),
				'required' => 1, 'not_null' => 1, 'default' => ''
			),

			'Type' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_User', 2 => 'la_opt_System'), 'use_phrases' => 1,
				'required' => 1, 'not_null' => 1, 'default' => 1
			),
			'Status' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_Active', 0 => 'la_opt_Disabled'), 'use_phrases' => 1,
				'required' => 1, 'not_null' => 1, 'default' => 1
			),
			'Event' => Array (
				'type' => 'string', 'max_len' => 255,
				'required' => 1, 'not_null' => 1, 'default' => ''
			),
			'RunSchedule' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => '* * * * *'),
			'LastRunOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),

			'LastRunStatus' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_Success', 0 => 'la_opt_Failed', 2 => 'la_opt_Running'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 1
			),

			'NextRunOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
			'RunTime' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'Timeout' => Array (
				'type' => 'int',
				'min_value_inc' => 1,
				'not_null' => 1, 'default' => NULL
			),
			'LastTimeoutOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
			'SiteDomainLimitation' => Array (
				'type' => 'string', 'max_len' => 255,
				'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'SiteDomains ORDER BY DomainName ASC', 'option_key_field' => 'DomainId', 'option_title_field' => 'DomainName', 'multiple' => 1,
				'not_null' => 1, 'default' => ''
			),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array (
					'default' => 'icon16_item.png',
					0 => 'icon16_disabled.png',
				),
				'Fields' => Array (
					'ScheduledTaskId' => Array ('title' => 'column:la_fld_Id', 'filter_block' => 'grid_range_filter', 'width' => 80),
					'Name' => Array ('filter_block' => 'grid_like_filter', 'width' => 200),
					'Type' => Array ('filter_block' => 'grid_options_filter', 'width' => 60),
					'Event' => Array ('filter_block' => 'grid_like_filter', 'width' => 280),
					'RunSchedule' => Array ('filter_block' => 'grid_range_filter', 'width' => 100),
					'LastRunOn' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 145),
					'RunTime' => Array ('filter_block' => 'grid_range_filter', 'width' => 100),
					'LastRunStatus' => Array ('filter_block' => 'grid_options_filter', 'width' => 90),
					'NextRunOn' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 145),
					'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 65),
					'Timeout' => Array ('filter_block' => 'grid_range_filter', 'width' => 85),
					'LastTimeoutOn' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 145),
					'SiteDomainLimitation' => Array ('data_block' => 'grid_picker_td', 'filter_block' => 'grid_multioptions_filter', 'separator' => ', ', 'width' => 145),
				),
			),
		),
	);