<?php
/**
* @version	$Id: startup.php 15445 2012-07-13 16:44:00Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	define('KERNEL_PATH', FULL_PATH . '/core/kernel');

	$globals_start = microtime(true);
	include_once(KERNEL_PATH . '/globals.php');	// some non-OOP functions and kUtil static class used through kernel
	include_once(KERNEL_PATH . '/utility/multibyte.php');	// emulating multi-byte php extension
	$globals_end = microtime(true);

	$vars = kUtil::getConfigVars();

	$charset = isset($vars['WebsiteCharset']) ? $vars['WebsiteCharset'] : 'utf-8';
	define('CHARSET', $charset);

	$admin_directory = isset($vars['AdminDirectory']) ? $vars['AdminDirectory'] : '/admin';
	define('ADMIN_DIRECTORY', $admin_directory);

	$admin_Presets_directory = isset($vars['AdminPresetsDirectory']) ? $vars['AdminPresetsDirectory'] : ADMIN_DIRECTORY;
	define('ADMIN_PRESETS_DIRECTORY', $admin_Presets_directory);

	$https_mark = getArrayValue($_SERVER, 'HTTPS');
	define('PROTOCOL', ($https_mark == 'on') || ($https_mark == '1') ? 'https://' : 'http://');

	if ( isset($_SERVER['HTTP_HOST']) ) {
		// accessed from browser
		$http_host = $_SERVER['HTTP_HOST'];
	}
	else {
		// accessed from command line
		$http_host = $vars['Domain'];
		$_SERVER['HTTP_HOST'] = $vars['Domain'];
	}

	$port = isset($_SERVER['SERVER_PORT']) ? $_SERVER['SERVER_PORT'] : false;

	if ($port) {
		if ( (PROTOCOL == 'http://' && $port != '80') || (PROTOCOL == 'https://' && $port != '443') ) {
		// if non-standard port is used, then define it
        	define('PORT', $port);
		}

		$http_host = preg_replace('/:' . $port . '$/', '', $http_host);
    }

	define('SERVER_NAME', $http_host);

	if (!$vars) {
		echo 'In-Portal is probably not installed, or configuration file is missing.<br/>';
		echo 'Please use the installation script to fix the problem.<br/><br/>';

		$base_path = rtrim(preg_replace('/'.preg_quote(rtrim($admin_directory, '/'), '/').'$/', '', str_replace('\\', '/', dirname($_SERVER['PHP_SELF']))), '/');
		echo '<a href="' . PROTOCOL . SERVER_NAME . $base_path . '/core/install.php">Go to installation script</a><br><br>';
		flush();
		exit;
	}

	// variable WebsitePath is auto-detected once during installation/upgrade
	define('BASE_PATH', $vars['WebsitePath']);

	define('APPLICATION_CLASS', isset($vars['ApplicationClass']) ? $vars['ApplicationClass'] : 'kApplication');
	define('APPLICATION_PATH', isset($vars['ApplicationPath']) ? $vars['ApplicationPath'] : '/core/kernel/application.php');

	if (isset($vars['WriteablePath'])) {
		define('WRITEABLE', FULL_PATH . $vars['WriteablePath']);
		define('WRITEBALE_BASE', $vars['WriteablePath']);
	}

	if ( isset($vars['RestrictedPath']) ) {
		define('RESTRICTED', FULL_PATH . $vars['RestrictedPath']);
	}

	define('SQL_TYPE', $vars['DBType']);
	define('SQL_SERVER', $vars['DBHost']);
	define('SQL_USER', $vars['DBUser']);
	define('SQL_PASS', $vars['DBUserPassword']);
	define('SQL_DB', $vars['DBName']);

	if (isset($vars['DBCollation']) && isset($vars['DBCharset'])) {
		define('SQL_COLLATION', $vars['DBCollation']);
		define('SQL_CHARSET', $vars['DBCharset']);
	}
	define('TABLE_PREFIX', $vars['TablePrefix']);

	define('DOMAIN', getArrayValue($vars, 'Domain'));

	ini_set('memory_limit', '50M');

	define('MODULES_PATH', FULL_PATH . DIRECTORY_SEPARATOR . 'modules');

	define('EXPORT_BASE_PATH', WRITEBALE_BASE . '/export');
	define('EXPORT_PATH', FULL_PATH . EXPORT_BASE_PATH);

	define('GW_CLASS_PATH', MODULES_PATH . '/in-commerce/units/gateways/gw_classes'); // Payment Gateway Classes Path
	define('SYNC_CLASS_PATH', FULL_PATH . '/sync');	// path for 3rd party user syncronization scripts

	define('ENV_VAR_NAME','env');

	define('IMAGES_PATH', WRITEBALE_BASE . '/images/');
	define('IMAGES_PENDING_PATH', IMAGES_PATH . 'pending/');
	define('MAX_UPLOAD_SIZE', min(ini_get('upload_max_filesize'), ini_get('post_max_size'))*1024*1024);

	define('EDITOR_PATH', isset($vars['EditorPath']) ? $vars['EditorPath'] : '/core/ckeditor/');

	// caching types
	define('CACHING_TYPE_NONE', 0);
	define('CACHING_TYPE_MEMORY', 1);
	define('CACHING_TYPE_TEMPORARY', 2);

	class CacheSettings {
		static public $unitCacheRebuildTime;
		static public $structureTreeRebuildTime;
		static public $cmsMenuRebuildTime;
		static public $templateMappingRebuildTime;
		static public $sectionsParsedRebuildTime;
		static public $domainsParsedRebuildTime;
	}

	CacheSettings::$unitCacheRebuildTime = isset($vars['UnitCacheRebuildTime']) ? $vars['UnitCacheRebuildTime'] : 10;
	CacheSettings::$structureTreeRebuildTime = isset($vars['StructureTreeRebuildTime']) ? $vars['StructureTreeRebuildTime'] : 10;
	CacheSettings::$cmsMenuRebuildTime = isset($vars['CmsMenuRebuildTime']) ? $vars['CmsMenuRebuildTime'] : 10;
	CacheSettings::$templateMappingRebuildTime = isset($vars['TemplateMappingRebuildTime']) ? $vars['TemplateMappingRebuildTime'] : 5;
	CacheSettings::$sectionsParsedRebuildTime = isset($vars['SectionsParsedRebuildTime']) ? $vars['SectionsParsedRebuildTime'] : 10;
	CacheSettings::$domainsParsedRebuildTime = isset($vars['DomainsParsedRebuildTime']) ? $vars['DomainsParsedRebuildTime'] : 2;

	class MaintenanceMode {
		const NONE = 0;
		const SOFT = 1;
		const HARD = 2;
	}

	unset($vars); // just in case someone will be still using it

	if (ini_get('safe_mode')) {
		// safe mode will be removed at all in PHP6
		define('SAFE_MODE', 1);
	}

	if (file_exists(WRITEABLE . '/debug.php')) {
		include_once(WRITEABLE . '/debug.php');
		if (array_key_exists('DEBUG_MODE', $dbg_options) && $dbg_options['DEBUG_MODE']) {
			$debugger_start = microtime(true);
			include_once(KERNEL_PATH . '/utility/debugger.php');
			$debugger_end = microtime(true);

			if (isset($debugger) && kUtil::constOn('DBG_PROFILE_INCLUDES')) {
				$debugger->profileStart('inc_globals', KERNEL_PATH . '/globals.php', $globals_start);
				$debugger->profileFinish('inc_globals', KERNEL_PATH . '/globals.php', $globals_end);
				$debugger->profilerAddTotal('includes', 'inc_globals');

				$debugger->profileStart('inc_debugger', KERNEL_PATH . '/utility/debugger.php', $debugger_start);
				$debugger->profileFinish('inc_debugger', KERNEL_PATH . '/utility/debugger.php', $debugger_end);
				$debugger->profilerAddTotal('includes', 'inc_debugger');
			}
		}
	}

	kUtil::safeDefine('SILENT_LOG', 0); // can be set in "debug.php" too

	$includes = Array(
			KERNEL_PATH . "/interfaces/cacheable.php",
			KERNEL_PATH . '/application.php',
			FULL_PATH . APPLICATION_PATH,
			KERNEL_PATH . "/kbase.php",
			KERNEL_PATH . '/db/db_connection.php',
			KERNEL_PATH . '/db/db_load_balancer.php',
			KERNEL_PATH . '/utility/event.php',
			KERNEL_PATH . "/utility/factory.php",
			KERNEL_PATH . "/languages/phrases_cache.php",
			KERNEL_PATH . "/db/dblist.php",
			KERNEL_PATH . "/db/dbitem.php",
			KERNEL_PATH . "/event_handler.php",
			KERNEL_PATH . '/db/db_event_handler.php',
	);

	foreach ($includes as $a_file) {
		kUtil::includeOnce($a_file);
	}

	if (defined('DEBUG_MODE') && DEBUG_MODE && isset($debugger)) {
		$debugger->AttachToApplication();
	}

	if( !function_exists('adodb_mktime') ) {
		include_once(KERNEL_PATH . '/utility/adodb-time.inc.php');
	}

	// system users
	define('USER_ROOT', -1);
	define('USER_GUEST', -2);