/*

Class used to convert <select multiple="multiple" ...> into div with checkboxes for each option

The select is hidden, but the data is still submitted through hidden control. This class is used for multioptions filter.

Basic usage:

<script type="text/javascript">
	MultiOptions.ConvertSelect('hidden_id');
</script>

* @TODO: Make the Search/Close buttons optional.
* This will make the class flexible and it could be used for other purposes also.

*/

function MultiOptions() {}

MultiOptions.Selectors = [];

MultiOptions.ConvertSelect = function($id, $ajax) {
	// custom_filters[partner-service][Default][Status][multioptions]
	$id.match(/custom_filters\[(.*?)\]\[(.*?)\]\[.*?\]\[.*?\]/);

	var $prefix = RegExp.$1;
	var $grid_name = RegExp.$2;
	var $select = $('#' + jq($id) + '_select');

	if (!$select.length) {
		return ;
	}

	// hide <select> element
	$select.hide();

	// create div with checkboxes and buttons
	var $cur_index = MultiOptions.Selectors.length;
	var $div = $('<div id="' + $id + '_div" class="multioptions_filter"></div>');

	MultiOptions.Selectors.push($id);

	// set defaults for missing phrases
	if (!phrases['la_btn_SelectAll']) phrases['la_SelectAll'] = 'Select All';
	if (!phrases['la_btn_OpenMultiFilter']) phrases['la_OpenMultiFilter'] = 'Open Filter';
	if (!phrases['la_btn_Search']) phrases['la_ToolTip_Search'] = 'Search';
	if (!phrases['la_btn_Close']) phrases['la_tooltip_close'] = 'Close';

	// create div with checkboxes
	var $options_div = $('<div></div>');

	// add "Select All" checkbox
	$options_div.append(
		'<input type="checkbox" id="_mutlioptions_cb_' + $cur_index + '_all"/>\
		<label for="_mutlioptions_cb_' + $cur_index + '_all">' + phrases['la_SelectAll'] + '</label><br/>'
	);

	var $options = $('option', $select);

	// add each <select> option as checkbox to above div
	$options.each(
		function () {
			var $checked = this.selected ? ' checked="checked"' : '';

			$options_div.append(
				'<input type="checkbox" class="_mutlioptions_cb_' + $cur_index + '" id="_mutlioptions_cb_' + $cur_index + '_' + this.value + '"' + $checked + ' value="' + this.value + '"/>\
				<label for="_mutlioptions_cb_' + $cur_index + '_' + this.value + '">' + this.text + '</label><br/>'
			);
		}
	);

	// add buttons to search or close filter
	$div
	.append($options_div)
	.append(
		'<div style="margin-top: 7px; text-align: center">\
			<input type="button" class="button" value="' + phrases['la_ToolTip_Search'] + '" onclick="search(\'' + $prefix + '\', \'' + $grid_name + '\', ' + parseInt($ajax) + ')"/>&nbsp;\
			<input type="button" class="button" value="' + phrases['la_tooltip_close'] + '" onclick="MultiOptions.CloseSelector(' + $cur_index + ')">\
		</div>'
	);

	$('#' + jq($form_name)).append($div);

	// set click handlers
	$('#_mutlioptions_cb_' + $cur_index + '_all')
	.click(
		function ($e) {
			MultiOptions.SelectAll($cur_index);
		}
	)
	.attr('checked', $options.length == $options.filter(':selected').length ? 'checked' : '');

	$('input._mutlioptions_cb_' + $cur_index).click(
		function ($e) {
			MultiOptions.ItemChecked($cur_index);
		}
	);

	// add filter placeholder, used for filter opening filter
	var $filter = $('<div class="filter" style="cursor: pointer;">' + phrases['la_OpenMultiFilter'] + '</div>');

	if ($select.hasClass('filter-active')) {
		$filter.addClass('filter-active');
	}

	$filter
	.click(
		function($e) {
			var $offset = $(this).offset();
			var $box_left = $offset.left;

			$('#' + jq($id) + '_div').css( {left: 0, top: $offset.top} ).show();

			var $box_width = $('#' + jq($id) + '_div').outerWidth();

			if ($box_left + $box_width > document.body.offsetWidth) {
				// move left
				$box_left -= $box_width;
		 	}

		 	$('#' + jq($id) + '_div').css('left', $box_left);
		}
	)
	.insertAfter($select);
}

MultiOptions.CloseSelector = function(selector_index) {
	$('#' + jq(MultiOptions.Selectors[selector_index]) + '_div').hide();
}

MultiOptions.ItemChecked = function(selector_index) {
	// sync hidden field
	var $reg_exp = new RegExp('^_mutlioptions_cb_' + selector_index + '_(?!all)([0-9A-Za-z-]+)');
	update_checkbox_options($reg_exp, MultiOptions.Selectors[selector_index]);

	// update "Select All" checkbox
	var $select_all = $('#_mutlioptions_cb_' + selector_index + '_all');
	var $options = $("input[type='checkbox']", '#' + jq(MultiOptions.Selectors[selector_index]) + '_div').not($select_all);

	$select_all.attr('checked', $options.length == $options.filter(':checked').length ? 'checked' : '');
}

MultiOptions.SelectAll = function(selector_index) {
	// set all checkbox to match "Select All" checkbox
	var $select_all = $('#_mutlioptions_cb_' + selector_index + '_all');
	var $checked = $select_all.attr('checked');

	$("input[type='checkbox']", '#' + jq(MultiOptions.Selectors[selector_index]) + '_div').not($select_all).attr('checked', $checked);

	// sync hidden field
	var $reg_exp = new RegExp('^_mutlioptions_cb_' + selector_index + '_(?!all)([0-9A-Za-z-]+)');
	update_checkbox_options($reg_exp, MultiOptions.Selectors[selector_index]);
}
