if ( !( isset($init_made) && $init_made ) ) {
	var Application = new kApplication();
	var Grids = new Array();
	var GridScrollers = new Array();
	var Toolbars = new Array();
	var $Menus = new Array();
	var $ViewMenus = new Array();
	var $nls_menus = new Array();
	var $MenuNames = new Array();

	var $CKEditors = {}; // input name VS ck options mapping

	var $form_name = 'kernel_form';

	if ( !$fw_menus ) {
		var $fw_menus = new Array();
	}

	var $env = '';
	var submitted = false;
	var unload_legal = false;
	var $edit_mode = false;
	var $init_made = true; // in case of double inclusion of script.js :)

	// hook processing
	var hBEFORE = 1; // this is const, but including this twice causes errors
	var hAFTER = 2; // this is const, but including this twice causes errors
	replaceFireBug();
}

function use_popups($prefix_special, $event, $mode) {
	if ( $mode === undefined || $mode == 'popup' ) {
		return $use_popups;
	}

	return $modal_windows;
}

function getArrayValue() {
	var $value = arguments[0];
	var $current_key = 0;
	$i = 1;

	while ($i < arguments.length) {
		$current_key = arguments[$i];
		if ( isset($value[$current_key]) ) {
			$value = $value[$current_key];
		}
		else {
			return false;
		}

		$i++;
	}

	return $value;
}

function setArrayValue() {
	// first argument - array, other arguments - keys (arrays too), last argument - value
	var $array = arguments[0];
	var $current_key = 0;
	$i = 1;

	while ($i < arguments.length - 1) {
		$current_key = arguments[$i];

		if ( !isset($array[$current_key]) ) {
			$array[$current_key] = new Array();
		}

		$array = $array[$current_key];
		$i++;
	}

	$array[$array.length] = arguments[arguments.length - 1];
}

function resort_grid($prefix_special, $field, $ajax) {
	set_form($prefix_special, $ajax);
	set_hidden_field($prefix_special + '_Sort1', $field);
	submit_event($prefix_special, 'OnSetSorting', null, null, $ajax);
}

function direct_sort_grid($prefix_special, $field, $direction, $field_pos, $ajax) {
	if ( !isset($field_pos) ) {
		$field_pos = 1;
	}

	set_form($prefix_special, $ajax);
	set_hidden_field($prefix_special + '_Sort' + $field_pos, $field);
	set_hidden_field($prefix_special + '_Sort' + $field_pos + '_Dir', $direction);
	set_hidden_field($prefix_special + '_SortPos', $field_pos);
	submit_event($prefix_special, 'OnSetSortingDirect', null, null, $ajax);
}

function reset_sorting($prefix_special, $ajax) {
	submit_event($prefix_special, 'OnResetSorting', null, null, $ajax);
}

function set_per_page($prefix_special, $per_page, $ajax) {
	set_form($prefix_special, $ajax);
	set_hidden_field($prefix_special + '_PerPage', $per_page);
	submit_event($prefix_special, 'OnSetPerPage', null, null, $ajax);
}

function set_refresh_interval($prefix_special, $refresh_interval, $ajax) {
	set_form($prefix_special, $ajax);
	set_hidden_field('refresh_interval', $refresh_interval);
	submit_event($prefix_special, 'OnSetAutoRefreshInterval', null, null, $ajax);
}

function submit_event(prefix_special, event, t, form_action, $ajax) {
	if ( !Application.processHooks(prefix_special + ':' + event) ) {
		return false;
	}

	if ( $ajax ) {
		return $Catalog.submit_event(prefix_special, event, t);
	}

	if ( event ) {
		set_hidden_field('events[' + prefix_special + ']', event);
	}

	if ( t ) {
		set_hidden_field('t', t);
	}

	if ( form_action ) {
		var old_env = '';

		if ( !form_action.match(/\?/) ) {
			document.getElementById($form_name).action.match(/.*(\?.*)/);
			old_env = RegExp.$1;
		}

		document.getElementById($form_name).action = form_action + old_env;
	}

	submit_kernel_form();

	// reset remove special mark (otherwise all future events will have special removed too)
	set_hidden_field('remove_specials[' + prefix_special + ']', null);
}

function submit_event_ajax(prefix_special, event, t, $callback) {
	if ( !Application.processHooks(prefix_special + ':' + event) ) {
		return false;
	}

	if ( event ) {
		set_hidden_field('events[' + prefix_special + ']', event);
	}

	if ( t ) {
		set_hidden_field('t', t);
	}

	var $form = $('#kernel_form'),
		$from_params = $form.serialize();

	$.post($form.attr('action'), $from_params, $callback);

	// reset remove special mark (otherwise all future events will have special removed too)
	set_hidden_field('events[' + prefix_special + ']', '');
	set_hidden_field('remove_specials[' + prefix_special + ']', null);
}

function submit_action($url, $action) {
	$form = document.getElementById($form_name);
	$form.action = $url;
	set_hidden_field('Action', $action);
	submit_kernel_form();
}

function show_form_data() {
	var $kf = document.getElementById($form_name);
	$ret = '';

	for (var i in $kf.elements) {
		$elem = $kf.elements[i];
		$ret += $elem.id + ' = ' + $elem.value + "\n";
	}

	alert($ret);
}

function submit_kernel_form() {
	if ( submitted ) {
		return;
	}

	submitted = true;
	unload_legal = true; // bug: when opening new popup from this window, then this window is not refreshed and this mark stays forever

	var $form = document.getElementById($form_name);

	if ( $.isFunction($form.onsubmit) ) {
		$form.onsubmit();
	}

	$($form).submit();

	$form.target = '';
	set_hidden_field('t', t);

//	window.setTimeout(function() {submitted = false}, 500);
}

function set_event(prefix_special, event) {
	var event_field = document.getElementById('events[' + prefix_special + ']');

	if ( isset(event_field) ) {
		event_field.value = event;
	}
}

function isset(variable) {
	if ( variable == null ) {
		return false;
	}

	return (typeof(variable) == 'undefined') ? false : true;
}

function in_array(needle, haystack) {
	return array_search(needle, haystack) != -1;
}

function array_search(needle, haystack) {
	for (var i = 0; i < haystack.length; i++) {
		if ( haystack[i] == needle ) return i;
	}

	return -1;
}

function print_pre(variable, msg) {
	if ( !isset(msg) ) {
		msg = '';
	}

	var s = msg;

	for (prop in variable) {
		s += prop + " => " + variable[prop] + "\n";
	}

	alert(s);
}

function go_to_page($prefix_special, $page, $ajax) {
	set_form($prefix_special, $ajax);
	set_hidden_field($prefix_special + '_Page', $page);
	submit_event($prefix_special, 'OnSetPage', null, null, $ajax);
}

function go_to_list(prefix_special, tab) {
	set_hidden_field(prefix_special + '_GoTab', tab);
	submit_event(prefix_special, 'OnUpdateAndGoToTab', null);
}

function go_to_tab(prefix_special, tab) {
	set_hidden_field(prefix_special + '_GoTab', tab);
	submit_event(prefix_special, 'OnPreSaveAndGoToTab', null);
}

function go_to_id(prefix_special, id) {
	set_hidden_field(prefix_special + '_GoId', id);
	submit_event(prefix_special, 'OnPreSaveAndGo')
}

// in-portal compatibility functions: begin
function getScriptURL($script_name, tpl) {
	tpl = tpl ? '-' + tpl : '';
	var $asid = get_hidden_field('sid');

	return base_url + $script_name + '?env=' + ( isset($env) && $env ? $env : $asid ) + tpl + '&en=0';
}

function OpenEditor(extra_env, TargetForm, TargetField) {
	var $url = getScriptURL('admin/index.php', 'popups/editor');

	$url = $url + '&TargetForm=' + TargetForm + '&TargetField=' + TargetField + '&destform=popup';

	if ( extra_env.length > 0 ) {
		$url += extra_env;
	}

	openwin($url, 'html_edit', 800, 575);
}
// in-portal compatibility functions: end

function InitTranslator(prefix, field, t, multi_line, $before_callback) {
	var $window_name = 'select_' + t.replace(/(\/|-)/g, '_');

	var $options = {
		onAfterShow: function ($popup_window) {
			if ( $modal_windows ) {
				getFrame('main').initTranslatorOnAfterShow(prefix, field, t, multi_line, $before_callback);
			}
			else {
				initTranslatorOnAfterShow(prefix, field, t, multi_line, $before_callback, $popup_window);
			}
		}
	};

	openwin('', $window_name, 750, 400, $options);
}

function initTranslatorOnAfterShow(prefix, field, t, multi_line, $before_callback, $popup_window) {
	var $window_name = 'select_' + t.replace(/(\/|-)/g, '_');

	$popup_window = onAfterWindowOpen($window_name, undefined, $popup_window);

	if ( $popup_window === false ) {
		// iframe onload happens on frame content change too -> don't react on it
		return;
	}

	var $opener = getWindowOpener($popup_window);
	var $prev_opener = get_hidden_field('m_opener');

	$opener.set_hidden_field('m_opener', 'p');
	$opener.set_hidden_field('translator_wnd_name', $window_name);
	$opener.set_hidden_field('translator_field', field);
	$opener.set_hidden_field('translator_t', t);
	$opener.set_hidden_field('translator_prefixes', prefix);
	$opener.set_hidden_field('translator_multi_line', isset(multi_line) ? multi_line : 0);

	if ( $.isFunction($before_callback) ) {
		$before_callback($opener);
	}

	$opener.document.getElementById($opener.$form_name).target = $window_name;

	var split_prefix = prefix.split(',');
	$opener.submit_event(split_prefix[0], 'OnPreSaveAndOpenTranslator');

	$opener.set_hidden_field('m_opener', $prev_opener);
	$opener.submitted = false;
}

function PreSaveAndOpenTranslator(prefix, field, t, multi_line) {
	InitTranslator(prefix, field, t, multi_line);
}

function PreSaveAndOpenTranslatorCV(prefix, field, t, resource_id, multi_line) {
	InitTranslator(
		prefix, field, t, multi_line,
		function ($opener) {
			$opener.set_hidden_field('translator_resource_id', resource_id);
		}
	);
}

function openTranslator(prefix, field, url, wnd) {
	var $kf = document.getElementById($form_name);

	set_hidden_field('trans_prefix', prefix);
	set_hidden_field('trans_field', field);
	set_hidden_field('events[trans]', 'OnLoad');

	var $regex = new RegExp('(.*)\?env=(' + document.getElementById('sid').value + ')?-(.*?):(.*)');
	var $t = $regex.exec(url)[3];

	$kf.target = wnd;
	submit_event(prefix, '', $t, url);
	submitted = false;
}

function openwin($url, $name, $width, $height, $options) {
	var $settings = {
		url: base_url + 'core/admin_templates/blank.html?width=' + $width + '&height=' + $height + '&TB_iframe=true&modal=true',
		caption: 'Loading ...',
		onAfterShow: function ($popup_window) {
			if ( $modal_windows ) {
				getFrame('main').onAfterWindowOpen($name, $url);
			}
			else {
				onAfterWindowOpen($name, $url, $popup_window);
			}
		}
	};

	if ( $options !== undefined ) {
		$.extend($settings, $options);
	}

	if ( $modal_windows ) {
		if ( window.name != 'main' ) {
			// all popups are opened based on main frame
			return getFrame('main').TB.show($settings);
		}

		TB.show($settings);

		return;
	}

	// prevent window from opening larger, then screen resolution on user's computer (to Kostja)
	var left = Math.round((screen.width - $width) / 2);
	var top = Math.round((screen.height - $height) / 2);
	var cur_x = document.all ? window.screenLeft : window.screenX;
	var cur_y = document.all ? window.screenTop : window.screenY;

	var $window_params = 'left=' + left + ',top=' + top + ',width=' + $width + ',height=' + $height + ',status=yes,resizable=yes,menubar=no,scrollbars=yes,toolbar=no';
	var $popup_window = window.open($url, $name, $window_params);

	if ( $.isFunction($settings.onAfterShow) ) {
		$settings.onAfterShow($popup_window);
	}

	return $popup_window;
}

function onAfterWindowOpen($window_name, $url, $popup_window) {
	// this is always invoked from "main" frame
	if ( $popup_window === undefined ) {
		var $popup_window = $('#' + TB.getId('TB_iframeContent')).get(0).contentWindow;

		if ( !$.isFunction($popup_window.onLoad) ) {
			// iframe onload happens on frame content change too -> don't react on it
			return false;
		}

		$popup_window.onLoad();
	}

	$popup_window.name = $window_name;

	if ( $url !== undefined ) {
		$popup_window.location.href = $url;
	}

	if ( $modal_windows ) {
		TB.setWindowMetaData('window_name', $window_name); // used to simulate window.opener functionality
	}

	return $popup_window;
}

function OnResizePopup(e) {
	if ( !document.all ) {
		var $winW = window.innerWidth;
		var $winH = window.innerHeight;
	}
	else {
		var $winW = window.document.body.offsetWidth;
		var $winH = window.document.body.offsetHeight;
	}

	window.status = '[width: ' + $winW + '; height: ' + $winH + ']';
}

function opener_action(new_action) {
	var $prev_opener = get_hidden_field('m_opener');
	set_hidden_field('m_opener', new_action);
	return $prev_opener;
}

function open_popup($prefix_special, $event, $t, $window_size, $onAfterOpenPopup) {
	if ( !$window_size ) {
		// if no size given, then query it from ajax
		var $default_size = '750x400';
		var $pm = getFrame('head').$popup_manager;

		if ( $pm ) {
			// popup manager was found in head frame
			$pm.ResponceFunction = function ($responce) {
				if ( !$responce.match(/([\d]+)x([\d]+)/) ) {
					// invalid responce was received, may be php fatal error during AJAX request
					$responce = $default_size;
				}

				open_popup($prefix_special, $event, $t, $responce, $onAfterOpenPopup);
			}

			$pm.GetSize($t);
			return;
		}

		$window_size = $default_size;
	}

	$window_size = $window_size.split('x');
	var $window_name = $t.replace(/(\/|-)/g, '_'); // replace "/" and "-" with "_"

	var $options = {
		onAfterShow: function ($popup_window) {

			if ( $modal_windows ) {
				getFrame('main').onAfterOpenPopup($prefix_special, $event, $t);
			}
			else {
				onAfterOpenPopup($prefix_special, $event, $t, $popup_window);
			}

			if ( $onAfterOpenPopup !== undefined && $.isFunction($onAfterOpenPopup) ) {
				$onAfterOpenPopup($popup_window);
			}
		}
	};

	openwin('', $window_name, $window_size[0], $window_size[1], $options);
}

function onAfterOpenPopup($prefix_special, $event, $t, $popup_window) {
	// this is always invoked from "main" frame
	var $window_name = $t.replace(/(\/|-)/g, '_'); // replace "/" and "-" with "_"

	$popup_window = onAfterWindowOpen($window_name, undefined, $popup_window);
	if ( $popup_window === false ) {
		// iframe onload happens on frame content change too -> don't react on it
		return;
	}

	var $opener = getWindowOpener($popup_window);
	if ( $opener === null ) {
		// we are already in main window
		$opener = window;
	}

	$opener.document.getElementById($opener.$form_name).target = $window_name;

	var $prev_opener = $opener.opener_action('p');

	event_bak = $opener.get_hidden_field('events[' + $prefix_special + ']')
	if ( !event_bak ) {
		event_bak = '';
	}

	$opener.submit_event($prefix_special, $event, $t);

	$opener.opener_action($prev_opener); // restore opener in parent window
	$opener.set_hidden_field('events[' + $prefix_special + ']', event_bak); // restore event

	// AJAX popup size respoce is received after std_edit_item/std_precreate_item function exit
	$opener.set_hidden_field($prefix_special + '_mode', null);
	$opener.submitted = false;

	$opener.Application.processHooks($prefix_special + ':OnAfterOpenPopup');
}


function openSelector($prefix, $url, $dst_field, $window_size, $event) {
	// get template name from url
	var $regex = new RegExp('(.*)\?env=(' + document.getElementById('sid').value + ')?-(.*?):(m[^:]+)');
	$regex = $regex.exec($url);

	var $t = $regex[3];

	// substitute form action with selector's url
	var $kf = document.getElementById($form_name);
	var $prev_action = $kf.action;

	$kf.action = $url;

	// check parameter values
	if ( !isset($event) ) {
		$event = '';
	}

	Application.processHooks($prefix + ':OnBeforeOpenSelector');

	// set variables need for selector to work
	set_hidden_field('main_prefix', $prefix);
	set_hidden_field('dst_field', $dst_field);

//	alert('openSelector(' + $prefix + ', ' + $event + ', ' + $t + ', ' + $window_size + ')');
	open_popup(
		$prefix, $event, $t, $window_size,
		function () {
			// restore form action back
			$kf.action = $prev_action;
		}
	);
}

function translate_phrase($label, $edit_template, $options) {
	set_hidden_field('phrases_label', $label);
	var $event = $options.event === undefined ? 'OnNew' : $options.event;

	if ( $options.simple_mode !== undefined ) {
		Application.SetVar('simple_mode', $options.simple_mode ? 1 : 0);

		if ( $options.simple_mode ) {
			Application.SetVar('front', 1);
		}
	}
	else {
		Application.SetVar('front', null);
		Application.SetVar('simple_mode', null);
		Application.SetVar('phrases_label', null);
	}

	if ( use_popups('phrases', $event) ) {
		open_popup('phrases', $event, $edit_template, null, function () {
			Application.SetVar('front', null);
			Application.SetVar('simple_mode', null);
		});
	}
	else {
		opener_action('d');
		submit_event('phrases', $event, $edit_template);

		Application.SetVar('front', null);
		Application.SetVar('simple_mode', null);
		Application.SetVar('phrases_label', null);
	}
}

function direct_edit($prefix_special, $url) {
	if ( use_popups($prefix_special, '') ) {
		openSelector($prefix_special, $url);
	}
	else {
		redirect($url);
	}

	return false;
}

function std_precreate_item(prefix_special, edit_template, $onAfterOpenPopup) {
	set_hidden_field(prefix_special + '_mode', 't');

	if ( use_popups(prefix_special, 'OnPreCreate') ) {
		open_popup(prefix_special, 'OnPreCreate', edit_template, null, $onAfterOpenPopup);
	}
	else {
		opener_action('d');
		submit_event(prefix_special, 'OnPreCreate', edit_template);
	}
//  set_hidden_field(prefix_special+'_mode', '');
}

function std_new_item(prefix_special, edit_template, $onAfterOpenPopup) {
	if ( use_popups(prefix_special, 'OnNew') ) {
		open_popup(prefix_special, 'OnNew', edit_template, null, $onAfterOpenPopup);
	}
	else {
		opener_action('d');
		submit_event(prefix_special, 'OnNew', edit_template);
	}
}

function std_edit_item(prefix_special, edit_template, $onAfterOpenPopup) {
	set_hidden_field(prefix_special + '_mode', 't');

	if ( use_popups(prefix_special, 'OnEdit') ) {
		open_popup(prefix_special, 'OnEdit', edit_template, null, $onAfterOpenPopup);
	}
	else {
		opener_action('d');
		submit_event(prefix_special, 'OnEdit', edit_template);
	}
//	set_hidden_field(prefix_special+'_mode', '');
}

function std_edit_temp_item(prefix_special, edit_template, $onAfterOpenPopup) {
	if ( use_popups(prefix_special, 'OnStoreSelected') ) {
		open_popup(prefix_special, 'OnStoreSelected', edit_template, null, $onAfterOpenPopup);
	}
	else {
		opener_action('d');
		submit_event(prefix_special, 'OnStoreSelected', edit_template);
	}
}

function std_delete_items(prefix_special, t, $ajax) {
	var phrase = phrases['la_Delete_Confirm'] ? phrases['la_Delete_Confirm'] : 'Are you sure you want to delete selected items?';

	if ( inpConfirm(phrase) ) {
		submit_event(prefix_special, 'OnMassDelete', t, null, $ajax);
	}
}

function std_csv_export(prefix_special, grid, template) {
	set_hidden_field('PrefixSpecial', prefix_special);
	set_hidden_field('grid', grid);

	open_popup(prefix_special, '', template);
}

function std_csv_import(prefix_special, grid, template) {
	set_hidden_field('PrefixSpecial', prefix_special);
	set_hidden_field('grid', grid);

	if ( use_popups(prefix_special, '') ) {
		open_popup(prefix_special, '', template);
	}
	else {
		submit_event(prefix_special, '', template);
	}
}

// set current form base on ajax
function set_form($prefix_special, $ajax) {
	if ( $ajax ) {
		$form_name = $Catalog.queryTabRegistry('prefix', $prefix_special, 'tab_id') + '_form';
	}
}

// sets hidden field value
// if the field does not exist - creates it
function set_hidden_field($field_id, $value, $has_id) {
	var $kf = document.getElementById($form_name);
	var $field = $kf.elements[$field_id];

	if ( $value === null ) {
		if ( $field ) {
//			alert('tag name on remove: ' + $field.parentNode.tagName);
			$field.parentNode.removeChild($field); // bug: sometimes hidden fields are inside BODY tag in DOM model, why?
		}

		return true;
	}

	if ( $field ) {
		$field.value = $value;

		return true;
	}

	$field = document.createElement('INPUT');
	$field.type = 'hidden';
	$field.name = $field_id;

	if ( !isset($has_id) || $has_id ) {
		$field.id = $field_id;
	}

	$field.value = $value;
	$kf.appendChild($field);

	return false;
}

// sets hidden field value
// if the field does not exist - creates it
function setInnerHTML($field_id, $value) {
	$(jq('#' + $field_id)).html($value);
}

function get_hidden_field($field) {
	var $kf = document.getElementById($form_name);

	return $kf.elements[$field] ? $kf.elements[$field].value : false;
}

function search($prefix_special, $grid_name, $ajax) {
	set_form($prefix_special, $ajax);
	set_hidden_field('grid_name', $grid_name);
	submit_event($prefix_special, 'OnSearch', null, null, $ajax);
}

function search_reset($prefix_special, $grid_name, $ajax) {
	set_form($prefix_special, $ajax);
	set_hidden_field('grid_name', $grid_name);
	submit_event($prefix_special, 'OnSearchReset', null, null, $ajax);
}

function search_keydown($event, $prefix_special, $grid, $ajax) {
	if ( $prefix_special !== undefined ) {
		// if $prefix_special is passed, then keydown event was not assigned by jQuery
		$event = $event ? $event : event;

		if ( window.event ) {// IE
			var $key_code = $event.keyCode;
		}
		else if ( $event.which ) { // Netscape/Firefox/Opera
			var $key_code = $event.which;
		}
	}
	else {
		// event bind with jQuery, so always use which
		var $key_code = $event.which;

		$prefix_special = $(this).attr('PrefixSpecial');
		$grid = $(this).attr('Grid');
		$ajax = $(this).attr('ajax');
	}

	switch ($key_code) {
		case 13:
			search($prefix_special, $grid, parseInt($ajax));
			break;

		case 27:
			search_reset($prefix_special, $grid, parseInt($ajax));
			break;
	}
}

function getRealLeft(el) {
	if ( typeof(el) == 'string' ) {
		el = document.getElementById(el);
	}

	xPos = el.offsetLeft;
	tempEl = el.offsetParent;

	while (tempEl != null) {
		xPos += tempEl.offsetLeft;
		tempEl = tempEl.offsetParent;
	}

	//	if (obj.x) return obj.x;
	return xPos;
}

function getRealTop(el) {
	if ( typeof(el) == 'string' ) {
		el = document.getElementById(el);
	}

	yPos = el.offsetTop;
	tempEl = el.offsetParent;

	while (tempEl != null) {
		yPos += tempEl.offsetTop;
		tempEl = tempEl.offsetParent;
	}

//	if (obj.y) return obj.y;
	return yPos;
}

function show_viewmenu_old($toolbar, $button_id) {
	var $img = $toolbar.GetButtonImage($button_id);
	var $pos_x = getRealLeft($img) - ((document.all) ? 6 : -2);
	var $pos_y = getRealTop($img) + 32;

	var $prefix_special = '';
	window.triedToWriteMenus = false;

	if ( $ViewMenus.length == 1 ) {
		$prefix_special = $ViewMenus[$ViewMenus.length - 1];
		$fw_menus[$prefix_special + '_view_menu']();
		$Menus[$prefix_special + '_view_menu'].writeMenus('MenuContainers[' + $prefix_special + ']');
		window.FW_showMenu($Menus[$prefix_special + '_view_menu'], $pos_x, $pos_y);
	}
	else {
		// prepare menus
		for (var $i in $ViewMenus) {
			$prefix_special = $ViewMenus[$i];
			$fw_menus[$prefix_special + '_view_menu']();
		}
		$Menus['mixed'] = new Menu('ViewMenu_mixed');

		// merge menus into new one
		for (var $i in $ViewMenus) {
			$prefix_special = $ViewMenus[$i];
			$Menus['mixed'].addMenuItem($Menus[$prefix_special + '_view_menu']);
		}

		$Menus['mixed'].writeMenus('MenuContainers[mixed]');
		window.FW_showMenu($Menus['mixed'], $pos_x, $pos_y);
	}
}

var nlsMenuRendered = false;
function show_viewmenu($toolbar, $button_id) {
	if ( $ViewMenus.length == 1 ) {
		$prefix_special = $ViewMenus[$ViewMenus.length - 1];
		menu_to_show = $prefix_special + '_view_menu';
	}
	else {
		mixed_menu = menuMgr.createMenu(rs('mixed_menu'));
		mixed_menu.applyBorder(false, false, false, false);
		mixed_menu.dropShadow("none");
		mixed_menu.showIcon = true;

		// merge menus into new one
		for (var $i in $ViewMenus) {
			$prefix_special = $ViewMenus[$i];
			mixed_menu.addItem(rs($prefix_special + '.view.menu.mixed'),
				$MenuNames[$prefix_special + '_view_menu'],
				'javascript:void()', null, true, null,
				rs($prefix_special + '.view.menu'), $MenuNames[$prefix_special + '_view_menu']);
		}

		menu_to_show = 'mixed_menu';
	}

	renderMenus();
	nls_showMenu(rs(menu_to_show), $toolbar.GetButtonImage($button_id))
}

function renderMenus() {
	// menuMgr.renderMenus closes all opened menus, but doesn't mark them as closed
	menuMgr.hideMenus();
	menuMgr.renderMenus('nlsMenuPlace');
	nlsMenuRendered = true;
}

function set_window_title($title) {
	var $window = window;

	if ( $window.name != 'main' ) {
		// traverse through real popups
		$window = getFrame('main');
	}

	$window.top.document.title = (main_title.length ? main_title + ' - ' : '') + $title;

	if ( $modal_windows ) {
		$window.TB.setWindowTitle('');
	}
}

function set_filter($prefix_special, $filter_id, $filter_value, $ajax) {
	set_form($prefix_special, $ajax);
	set_hidden_field('filter_id', $filter_id);
	set_hidden_field('filter_value', $filter_value);
	submit_event($prefix_special, 'OnSetFilter', null, null, $ajax);
}

function filters_remove_all($prefix_special, $ajax) {
	set_form($prefix_special, $ajax);
	submit_event($prefix_special, 'OnRemoveFilters', null, null, $ajax);
}

function filters_apply_all($prefix_special, $ajax) {
	set_form($prefix_special, $ajax);
	submit_event($prefix_special, 'OnApplyFilters', null, null, $ajax);
}

function filter_toggle($row_id, $prefix) {
//	var $row = $('#' + jq($row_id));

	var $row = $('tr.to-range-filter');
	var $hidden = $row.hasClass('hidden-filter');

	if ( $hidden ) {
		$('td', $row).show();

		$row.removeClass('hidden-filter');
	}
	else {
		$('td', $row).hide();

		$row.addClass('hidden-filter');
	}

	// recalculate filter row heights/widths
	var $grid = GridScrollers[$prefix];
	$grid.UpdateColWidths();

	if ( $hidden && $grid.FiltersExpanded !== true ) {
		$grid.AdjustInputWidths();
		$grid.FiltersExpanded = true;
	}

//	$grid.SetLeftHeights();
//	$grid.UpdateTotalDimensions();
//	$grid.SyncScroll();

//	$grid.Resize( $grid.GetAutoSize() );
}

function RemoveTranslationLink($string, $escaped) {
	if ( !isset($escaped) ) $escaped = true;

	if ( $escaped ) {
		return $string.replace(/&lt;a href=&quot;(.*?)&quot;.*&gt;(.*?)&lt;\/a&gt;/g, '$2');
	}

	return $string.replace(/<a href="(.*?)".*>(.*?)<\/a>/g, '$2');
}

function redirect($url) {
	window.location.href = $url;
}

function update_checkbox_options($cb_mask, $hidden_id) {
	var $kf = document.getElementById($form_name);
	var $tmp = '';

	for (var i = 0; i < $kf.elements.length; i++) {
		if ( $kf.elements[i].id.match($cb_mask) ) {
			if ( $kf.elements[i].checked ) {
				$tmp += '|' + $kf.elements[i].value;
			}
		}
	}

	if ( $tmp.length > 0 ) {
		$tmp += '|';
	}

	document.getElementById($hidden_id).value = $tmp.replace(/,$/, '');
}

function update_multiple_options($hidden_id) {
	var $select = document.getElementById($hidden_id + '_select');
	var $result = '';

	for (var $i = 0; $i < $select.options.length; $i++) {
		if ( $select.options[$i].selected ) {
			$result += $select.options[$i].value + '|';
		}
	}

	document.getElementById($hidden_id).value = $result ? '|' + $result : '';
}

// related to lists operations (moving)

function move_selected($from_list, $to_list, $error_msg) {
	if ( typeof($from_list) != 'object' ) $from_list = document.getElementById($from_list);
	if ( typeof($to_list) != 'object' ) $to_list = document.getElementById($to_list);

	if ( has_selected_options($from_list) ) {
		var $from_array = select_to_array($from_list);
		var $to_array = select_to_array($to_list);
		var $new_from = Array();
		var $cur = null;

		for (var $i = 0; $i < $from_array.length; $i++) {
			$cur = $from_array[$i];
			if ( $cur[2] ) // If selected - add to To array
			{
				$to_array[$to_array.length] = $cur;
			}
			else //Else - keep in new From
			{
				$new_from[$new_from.length] = $cur;
			}
		}

		$from_list = array_to_select($new_from, $from_list);
		$to_list = array_to_select($to_array, $to_list);
	}
	else {
		alert(isset($error_msg) ? $error_msg : 'Please select items to perform moving!');
	}
}

function select_to_array($aSelect) {
	var $an_array = new Array();
	var $cur = null;

	for (var $i = 0; $i < $aSelect.length; $i++) {
		$cur = $aSelect.options[$i];
		$an_array[$an_array.length] = new Array($cur.text, $cur.value, $cur.selected);
	}

	return $an_array;
}

function array_to_select($anArray, $aSelect) {
	var $initial_length = $aSelect.length;

	for (var $i = $initial_length - 1; $i >= 0; $i--) {
		$aSelect.options[$i] = null;
	}

	for (var $i = 0; $i < $anArray.length; $i++) {
		$cur = $anArray[$i];
		$aSelect.options[$aSelect.length] = new Option($cur[0], $cur[1]);
	}
}

function select_compare($a, $b) {
	if ( $a[0] < $b[0] ) {
		return -1;
	}

	if ( $a[0] > $b[0] ) {
		return 1;
	}

	return 0;
}

function select_to_string($aSelect) {
	var $result = '';
	var $cur = null;

	if ( typeof($aSelect) != 'object' ) $aSelect = document.getElementById($aSelect);

	for (var $i = 0; $i < $aSelect.length; $i++) {
		$result += $aSelect.options[$i].value + '|';
	}

	return $result.length ? '|' + $result : '';
}

function selected_to_string($aSelect) {
	var $result = '';
	var $cur = null;

	if ( typeof($aSelect) != 'object' ) $aSelect = document.getElementById($aSelect);

	for (var $i = 0; $i < $aSelect.length; $i++) {
		$cur = $aSelect.options[$i];

		if ( $cur.selected && $cur.value != '' ) {
			$result += $cur.value + '|';
		}
	}

	return $result.length ? '|' + $result : '';
}

function string_to_selected($str, $aSelect) {
	var $cur = null;

	for (var $i = 0; $i < $aSelect.length; $i++) {
		$cur = $aSelect.options[$i];
		$aSelect.options[$i].selected = $str.match('\\|' + $cur.value + '\\|') ? true : false;
	}
}

function set_selected($selected_options, $aSelect) {
	if ( !$selected_options.length ) return false;

	for (var $i = 0; $i < $aSelect.length; $i++) {
		for (var $k = 0; $k < $selected_options.length; $k++) {
			if ( $aSelect.options[$i].value == $selected_options[$k] ) {
				$aSelect.options[$i].selected = true;
			}
		}
	}
}

function get_selected_count($theList) {
	var $count = 0;
	var $cur = null;

	for (var $i = 0; $i < $theList.length; $i++) {
		$cur = $theList.options[$i];

		if ( $cur.selected ) {
			$count++;
		}
	}

	return $count;
}

function get_selected_index($aSelect, $typeIndex) {
	var $index = 0;

	for (var $i = 0; $i < $aSelect.length; $i++) {
		if ( $aSelect.options[$i].selected ) {
			$index = $i;
			if ( $typeIndex == 'firstSelected' ) {
				break;
			}
		}
	}

	return $index;
}

function has_selected_options($theList) {
	var $ret = false;
	var $cur = null;

	for (var $i = 0; $i < $theList.length; $i++) {
		$cur = $theList.options[$i];

		if ( $cur.selected ) {
			$ret = true;
			break;
		}
	}

	return $ret;
}

function select_sort($aSelect) {
	if ( typeof($aSelect) != 'object' ) {
		$aSelect = document.getElementById($aSelect);
	}

	var $to_array = select_to_array($aSelect);

	$to_array.sort(select_compare);
	array_to_select($to_array, $aSelect);
}

function move_options_up($aSelect, $interval) {
	if ( typeof($aSelect) != 'object' ) {
		$aSelect = document.getElementById($aSelect);
	}

	if ( has_selected_options($aSelect) ) {
		var $selected_options = Array();
		var $first_selected = get_selected_index($aSelect, 'firstSelected');

		for (var $i = 0; $i < $aSelect.length; $i++) {
			if ( $aSelect.options[$i].selected && ($first_selected > 0) ) {
				swap_options($aSelect, $i, $i - $interval);
				$selected_options[$selected_options.length] = $aSelect.options[$i - $interval].value;
			}
			else if ( $first_selected == 0 ) {
				//alert('Begin of list');
				break;
			}
		}
		set_selected($selected_options, $aSelect);
	}
	else {
		//alert('Check items from moving');
	}
}

function move_options_down($aSelect, $interval) {
	if ( typeof($aSelect) != 'object' ) {
		$aSelect = document.getElementById($aSelect);
	}

	if ( has_selected_options($aSelect) ) {
		var $last_selected = get_selected_index($aSelect, 'lastSelected');
		var $selected_options = Array();

		for (var $i = $aSelect.length - 1; $i >= 0; $i--) {
			if ( $aSelect.options[$i].selected && ($aSelect.length - ($last_selected + 1) > 0) ) {
				swap_options($aSelect, $i, $i + $interval);
				$selected_options[$selected_options.length] = $aSelect.options[$i + $interval].value;
			}
			else if ( $last_selected + 1 == $aSelect.length ) {
				//alert('End of list');
				break;
			}
		}
		set_selected($selected_options, $aSelect);
	}
	else {
		//alert('Check items from moving');
	}
}

function swap_options($aSelect, $src_num, $dst_num) {
	var $src_html = $aSelect.options[$src_num].innerHTML;
	var $dst_html = $aSelect.options[$dst_num].innerHTML;
	var $src_value = $aSelect.options[$src_num].value;
	var $dst_value = $aSelect.options[$dst_num].value;

	var $src_option = document.createElement('OPTION');
	var $dst_option = document.createElement('OPTION');

	$aSelect.remove($src_num);
	$aSelect.options.add($dst_option, $src_num);
	$dst_option.innerText = $dst_html;
	$dst_option.value = $dst_value;
	$dst_option.innerHTML = $dst_html;

	$aSelect.remove($dst_num);
	$aSelect.options.add($src_option, $dst_num);
	$src_option.innerText = $src_html;
	$src_option.value = $src_value;
	$src_option.innerHTML = $src_html;
}

function getXMLHTTPObject(content_type) {
	if ( !isset(content_type) ) {
		content_type = 'text/plain';
	}

	var http_request = false;

	if ( window.XMLHttpRequest ) { // Mozilla, Safari,...
		http_request = new XMLHttpRequest();

		if ( http_request.overrideMimeType ) {
			http_request.overrideMimeType(content_type);
			// See note below about this line
		}
	} else if ( window.ActiveXObject ) { // IE
		try {
			http_request = new ActiveXObject("Msxml2.XMLHTTP");
		} catch (e) {
			try {
				http_request = new ActiveXObject("Microsoft.XMLHTTP");
			} catch (e) {
			}
		}
	}

	return http_request;
}

function str_repeat($symbol, $count) {
	var $i = 0;
	var $ret = '';

	while ($i < $count) {
		$ret += $symbol;
		$i++;
	}

	return $ret;
}

function getDocumentFromXML(xml) {
	if ( window.ActiveXObject ) {
		var doc = new ActiveXObject("Microsoft.XMLDOM");
		doc.async = false;
		doc.loadXML(xml);
	}
	else {
		var parser = new DOMParser();
		var doc = parser.parseFromString(xml, "text/xml");
	}

	return doc;
}

function set_persistant_var($var_name, $var_value, $t, $form_action) {
	set_hidden_field('field', $var_name);
	set_hidden_field('value', $var_value);
	submit_event('u', 'OnSetPersistantVariable', $t, $form_action);
}

function setCookie($Name, $Value) {
	// set cookie
	if ( getCookie($Name) != $Value ) {
		document.cookie = $Name + '=' + escape($Value);
	}
}

function getCookie($Name) {
	// get cookie
	var $cookieString = document.cookie;
	var $index = $cookieString.indexOf($Name + '=');

	if ( $index == -1 ) {
		return null;
	}

	$index = $cookieString.indexOf('=', $index) + 1;

	var $endstr = $cookieString.indexOf(';', $index);

	if ( $endstr == -1 ) {
		$endstr = $cookieString.length;
	}

	return unescape($cookieString.substring($index, $endstr));
}

function deleteCookie($Name) {
	// deletes cookie
	if ( getCookie($Name) ) {
		var d = new Date();

		document.cookie = $Name + '=;expires=' + d.toGMTString() + ';' + ';';
	}
}

function addElement($dst_element, $tag_name) {
	var $new_element = document.createElement($tag_name.toUpperCase());
	$dst_element.appendChild($new_element);

	return $new_element;
}

Math.sum = function ($array) {
	var $i = 0;
	var $total = 0;

	while ($i < $array.length) {
		$total += $array[$i];
		$i++;
	}

	return $total;
}

Math.average = function ($array) {
	return Math.sum($array) / $array.length;
}

// remove spaces and underscores from a string, used for nls_menu
function rs(str, is_phrase) {
	if ( isset(is_phrase) && is_phrase ) {
		str = RemoveTranslationLink(str, false);
	}

	return str.replace(/[ _\']+/g, '.');
}

function getFrame($name) {
	var $main_window = window;

	// 1. cycle through popups to get main window
	try {
		// will be error, when other site is opened in parent window
		var $i = 0,
			$opener,
			$is_frameset = false;

		do {
			if ( $i == 10 || $is_frameset ) {
				break;
			}

			// try to get popup window opener
			$opener = $main_window.opener;

			if ( !$opener ) {
				// not inside a popup, then we're inside a frameset already - get it once
				$is_frameset = true;
				$opener = $main_window.parent;
			}

			if ( $opener ) {
				$main_window = $opener;
			}

			$i++;
		} while ($opener);
	}
	catch (err) {
//		catch Access/Permission Denied error
//		alert('getFrame.Error: [' + err.description + ']');

		return window;
	}

	var $frameset = $main_window.parent.frames;

	for ($i = 0; $i < $frameset.length; $i++) {
		if ( $frameset[$i].name == $name ) {
			return $frameset[$i];
		}
	}

	return $main_window.parent;
}

function ClearBrowserSelection() {
	if ( window.getSelection ) {
		// removeAllRanges will be supported by Opera from v 9+, do nothing by now
		var selection = window.getSelection();

		if ( selection.removeAllRanges ) { // Mozilla & Opera 9+
//			alert('clearing FF')
			window.getSelection().removeAllRanges();
		}
	} else if ( document.selection && !is.opera ) { // IE
//	 	alert('clearing IE')
		document.selection.empty();
	}
}

function reset_form(prefix, event, msg) {
	if ( confirm(RemoveTranslationLink(msg, true)) ) {
		submit_event(prefix, event)
	}
}

function cancel_edit(prefix, cancel_ev, save_ev, msg) {
	if ( (!Form || (Form && Form.HasChanged)) && confirm(RemoveTranslationLink(msg, true)) ) {
		submit_event(prefix, save_ev)
	}
	else {
		submit_event(prefix, cancel_ev)
	}
}


function execJS(node) {
	var bSaf = (navigator.userAgent.indexOf('Safari') != -1);
	var bOpera = (navigator.userAgent.indexOf('Opera') != -1);
	var bMoz = (navigator.appName == 'Netscape');

	if ( !node ) {
		return;
	}

	/* IE wants it uppercase */
	var st = node.getElementsByTagName('SCRIPT');
	var strExec;

	for (var i = 0; i < st.length; i++) {
		if ( bSaf ) {
			strExec = st[i].innerHTML;
			st[i].innerHTML = "";
		} else if ( bOpera ) {
			strExec = st[i].text;
			st[i].text = "";
		} else if ( bMoz ) {
			strExec = st[i].textContent;
			st[i].textContent = "";
		} else {
			strExec = st[i].text;
			st[i].text = "";
		}

		try {
			var x = document.createElement("script");

			x.type = "text/javascript";

			/* In IE we must use .text! */
			if ( (bSaf) || (bOpera) || (bMoz) ) {
				x.innerHTML = strExec;
			}
			else {
				x.text = strExec;
			}

			document.getElementsByTagName("head")[0].appendChild(x);
		} catch (e) {
			alert(e);
		}
	}
}
;

function NumberFormatter() {
}

NumberFormatter.ThousandsSep = '\'';
NumberFormatter.DecimalSep = '.';

NumberFormatter.Parse = function (num) {
	if ( num == '' ) {
		return 0;
	}

	var $string = num.toString();

	// we could have multiple thousand separators !
	return parseFloat($string.replace(new RegExp(this.ThousandsSep, 'g'), '').replace(this.DecimalSep, '.'));
}

NumberFormatter.Format = function (num) {
	num += '';
	x = num.split('.');
	x1 = x[0];
	x2 = x.length > 1 ? this.DecimalSep + x[1] : '';

	var rgx = /(\d+)(\d{3})/;

	while (rgx.test(x1)) {
		x1 = x1.replace(rgx, '$1' + this.ThousandsSep + '$2');
	}

	return x1 + x2;
}

function getDimensions(obj) {
	var style

	if ( obj.currentStyle ) {
		style = obj.currentStyle;
	}
	else {
		style = getComputedStyle(obj, '');
	}

	padding = [parseInt(style.paddingTop), parseInt(style.paddingRight), parseInt(style.paddingBottom), parseInt(style.paddingLeft)]
	border = [parseInt(style.borderTopWidth), parseInt(style.borderRightWidth), parseInt(style.borderBottomWidth), parseInt(style.borderLeftWidth)]

	for (var i = 0; i < padding.length; i++) {
		if ( isNaN(padding[i]) ) {
			padding[i] = 0
		}
	}

	for (var i = 0; i < border.length; i++)  {
		if ( isNaN(border[i]) ) {
			border[i] = 0
		}
	}

	var result = new Object();

	result.innerHeight = obj.clientHeight - padding[0] - padding[2];
	result.innerWidth = obj.clientWidth - padding[1] - padding[3];
	result.padding = padding;
	result.borders = border;

	result.outerHeight = obj.clientHeight + border[0] + border[2];
	result.outerWidth = obj.clientHeight + border[1] + border[3];

	return result;
}

function findPos(obj, with_scroll) {
	/*var $offset = $(obj).offset();

	 return [$offset.left, $offset.top];*/

	if ( !with_scroll ) {
		var with_scroll = false;
	}

	var curleft = curtop = 0;

	if ( obj.offsetParent ) {
		curleft = obj.offsetLeft - (with_scroll ? obj.scrollLeft : 0)
		curtop = obj.offsetTop - (with_scroll ? obj.scrollTop : 0)

		while (obj = obj.offsetParent) {
			curleft += obj.offsetLeft - (with_scroll ? obj.scrollLeft : 0)
			curtop += obj.offsetTop - (with_scroll ? obj.scrollTop : 0)
		}
	}

	return [curleft, curtop];
}

function scrollbarWidth() {
	// Scrollbalken im Body ausschalten
	var $overflow_backup = document.body.style.overflow;
	document.body.style.overflow = 'hidden';

	var width = document.body.clientWidth;

	// Scrollbalken
	document.body.style.overflow = 'scroll';
	width -= document.body.clientWidth;

	// Der IE im Standardmode
	if ( !width ) {
		width = document.body.offsetWidth - document.body.clientWidth;
	}

	// urspr?ngliche Einstellungen
	document.body.style.overflow = $overflow_backup;

	return width;
}

function maximizeElement($selector, $max_height) {
	if ( $max_height === undefined ) {
		$max_height = false;
	}

	var $element = $($selector);
	if ( $element.length == 0 ) {
		return;
	}

	$element.width('100%');

	var $container_id = $element.attr('id') + '_container';
	var $container = $(jq('#' + $container_id));

	if ( $container.length == 0 ) {
		// don't create same container twice

		// all <script> tags will be executed again after wrap method is called, so remove them to prevent that
		$('script', $element).remove();
		$element.wrap('<div id="' + $container_id + '" style="position: relative; overflow: auto; width: 100%;"></div>');
		$container = $(jq('#' + $container_id));

		$(window).resize(
			function () {
				maximizeElement($selector, $max_height);
			}
		);
	}

	var $offset_top = $container.offset().top;
	var $window_height = $(window).height();

	var $height_left = $window_height - $offset_top;

	if ( ($max_height !== false) && ($max_height < $height_left) ) {
		$height_left = $max_height;
	}

	$height_left -= ($element.outerHeight() - $element.height());
	$container.height($height_left);

	var $element_width = $(window).width() - ($element.outerWidth() - $element.width());
	if ( $height_left < $element.height() ) {
		// needs vertical scrolling, so substract vertical scrollbar width
		$element_width -= scrollbarWidth();
	}

	$element.width($element_width);
}

function addEvent(el, evname, func, traditional) {
	if ( traditional ) {
		eval('el.on' + evname + '=' + func);
		return;
	}

	if ( evname.match(/mousedown|mousemove|mouseup/) ) {
		$(el)
			.unbind(evname)// don't allow more then one
			.bind(evname, func);
		return;
	}

	if ( is.ie ) {
		el.attachEvent("on" + evname, func);
	} else {
		el.addEventListener(evname, func, true);
	}
}

/*function removeEvent(el, evname, func) {
 if (is.ie) {
 el.detachEvent('on' + evname, func);
 } else {
 el.removeEventListener(evname, func, true);
 }
 }*/

function addLoadEvent(func, wnd) {
	Application.setHook('m:OnAfterWindowLoad', func);
}

function replaceFireBug() {
	if ( window.console === undefined || !console.firebug ) {
		var names = [
			'log', 'debug', 'info', 'warn', 'error', 'assert', 'dir', 'dirxml',
			'group', 'groupEnd', 'time', 'timeEnd', 'count', 'trace', 'profile', 'profileEnd'
		];

		if ( window.top.console !== undefined || window.top.firebug ) {
			// console is not defined in iframes, so define it here
			window.console = window.top.console;
			window._getFirebugConsoleElement = window.top._getFirebugConsoleElement;
		}
		else {
			window.console = {};

			for (var i = 0; i < names.length; ++i) {
				window.console[names[i]] = function ($msg) {
					alert('FireBug console object methods are not available outside Firefox!' + "\n" + $msg);
				}
			}
		}
	}
}
function runOnChange(elId) {
	var evt;
	var el = typeof(elId) == 'string' ? document.getElementById(elId) : elId

	if ( document.createEvent ) {
		evt = document.createEvent("HTMLEvents");
		evt.initEvent("change", true, false);
		(evt) ? el.dispatchEvent(evt) : (el.onchange && el.onchange());
		return;
	}
	if ( el.fireEvent ) {
		el.fireEvent('onchange');
	}
}
function WatchClosing(win, $url) {
	window.setTimeout(function () {
			if ( win.closed ) {
				var req = Request.getRequest();
				var $ajax_mark = ($url.indexOf('?') ? '&' : '?') + 'ajax=yes';
				req.open('GET', $url + $ajax_mark, false); //!!!SYNCRONIOUS!!! REQUEST (3rd param = false!!!)
				req.send(null);
			}
		},
		2000
	)
}

function IterateUploaders($method) {
	if ( typeof UploadsManager != 'undefined' ) {
		UploadsManager.iterate($method);
	}
}

String.prototype.trim = function () {
	return this.replace(/\s*((\S+\s*)*)/, "$1").replace(/((\s*\S+)*)\s*/, "$1");
}

String.prototype.toNumeric = function () {
	return parseInt(this.replace(/(auto|medium)/, '0px').replace(/[a-z]/gi, ''));
}

function jq($selector) {
	return $selector.replace(/(\[|\]|\.)/g, '\\$1');
}

function setHelpLink($user_docs_url, $title_preset) {
	if ( !$user_docs_url ) {
		return;
	}

	$('#help_link', getFrame('head').document).attr('href', $user_docs_url + '/' + $title_preset);
}

// window management functions:

function getWindowOpener($window) {
	// use this intead of "window.opener"
	if ( !$modal_windows ) {
		return $window.opener;
	}

	if ( $window.name == 'main' || $window.name == 'main_frame' ) {
		return null;
	}

	return getFrame('main').TB.findWindow($window.name, -1);
}

function window_close($close_callback) {
	// use this instead of "window.close();"
	if ( !$modal_windows ) {
		if ( $.isFunction($close_callback) ) {
			// use close callback, because iframe will be removed later in this method
			$close_callback();
		}

		window.close();
		return;
	}

	if ( window.name == 'main' ) {
		return;
	}

	if ( $close_callback !== undefined ) {
		return getFrame('main').TB.remove(null, $close_callback);
	}

	return getFrame('main').TB.remove();
}

function onAfterWindowClose($redirect_url, $open_new_window, $force_skip_refresh) {
	if ( $open_new_window ) {
		var $ru = $redirect_url;

		// setTimeout allows to call method indirectly. Without it whole idea won't work 2nd time (try adding 2 relations one after another)
		setTimeout(
			function () {
				openSelector('adm', $ru.replace(/%5C/g, '\\') + '&merge_opener_stack=1');
			},
			200
		);

		return;
	}

	window.focus();

	if ( !(($force_skip_refresh === true) || (typeof $skip_refresh != 'undefined' && $skip_refresh)) ) {
		window.location.href = $redirect_url.replace(/%5C/g, '\\');
	}
}

function get_control($mask, $field, $append, $prepend) {
	$append = $append !== undefined ? '_' + $append : '';
	$prepend = $prepend !== undefined ? $prepend + '_' : '';

	return document.getElementById($prepend + $mask.replace('#FIELD_NAME#', $field) + $append);
}

Array.prototype.each = function ($callback) {
	var $result = null;

	for (var $i = 0; $i < this.length; $i++) {
		$result = $callback.call(this[$i], $i);
		if ( $result === false ) {
			break;
		}
	}
}

function disable_categories($category_dropdown_id, $allowed_categories) {
	if ( $allowed_categories === true ) {
		return;
	}

	var $selected_category = false;
	var $categories = $(jq('#' + $category_dropdown_id)).children('option');

	$categories.each(
		function () {
			var $me = $(this);
			var $category_id = parseInt($me.attr('value'));

			if ( !in_array($category_id, $allowed_categories) ) {
				if ( $me.attr('selected') ) {
					$selected_category = $me;
				}

				$me.attr('disabled', 'disabled');
			}
		}
	);

	if ( $selected_category !== false && $allowed_categories.length > 0 ) {
		// when selected category became disabled -> select 1st available category
		$selected_category.attr('selected', '');
		$("option[value='" + $allowed_categories[0] + '"]', $categories).attr('selected', 'selected');
	}
}

function crc32(str) {
	var table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

	var crc = 0;
	var x = 0;
	var y = 0;

	crc = crc ^ (-1);

	for (var i = 0, iTop = str.length; i < iTop; i++) {
		y = ( crc ^ str.charCodeAt(i) ) & 0xFF;
		x = "0x" + table.substr(y * 9, 8);
		crc = ( crc >>> 8 ) ^ x;
	}

	return crc ^ (-1);
}