<?php
/**
* @version	$Id: page_revisions_config.php 15165 2012-03-09 10:24:24Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'page-revision',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'PageRevisionEventHandler', 'file' => 'page_revision_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'PageRevisionTagProcessor', 'file' => 'page_revision_tp.php', 'build_event' => 'OnBuild'),
		'AutoLoad' => true,
		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
			5 => 'mode', // needed?
		),

		'IDField' => 'RevisionId',
		'ParentTableKey' => 'CategoryId',	// linked field in master table
		'ForeignKey' => 'PageId',	// linked field in subtable
		'ParentPrefix' => 'c',
		'AutoDelete' => true,
		'AutoClone' => true,

		'TitleField' => 'RevisionNumber',

		'TableName' => TABLE_PREFIX . 'PageRevisions',

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s
					FROM %1$s
					LEFT JOIN ' . TABLE_PREFIX . '%3$sCategories c ON c.CategoryId = %1$s.PageId
					LEFT JOIN ' . TABLE_PREFIX . 'Users created_by ON created_by.PortalUserId = %1$s.CreatedById'
		),

		'SubItems' => Array ('content'),

		'ListSortings'	=> 	Array (
			'' => Array (
				'Sorting' => Array ('IsDraft' => 'desc', 'RevisionNumber' => 'desc'),
			)
		),

		'CalculatedFields' => Array (
			'' => Array (
				'CreatedBy' => 'created_by.Username',
				'IsLive' => 'IF(%1$s.RevisionNumber = c.LiveRevisionNumber, 1, 0)',
			),
		),

		'Fields' => Array (
			'RevisionId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'PageId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'RevisionNumber' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'IsDraft' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0
			),
			'FromRevisionId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'CreatedById' => Array (
				'type' => 'int',
				'formatter' => 'kLEFTFormatter', 'options' => Array (USER_ROOT => 'root', USER_GUEST => 'Guest'), 'left_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Users WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Username', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'sample_value' => 'Guest', 'required' => 1,
				'default' => NULL
			),
			'CreatedOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
			'AutoSavedOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
			'Status' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Pending', 1 => 'la_opt_Published', 0 => 'la_opt_Declined'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 2)
		),

		'VirtualFields' => Array (
			'CreatedBy' => Array ('type' => 'string', 'default' => ''),
			'IsLive' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
				'default' => 0,
			)
		),
	);
