<?php
/**
* @version	$Id: modules_config.php 15107 2012-02-07 14:33:43Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'mod',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'ModulesEventHandler','file'=>'modules_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'ModulesTagProcessor','file'=>'modules_tag_processor.php','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,
					'QueryString'		=>	Array(
												1 => 'id',
												2 => 'Page',
												3 => 'PerPage',
												4 => 'event',
												5 => 'mode',
											),

					'IDField'			=>	'Name',
					'TitleField'		=>	'Name',		// field, used in bluebar when editing existing item
					'StatusField'		=>	Array('Loaded'),

					'TitlePresets'		=>	Array(
						'module_list' => Array (
							'prefixes' => Array ('mod_List'), 'format' => "!la_title_Module_Status!",
							'toolbar_buttons' => Array ('approve', 'deny', 'view'),
						),
						'tree_modules'	=>	Array('format' => '!la_section_overview!'),
					),

					'ForceDontLogChanges' => true,

					'PermSection'		=>	Array('main' => 'in-portal:mod_status'),

					'Sections'			=>	Array(
						'in-portal:mod_status'	=>	Array(
							'parent'		=>	'in-portal:website_setting_folder',
							'icon'			=>	'conf_modules',
							'label'			=>	'la_title_Module_Status',
							'url'			=>	Array('t' => 'modules/modules_list', 'pass' => 'm'),
							'permissions'	=>	Array('view', 'edit', 'advanced:approve', 'advanced:decline'),
							'priority'		=>	12,
							'type'			=>	stTREE,
						),

						// "Configuration" -> "Modules and Settings"
						/*'in-portal:tag_library'	=>	Array(
							'parent'		=>	'in-portal:modules',
							'icon'			=>	'modules',
							'label'			=>	'la_tab_TagLibrary',
							'url'			=>	Array('index_file' => 'tag_listing.php', 'pass' => 'm'),
							'permissions'	=>	Array('view'),
							'priority'		=>	3,
							'type'			=>	stTREE,
						),*/
					),

					'TableName' => TABLE_PREFIX . 'Modules',

					'ListSQLs'			=>	Array(	''=>'SELECT * FROM %s',
																		), // key - special, value - list select sql
					'ItemSQLs'			=>	Array(	''=>'SELECT * FROM %s',
																		),
					'ListSortings'	=> 	Array(
												'' => Array(
													'Sorting' => Array('LoadOrder' => 'asc'),
												)
											),

					'Fields'			=>	Array(
										            'Name' => Array('type' => 'string', 'not_null' => 1, 'default' => ''),
										            'Path' => Array('type' => 'string','not_null' => '1','default' => ''),
										            'Var' => Array('type' => 'string','not_null' => '1','default' => ''),
										            'Version' => Array('type' => 'string','not_null' => '1','default' => '0.0.0'),
										            'Loaded' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(1 => 'la_Active', 0 => 'la_Disabled'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 1),
										            'LoadOrder' => Array('type' => 'int','not_null' => 1, 'default' => 0),
										            'TemplatePath' => Array('type' => 'string','not_null' => 1, 'default' => ''),
										            'RootCat' => Array('type' => 'int','not_null' => 1, 'default' => 0),
										            'BuildDate' => Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => null),
													'AppliedDBRevisions' => Array ('type' => 'string', 'default' => NULL)
											),

					'VirtualFields'	=> 	Array(),

					'Grids'	=> Array (
						'Default' => Array (
							'Icons' => Array (
								'default' => 'icon16_item.png',
								0 => 'icon16_disabled.png',
								1 => 'icon16_item.png',
							),
							'Fields' => Array (
								'Name'		=>	Array('data_block' => 'grid_checkbox_td_no_icon', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
								'Version' 	=>	Array('filter_block' => 'grid_like_filter', 'width' => 100, ),
								'Path'		=>	Array('title' => 'la_col_SystemPath', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
								'BuildDate'	=>	Array('title' => 'la_col_BuildDate', 'filter_block' => 'grid_date_range_filter', 'width' => 145, ),
								'Loaded'	=>	Array('title' => 'column:la_fld_Status', 'header_block' => 'grid_column_title_no_sorting', 'data_block' => 'grid_module_td', 'filter_block' => 'grid_options_filter', 'width' => 100, ),
							),
						),
					),
	);