<?php
/**
* @version	$Id: fck_eh.php 15173 2012-03-09 12:35:38Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class FckEventHandler extends kDBEventHandler {

		/**
		 * Allows to override standard permission mapping
		 *
		 * @return void
		 * @access protected
		 * @see kEventHandler::$permMapping
		 */
		protected function mapPermissions()
		{
			parent::mapPermissions();

			$permissions = Array (
				'OnGetsEditorStyles' => Array ('self' => true),
			);

			$this->permMapping = array_merge($this->permMapping, $permissions);
		}

		/**
		 * Checks user permission to execute given $event
		 *
		 * @param kEvent $event
		 * @return bool
		 * @access public
		 */
		public function CheckPermission(kEvent $event)
		{
			if ( $this->Application->isAdminUser || $event->Name == 'OnGetsEditorStyles' ) {
				// this limits all event execution only to logged-in users in admin
				return true;
			}

			return parent::CheckPermission($event);
		}

		function CreateXmlHeader()
		{
			ob_end_clean() ;
			// Prevent the browser from caching the result.
			// Date in the past
			header('Expires: Mon, 26 Jul 1997 05:00:00 GMT') ;
			// always modified
			header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT') ;
			// HTTP/1.1
			header('Cache-Control: no-store, no-cache, must-revalidate') ;
			header('Cache-Control: post-check=0, pre-check=0', false) ;
			// HTTP/1.0
			header('Pragma: no-cache') ;
			// Set the response format.

			$this->Application->setContentType('text/xml');
			// Create the XML document header.
		}

		function OnLoadCmsTree($event)
		{
			$event->status = kEvent::erSTOP;

			$category_helper = $this->Application->recallObject('CategoryHelper');
			/* @var $category_helper CategoryHelper */

			$pages = $category_helper->getStructureTreeAsOptions();

			$sql = 'SELECT NamedParentPath, CategoryId
					FROM ' . TABLE_PREFIX . 'Categories
					WHERE CategoryId IN (' . implode(',', array_keys($pages)) . ')';
			$templates = $this->Conn->GetCol($sql, 'CategoryId');

			$templates[$this->Application->getBaseCategory()] .= '/Index'; // "Content" category will act as "Home Page"

			$res = '<?xml version="1.0" encoding="utf-8" ?>' . "\n";
			$res .= '<CmsPages>' . "\n";

			foreach ($pages as $id => $title) {
				$template = $templates[$id];
				$page_path = preg_replace('/^Content\//i', '', strtolower($template).'.html');

				$title = $title . ' (' . $page_path . ')';
				$real_url = $this->Application->HREF($template, '_FRONT_END_', array('pass' => 'm'), 'index.php');

				$res .= '<CmsPage real_url="' . $real_url . '" path="@@' . $id . '@@" title="' . htmlspecialchars($title, ENT_QUOTES) . '" st_id="' . $id . '" serverpath="" />' . "\n";
			}

			$res.= "</CmsPages>";

			$this->CreateXmlHeader();
			echo $res;
		}

		function OnRenameFile($event)
		{
			$event->status = kEvent::erSTOP;

			if ($this->Application->CheckPermission('SYSTEM_ACCESS.READONLY', 1)) {
				return;
			}

			$old_name = $this->Application->GetVar('old_name');
			$new_name = $this->Application->GetVar('new_name');
			$folder = $this->Application->GetVar('folder');
			$sServerDir = WRITEABLE . '/user_files/' . $folder . '/';

			if (!file_exists($sServerDir.$old_name) || !is_file($sServerDir.$old_name)) {
				echo 204;
				return;
			}

			$fck_helper = $this->Application->recallObject('FCKHelper');
			/* @var $fck_helper fckFCKHelper*/

			if ( !$fck_helper->IsAllowedExtension($folder, $new_name) ) {
				echo 203;
				return;
			}

			if ( !rename($sServerDir . $old_name, $sServerDir . $new_name) ) {
//			echo $sServerDir.$old_name.' -> '.$sServerDir.$new_name;
				echo 205;
				return;
			}

			echo '0';
		}


		function OnDeleteFiles($event)
		{
			$event->status = kEvent::erSTOP;

			if ($this->Application->CheckPermission('SYSTEM_ACCESS.READONLY', 1)) {
				return;
			}

			$files = trim($this->Application->GetVar('files'),'|');
	//		echo $files;
			$a_files = explode('|', $files);
			$folder = $this->Application->GetVar('folder');
			$sServerDir = WRITEABLE . '/user_files/' . $folder . '/';

			foreach ($a_files AS $file) {
				@unlink($sServerDir.$file);
			}

	//		print_r($a_files);
		}

		function OnGetFoldersFilesList($event)
		{
			$this->CreateXmlHeader();

			$fck_helper = $this->Application->recallObject('FCKHelper');
			/* @var $fck_helper fckFCKHelper */

			$ret = '<?xml version="1.0" encoding="utf-8" ?>'."\n" ;
			$ret .= "<content>"."\n";
			$ret .= $fck_helper->PrintFolders();
			$ret .= $fck_helper->PrintFiles();
			$ret .= "</content>"."\n";
			echo $ret;
			exit;
		}


		function OnCreateFolder($event)
		{
			$event->status = kEvent::erSTOP;

			if ($this->Application->CheckPermission('SYSTEM_ACCESS.READONLY', 1)) {
				return;
			}

			$new_folder 	= $this->Application->GetVar('new_folder');
			$current_folder	= $this->Application->GetVar('current_folder');
			$folderPath = WRITEABLE . '/user_files' . '/' . $current_folder . "/" . $new_folder;
			if ( file_exists( $folderPath ) && is_dir($folderPath)) {
				echo "101";
			}

			if ( !file_exists( $folderPath ) )
			{
				// Turn off all error reporting.
				error_reporting( 0 ) ;
				// Enable error tracking to catch the error.
				ini_set( 'track_errors', '1' ) ;
				// To create the folder with 0777 permissions, we need to set umask to zero.
				$oldumask = umask(0) ;
				mkdir( $folderPath, 0777 ) ;
				umask( $oldumask ) ;
				$sErrorMsg = $php_errormsg ;
				// Restore the configurations.
				ini_restore( 'track_errors' ) ;
				ini_restore( 'error_reporting' ) ;
				if ($sErrorMsg)
					echo  $sErrorMsg ;
				else
					echo '0';
			}
		}

		/**
		 * Uploads a file from FCK file browser
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnUploadFile(kEvent $event)
		{
			$event->status = kEvent::erSTOP;

			if ( $this->Application->CheckPermission('SYSTEM_ACCESS.READONLY', 1) ) {
				return;
			}

			$fck_helper = $this->Application->recallObject('FCKHelper');
			/* @var $fck_helper fckFCKHelper*/

			$fck_helper->UploadFile();
		}

		/**
		 * Returns compressed CSS file
		 *
		 * @param kEvent $event
		 */
		function OnGetsEditorStyles($event)
		{
			$minify_helper = $this->Application->recallObject('MinifyHelper');
			/* @var $minify_helper MinifyHelper */

			$this->Application->InitParser();
			$styles_css = $minify_helper->CompressScriptTag( Array ('files' => 'inc/style.css') );

			$event->redirect = 'external:' . $styles_css;
		}
	}