<?php
/**
* @version	$Id: promo_block_group_tp.php 15174 2012-03-09 12:44:02Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class PromoBlockGroupTagProcessor extends kDBTagProcessor {

	/**
	 * Print list of categories
	 *
	 * @param Array $params
	 * @return string
	 * @access protected
	 */
	protected function PrintCategories(Array $params)
	{
		$object = $this->getObject($params);
		/* @var $object kDBItem */

		$ret = '';
		$field = $this->SelectParam($params, 'name,field');
		$categories = explode(';', $object->GetDBField($field));

		$block_params = $this->prepareTagParams($params);
		$block_params['name'] = $params['render_as'];

		foreach ($categories as $category_id) {
			if ( $category_id ) {
				$block_params['cat_id'] = $category_id;
				$ret .= $this->Application->ParseBlock($block_params);
			}
		}

		return $ret;
	}

	/**
	 * Returns link to edit promo block group, associated with this promo block list
	 *
	 * @param Array $params
	 * @return string
	 * @return protected
	 */
	protected function EditLink(Array $params)
	{
		$object = $this->getObject($params);
		/* @var $object kDBItem */

		$prefix = $object->getPrefixSpecial();

		$url_params = Array (
			'm_opener' => 'd',
			$prefix . '_mode' => 't',
			$prefix . '_event' => 'OnEdit',
			$prefix . '_id' => $object->GetID(),
			'pass' => 'all,' . $prefix,
			'no_pass_through' => 1,
		);

		return $this->Application->HREF($params['edit_template'], '', $url_params);
	}
}
