<?php
/**
* @version	$Id: user_groups_config.php 15012 2012-01-06 20:38:49Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'	=> 'ug',
					'Clones'	=> Array(
											'g-ug'	=>	Array(
																'ParentPrefix'		=>	'g',
																'ForeignKey'		=>	'GroupId',
																'ParentTableKey' 	=> 	'GroupId',

																'IDField'			=>	'PortalUserId',

																'ListSQLs'	=>	Array(
																	''	=>	'	SELECT %1$s.* %2$s FROM %1$s
																						LEFT JOIN '.TABLE_PREFIX.'UserGroups g ON %1$s.GroupId = g.GroupId
																						LEFT JOIN '.TABLE_PREFIX.'Users u ON %1$s.PortalUserId = u.PortalUserId'
															),
																'ItemSQLs'	=>	Array(
																	''	=>	'	SELECT %1$s.* %2$s FROM %1$s
																						LEFT JOIN '.TABLE_PREFIX.'UserGroups g ON %1$s.GroupId = g.GroupId
																						LEFT JOIN '.TABLE_PREFIX.'Users u ON %1$s.PortalUserId = u.PortalUserId'
																),
																'CalculatedFields'	=>	Array (
																	''	=>	Array(
																		'UserName' => 'CONCAT(u.LastName, \' \', u.FirstName)',
																		'UserLogin' => 'u.Username',
																		'PrimaryGroup' => 'IF(u.PrimaryGroupId = %1$s.GroupId, 1, 0)',
																	),
																),
																'VirtualFields'	=> Array (
																	'UserName' => Array('type' => 'string', 'default' => ''),
																	'UserLogin' => Array('type' => 'string', 'default' => ''),
																),
																'Grids'	=> Array(
																	'GroupUsers'	=>	Array(
																		'Icons' => Array ('default' => 'icon16_item.png'),
																		'Fields' => Array(
																			'PortalUserId'			=> Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
																			'UserName'			=> Array ('title'=>'la_col_UserFirstLastName', 'width' => 200, ),
																			'UserLogin'			=> Array ('title'=>'column:la_fld_Username', 'width' => 100, ),
																			'PrimaryGroup'	=> Array( 'title'=>'la_col_PrimaryGroup', 'filter_block' => 'grid_options_filter', 'width' => 100, ),
																			'MembershipExpires'	=>	Array ('title' => 'la_col_MembershipExpires', 'data_block' => 'grid_membership_td', 'filter_block' => 'grid_date_range_filter', 'width' => 150, ),
																		),
																	),
																),
															),

											'u-ug'	=>	Array(
																'ParentPrefix'		=>	'u',
																'ForeignKey'		=>	'PortalUserId',
																'ParentTableKey' 	=> 	'PortalUserId',
															),
									),

					'ItemClass'			=>	Array('class'=>'UserGroups_DBItem','file'=>'user_groups_dbitem.php','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'UserGroupsEventHandler','file'=>'user_groups_eh.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'kDBTagProcessor','file'=>'','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,

					'QueryString' => Array (
						1 => 'id',
						2 => 'Page',
						3 => 'PerPage',
						4 => 'event',
					),

					'IDField'			=>	'GroupId',

					'TitleField' => 'GroupName',
					'TableName'			=>	TABLE_PREFIX.'UserGroupRelations',

					'ListSQLs'			=>	Array(	''=>'	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'UserGroups g ON %1$s.GroupId = g.GroupId
															LEFT JOIN '.TABLE_PREFIX.'%3$sUsers u ON %1$s.PortalUserId = u.PortalUserId'),

					'AutoDelete'		=>	true,
					'AutoClone'			=> 	false,

					'CalculatedFields'	=>	Array (
						''	=>	Array(
							'GroupName' => 'g.Name',
							'GroupDescription' => 'g.Description',
							'PrimaryGroup' => 'IF(u.PrimaryGroupId = %1$s.GroupId, 1, 0)',
						),
					),

					'Fields'			=>	Array(
						'PortalUserId'				=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0),
						'GroupId'					=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0),
						'MembershipExpires' 		=> Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => null),
						'ExpirationReminderSent'	=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0),
									        ),

					'VirtualFields'	=> Array (
						'GroupName' => Array('type' => 'string', 'default' => ''),
						'GroupDescription' => Array('type' => 'string', 'default' => ''),
						'PrimaryGroup' => Array(
							'type' => 'int',
							'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
							'not_null' => 1, 'default' => 1
						),
					),


					'Grids'	=> Array(
						'Default'	=>	Array(
							'Icons' => Array (
								'default' => 'icon16_item.png',
								1 => 'icon16_primary.png'
							),
							'Fields' => Array(
								'GroupId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
								'GroupName' => Array ('width' => 100, ),
								'GroupDescription' => Array ('title' => 'column:la_fld_Description', 'width' => 150, ),
								'PrimaryGroup'	=> Array( 'title'=>'la_col_PrimaryGroup', 'filter_block' => 'grid_options_filter', 'width' => 150, ),
								'MembershipExpires'	=>	Array ('title' => 'la_col_MembershipExpires', 'data_block' => 'grid_membership_td', 'filter_block' => 'grid_date_range_filter', 'width' => 150, ),
							),
						),
					),

	);