<?php
/**
* @version	$Id: email_logs_config.php 14585 2011-09-24 12:04:17Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'email-log',
		'ItemClass' => Array('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'kDBEventHandler', 'file' => '', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
			5 => 'mode',
		),

		'IDField' => 'EmailLogId',

		'TableName' => TABLE_PREFIX . 'EmailLog',

		'TitlePresets' => Array (
			'email_log_list' => Array ('prefixes' => Array('email-log_List'), 'format' => '!la_tab_EmailLog!',),
		),

		'PermSection' => Array ('main' => 'in-portal:emaillog'),

		'Sections' => Array (
			'in-portal:emaillog' => Array (
				'parent'		=>	'in-portal:reports',
				'icon'			=>	'email_log',
				'label'			=>	'la_tab_EmailLog',
				'url'			=>	Array('t' => 'logs/email_logs/email_log_list', 'pass' => 'm'),
				'permissions'	=>	Array ('view', 'delete'),
				'priority'		=>	5,
				'type'			=>	stTREE,
			),
		),

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s FROM %1$s',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('timestamp' => 'desc'),
			)
		),

		'Fields' => Array (
			'EmailLogId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'fromuser' => Array ('type' => 'string', 'max_len' => 200, 'default' => NULL),
			'addressto' => Array ('type' => 'string', 'max_len' => 255, 'default' => NULL),
			'subject' => Array ('type' => 'string', 'max_len' => 255, 'default' => NULL),
			'timestamp' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
			'event' => Array ('type' => 'string', 'max_len' => 100, 'default' => NULL),
			'EventParams' => Array ('type' => 'string', 'default' => NULL),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array ('default' => 'icon16_item.png'),
				'Fields' => Array (
					'EmailLogId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 50, ),
					'fromuser' => Array ('title' => 'la_prompt_FromUsername', 'filter_block' => 'grid_like_filter', 'width' => 200,  ),
					'addressto' => Array ('title' => 'la_prompt_AddressTo', 'filter_block' => 'grid_like_filter', 'width' => 200,  ),
					'subject' => Array ('filter_block' => 'grid_like_filter', 'width' => 200,  ),
					'event' => Array ('filter_block' => 'grid_like_filter', 'width' => 170,  ),
					'timestamp' => Array ('title' => 'la_prompt_SentOn', 'filter_block' => 'grid_date_range_filter', 'width' => 145,  ),
//					'EventParams' => Array ('title' => 'la_col_EventParams', 'filter_block' => 'grid_like_filter', ),
				),
			),
		),
	);