<?php
/**
* @version	$Id$
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

abstract class kUrlProcessor extends kBase {

	/**
	 * Reference to kUrlProcessor class instance
	 *
	 * @var kUrlManager
	 */
	protected $manager = null;

	public function __construct(&$manager)
	{
		parent::__construct();

		$this->setManager($manager);
	}

	/**
	 * Sets reference to url manager
	 *
	 * @param kUrlManager $manager
	 * @return void
	 * @access public
	 */
	public function setManager(&$manager)
	{
		$this->manager =& $manager;
	}

	/**
	 * Returns sorted array of passed prefixes (to build url from)
	 *
	 * @param string $pass
	 * @return Array
	 * @access protected
	 */
	protected function getPassInfo($pass = 'all')
	{
		if ( !$pass ) {
			$pass = 'all';
		}

		$pass = trim(
				preg_replace(
					'/(?<=,|\\A)all(?=,|\\z)/',
					trim($this->Application->GetVar('passed'), ','),
					trim($pass, ',')
				),
		 ',');

		if ( !$pass ) {
			return Array ();
		}

		$pass_info = array_unique(explode(',', $pass)); // array( prefix[.special], prefix[.special] ...

		// we need to keep that sorting despite the sorting below, because this sorts prefixes with same priority by name
		sort($pass_info, SORT_STRING); // to be prefix1,prefix1.special1,prefix1.special2,prefix3.specialX

		foreach ($pass_info as $prefix) {
			list ($prefix_only,) = explode('.', $prefix, 2);
			$sorted[$prefix] = $this->Application->getUnitOption($prefix_only, 'RewritePriority', 0);
		}

		asort($sorted, SORT_NUMERIC);
		$pass_info = array_keys($sorted);

		// ensure that "m" prefix is at the beginning
		$main_index = array_search('m', $pass_info);
		if ( $main_index !== false ) {
			unset($pass_info[$main_index]);
			array_unshift($pass_info, 'm');
		}

		return $pass_info;
	}

	/**
	 * Builds url
	 *
	 * @param string $t
	 * @param Array $params
	 * @param string $pass
	 * @param bool $pass_events
	 * @param bool $env_var
	 * @return string
	 * @access public
	 */
	abstract public function build($t, $params, $pass='all', $pass_events = false, $env_var = true);

	/**
	 * Parses given string into a set of variables
	 *
	 * @abstract
	 * @param string $string
	 * @param string $pass_name
	 * @return Array
	 * @access public
	 */
	abstract public function parse($string, $pass_name = 'passed');

	/**
	 * Builds env part that corresponds prefix passed
	 *
	 * @param string $prefix_special item's prefix & [special]
	 * @param Array $params url params
	 * @param bool $pass_events
	 * @return string
	 * @access protected
	 */
	abstract protected function BuildModuleEnv($prefix_special, &$params, $pass_events = false);
}