<?php
/**
* @version	$Id: unit_formatter.php 14748 2011-11-09 09:35:48Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class kUnitFormatter extends kFormatter {

	/**
	 * The method is supposed to alter config options or cofigure object in some way based on its usage of formatters
	 * The methods is called for every field with formatter defined when configuring item.
	 * Could be used for adding additional VirtualFields to an object required by some special Formatter
	 *
	 * @param string $field_name
	 * @param array $field_options
	 * @param kDBBase $object
	 */
	function PrepareOptions($field_name, &$field_options, &$object)
	{
		if( !isset($field_options['master_field']) )
		{
			$regional =& $this->Application->recallObject('lang.current');
			/* @var $regional LanguagesItem */
			
			$add_fields = Array();
			$options_a =  Array('type' => 'int','error_field' => $field_name,'master_field' => $field_name,'format' => '%d' );
			$options_b =  Array('type' => 'double','error_field' => $field_name,'master_field' => $field_name,'format' => '%0.2f' );

			switch( $regional->GetDBField('UnitSystem') )
			{
				case 2: // US/UK
					$field_options_copy = $field_options;
					unset($field_options_copy['min_value_exc']);
					$add_fields[$field_name.'_a'] = kUtil::array_merge_recursive($field_options_copy, $options_a);
					$add_fields[$field_name.'_b'] = kUtil::array_merge_recursive($field_options_copy, $options_b);
				break;
				default:
			}

			$add_fields = kUtil::array_merge_recursive($add_fields, $object->getVirtualFields());
			$object->setVirtualFields($add_fields);
		}
	}

	/**
	 * Used for split fields like timestamp -> date, time
	 * Called from DBItem Validate (before validation) to get back master field value from its sub_fields
	 *
	 * @param string $field
	 * @param mixed $value
	 * @param Array $options
	 * @param kDBItem $object
	 */
	function UpdateMasterFields($field, $value, &$options, &$object)
	{
		if ( isset($options['master_field']) || ($value == -1) ) {
			// for infinity setting, otherwise infinity is incorrectly converted back to Kg
			return ;
		}

		$regional =& $this->Application->recallObject('lang.current');
		/* @var $regional LanguagesItem */

		if ( $regional->GetDBField('UnitSystem') == 2 ) {
			// US/UK
			$major = $this->TypeCast($object->GetDBField($field . '_a'), $options);
			$minor = $this->TypeCast($object->GetDBField($field . '_b'), $options);

			if ( $major === '' && $minor === '' ) {
				$value = null;
			}
			elseif ( $major === null && $minor === null ) {
				$fields = $object->getFields();
				unset($fields[$field]);

				$object->setFields($fields);
				return;
			}
			else {
				$value = kUtil::Pounds2Kg($major, $minor);
			}
		}

		$object->SetDBField($field, $value);
	}

	/**
	 * Used for split fields like timestamp -> date, time
	 * Called from DBItem to update sub fields values after loading item
	 *
	 * @param string $field
	 * @param string $value
	 * @param Array $options
	 * @param kDBItem $object
	 * @return void
	 * @access public
	 */
	public function UpdateSubFields($field, $value, &$options, &$object)
	{
		if ( !isset($options['master_field']) ) {
			$regional =& $this->Application->recallObject('lang.current');
			/* @var $regional LanguagesItem */

			if ( $regional->GetDBField('UnitSystem') == 2 ) {
				// US/UK
				if ( $value === null ) {
					$major = null;
					$minor = null;
				}
				else {
					list($major, $minor) = kUtil::Kg2Pounds($value);
//					$major = floor( $value / 0.5 );
//					$minor = ($value - $major * 0.5) * 32;
				}

				$object->SetDBField($field . '_a', $major);
				$object->SetDBField($field . '_b', $minor);
			}
		}
	}
}