<?php
/**
* @version	$Id: stylesheets_event_handler.php 14628 2011-10-04 09:36:30Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class StylesheetsEventHandler extends kDBEventHandler {

	/**
	 * [HOOK] Compile stylesheet file based on theme definitions
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnCompileStylesheet(&$event)
	{
		$object =& $event->getObject( Array ('skip_autoload' => true) );
		/* @var $object StylesheetsItem */

		$object->SwitchToLive();

		$ids = explode(',', $event->MasterEvent->getEventParam('ids'));

		if ( !$ids ) {
			return ;
		}

		foreach ($ids as $id) {
			$object->Load($id);
			$object->Compile();
		}
	}
}