<?php
/**
* @version	$Id$
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class PromoBlockGroupEventHandler extends kDBEventHandler {

	/**
	 * Occurs before creating item
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnBeforeItemCreate(kEvent &$event)
	{
		parent::OnBeforeItemCreate($event);
		$this->beforeItemChange($event);
	}

	/**
	 * Occurs before updating item
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnBeforeItemUpdate(kEvent &$event)
	{
		parent::OnBeforeItemUpdate($event);
		$this->beforeItemChange($event);
	}

	/**
	 * Occurs before updating item
	 *
	 * @param kEvent $event
	 * @return void
	 * @access private
	 */
	private function beforeItemChange(&$event)
	{
		$object =& $event->getObject();
		/* @var $object kDBItem */

		$object->setRequired('TransitionEffectCustom', $object->GetDBField('TransitionEffect') == '-1');
	}

	/**
	 * Occurs before deleting item, id of item being
	 * deleted is stored as 'id' event param
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnBeforeItemDelete(kEvent &$event)
	{
		parent::OnBeforeItemDelete($event);

		$object =& $event->getObject();
		/* @var $object kDBItem */

		$sql = 'SELECT BlockId
				FROM ' . TABLE_PREFIX . 'PromoBlocks
				WHERE PromoBlockGroupId = ' . $object->GetID();
		$block_id = $this->Conn->GetOne($sql);

		if ( $block_id ) {
			$event->MasterEvent->SetRedirectParam('grid_error', 'la_error_PromoGroupNotEmpty');
			$event->status = kEvent::erFAIL;
		}
	}

	/**
	 * Deleting empty promo block group disconnects it from associated sections
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnAfterItemDelete(kEvent &$event)
	{
		parent::OnAfterItemDelete($event);

		$sql = 'UPDATE ' . TABLE_PREFIX . 'Categories
				SET PromoBlockGroupId = 0
				WHERE PromoBlockGroupId = ' . $event->getEventParam('id');
		$this->Conn->Query($sql);
	}

	/**
	 * Set tree update flag
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnSave(kEvent &$event)
	{
		parent::OnSave($event);

		if ( $event->status == kEvent::erSUCCESS ) {
			$event->SetRedirectParam('refresh_tree', 1);
		}
	}

	/**
	 * Set tree update flag
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnMassDelete(kEvent &$event)
	{
		parent::OnMassDelete($event);

		if ( $event->status == kEvent::erSUCCESS ) {
			$event->SetRedirectParam('refresh_tree', 1);
		}
	}
}
