<?php
/**
* @version	$Id: phrase_tp.php 14748 2011-11-09 09:35:48Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class PhraseTagProcessor extends kDBTagProcessor {

	/**
	 * Determines, that we can close phrase editing form without parent window refreshing
	 *
	 * @param Array $params
	 * @return bool
	 */
	function UseQuickFormCancel($params)
	{
		return $this->Application->GetVar('simple_mode') && (int)$this->Application->ConfigValue('UsePopups');
	}

	function PhraseCount($params)
	{
		static $cache = null;

		if (!isset($cache)) {
			$sql = 'SELECT COUNT(*), Module
					FROM ' . $this->Application->getUnitOption($this->Prefix, 'TableName') . '
					GROUP BY Module';
			$cache = $this->Conn->GetCol($sql, 'Module');
		}

		$module = $params['module'];

		return array_key_exists($module, $cache) ? $cache[$module] : 0;
	}

	function EventCount($params)
	{
		static $cache = null;

		if (!isset($cache)) {
			$sql = 'SELECT COUNT(*), IF(Module LIKE "Core:%", "Core", Module) AS Module
					FROM ' . $this->Application->getUnitOption('emailevents', 'TableName') . '
					GROUP BY Module';
			$cache = $this->Conn->GetCol($sql, 'Module');
		}

		$module = $params['module'];

		return array_key_exists($module, $cache) ? $cache[$module] : 0;
	}
}