<?php
/**
* @version	$Id: upgrade_helper.php 14870 2011-12-16 11:54:01Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2010 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/
	defined('FULL_PATH') or die('restricted access!');

	class kUpgradeHelper extends kHelper {

		/**
		 * Install toolkit instance
		 *
		 * @var kInstallToolkit
		 */
		var $_toolkit = null;

		/**
		 * List of dependencies for EACH current module version related to other modules
		 *
		 * @var Array
		 */
		var $dependencies = Array ();

		/**
		 * Sets common instance of installator toolkit
		 *
		 * @param kInstallToolkit $instance
		 */
		function setToolkit(&$instance)
		{
			$this->_toolkit =& $instance;
		}

		/**
		 * Replaces deprecated detail template design with new one
		 *
		 * @param string $prefix
		 * @param string $from_template
		 * @param string $to_template
		 */
		function _updateDetailTemplate($prefix, $from_template, $to_template)
		{
			$sql = 'SELECT CustomFieldId
					FROM ' . TABLE_PREFIX . 'CustomField
					WHERE FieldName = "' . $prefix . '_ItemTemplate"';
			$custom_field_id = $this->Conn->GetOne($sql);

			$ml_formatter =& $this->Application->recallObject('kMultiLanguage');
			/* @var $ml_formatter kMultiLanguage */

			$field = $ml_formatter->LangFieldName('cust_' . $custom_field_id, true);

			$sql = 'UPDATE ' . TABLE_PREFIX . 'CategoryCustomData
					SET ' . $field . ' = "' . $to_template . '"
					WHERE ' . $field . ' = "' . $from_template . '"';
			$this->Conn->Query($sql);
		}
	}
