<?php
/**
* @version	$Id: translator_event_handler.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class TranslatorEventHandler extends kDBEventHandler
	{
		/**
		 * Allows to override standart permission mapping
		 *
		 */
		function mapPermissions()
		{
			parent::mapPermissions();
			$permissions = Array(
									'OnChangeLanguage'	=>	Array('subitem' => 'add|edit'),
									'OnSaveAndClose'	=>	Array('subitem' => 'add|edit'),
							);
			$this->permMapping = array_merge($this->permMapping, $permissions);
		}

		/**
		 * Check permission of item, that being translated
		 *
		 * @param kEvent $event
		 */
		function CheckPermission(&$event)
		{
			list($prefix, $field) = $this->getPrefixAndField($event);

			$top_prefix = $this->Application->GetTopmostPrefix($prefix, true);
			$event->setEventParam('top_prefix', $top_prefix);
			return parent::CheckPermission($event);
		}


		/**
		 * Returns prefix and field being translated
		 *
		 * @param kEvent $event
		 */
		function getPrefixAndField(&$event)
		{
			$field = $this->Application->GetVar($event->getPrefixSpecial(true).'_field');

			if (strpos($field,':') !== false) {
				list($prefix, $field) = explode(':', $field);
			}
			else {
				$prefix = $this->Application->GetVar($event->getPrefixSpecial(true).'_prefix');
			}
			return Array($prefix, $field);
		}

		function OnLoad(&$event)
		{
			list($obj_prefix, $field) = $this->getPrefixAndField($event);

			$object =& $this->Application->recallObject($obj_prefix);
			$translator =& $this->Application->recallObject($event->getPrefixSpecial());

			$def_lang = $this->Application->GetDefaultLanguageId();

			$current_lang = $translator->GetDBField('Language');
			if (!$current_lang) $current_lang = $this->Application->RecallVar('trans_lang');
			if (!$current_lang) $current_lang = $this->Application->GetVar('m_lang');
			/*if ($current_lang == $def_lang) {
				$current_lang = $def_lang + 1;
			}*/
			$this->Application->StoreVar('trans_lang', $current_lang); //remember translation language for user friendlyness

			$translator->SetID(1);
			$translator->SetDBField('Original', $object->GetDBField('l'.$this->Application->GetVar('m_lang').'_'.$field));
			$translator->SetDBField('Language', $current_lang);
			$translator->SetDBField('SwitchLanguage', $current_lang);

			$translator->SetDBField('Translation', $object->GetDBField('l'.$current_lang.'_'.$field));

			$cur_lang =& $this->Application->recallObject('lang.current');
			$cur_lang->Load($current_lang);

			$translator->SetDBField('Charset', $cur_lang->GetDBField('Charset'));

			$event->redirect = false;
		}

		function OnSaveAndClose(&$event)
		{
			$event->CallSubEvent('OnPreSave');
			$this->finalizePopup($event);
		}

		function OnPreSave(&$event)
		{
			$translator =& $this->Application->recallObject($event->getPrefixSpecial());

			$items_info = $this->Application->GetVar( $event->getPrefixSpecial(true) );
			if($items_info) $field_values = array_shift($items_info);

			$translator->SetFieldsFromHash($field_values);

			list($obj_prefix, $field) = $this->getPrefixAndField($event);

			$object =& $this->Application->recallObject($obj_prefix);

			$lang = $translator->GetDBField('Language');
			$object->Fields['l'.$lang.'_'.$field] = Array();
			$object->SetDBField('l'.$lang.'_'.$field, $translator->GetDBField('Translation'));
			$this->RemoveRequiredFields($object);
			$object->Update();
		}

		function OnChangeLanguage(&$event)
		{
			$event->CallSubEvent('OnPreSave');
			$translator =& $this->Application->recallObject($event->getPrefixSpecial());
			$translator->SetDBField('Language', $translator->GetDBField('SwitchLanguage'));
			$event->CallSubEvent('OnLoad');
			$event->redirect = false;
		}

	}