<?php

	class ListHelper extends kHelper {

		/**
		 * Detects, that current sorting of the list is not default
		 *
		 * @param kDBList $list
		 * @return bool
		 */
		function hasUserSorting(&$list)
		{
			static $cache = Array ();

			if (array_key_exists($list->getPrefixSpecial(), $cache)) {
				return $cache[ $list->getPrefixSpecial() ];
			}

			$user_sorting_start = $this->getUserSortIndex($list);

			$sorting_configs = $this->Application->getUnitOption($list->Prefix, 'ConfigMapping', Array ());
			$list_sortings = $this->Application->getUnitOption($list->Prefix, 'ListSortings', Array ());
			$sorting_prefix = getArrayValue($list_sortings, $list->Special) ? $list->Special : '';

			if (array_key_exists('DefaultSorting1Field', $sorting_configs)) {
				$list_sortings[$sorting_prefix]['Sorting'] = Array (
					$this->Application->ConfigValue($sorting_configs['DefaultSorting1Field']) => $this->Application->ConfigValue($sorting_configs['DefaultSorting1Dir']),
					$this->Application->ConfigValue($sorting_configs['DefaultSorting2Field']) => $this->Application->ConfigValue($sorting_configs['DefaultSorting2Dir']),
				);
			}

			$sorting = getArrayValue($list_sortings, $sorting_prefix, 'Sorting');
			$sort_fields = is_array($sorting) ? array_keys($sorting) : Array ();

			for ($order_number = 0; $order_number < 2; $order_number++) {
				// currect sorting in list
				$sorting_pos = $user_sorting_start + $order_number;
				$current_order_field = $list->GetOrderField($sorting_pos, true);
				$current_order_direction = $list->GetOrderDirection($sorting_pos, true);

				if (!$current_order_field || !$current_order_direction) {
					// no sorting defined for this sorting position
					continue;
				}

				// remove language prefix from field
				$field_options = $list->GetFieldOptions($current_order_field);
				if (array_key_exists('formatter', $field_options) && $field_options['formatter'] == 'kMultiLanguage') {
					// remove language prefix
					$current_order_field = preg_replace('/^l[\d]+_(.*)/', '\\1', $current_order_field);
				}

				// user sorting found
				if (array_key_exists($order_number, $sort_fields)) {
					// default sorting found
					$default_order_field = $sort_fields[$order_number];
					$default_order_direction = $sorting[$default_order_field]; // because people can write

					if ($current_order_field != $default_order_field || strcasecmp($current_order_direction, $default_order_direction) != 0) {
						// #1. user sorting differs from default sorting -> changed
						$cache[ $list->getPrefixSpecial() ] = true;
						return true;
					}
				}
				else {
					// #2. user sorting + no default sorting -> changed
					$cache[ $list->getPrefixSpecial() ] = true;
					return true;
				}
			}

			// #3. user sorting match default or not defined -> not changed
			$cache[ $list->getPrefixSpecial() ] = false;
			return false;
		}

		/**
		 * Returns default per-page value for given prefix
		 *
		 * @param string $prefix
		 * @param int $default
		 * @return int
		 */
		function getDefaultPerPage($prefix, $default = 10)
		{
			$ret = false;
			$config_mapping = $this->Application->getUnitOption($prefix, 'ConfigMapping');

			if ($config_mapping) {
				if (!array_key_exists('PerPage', $config_mapping)) {
					trigger_error('Incorrect mapping of <span class="debug_error">PerPage</span> key in config for prefix <strong>' . $event->Prefix . '</strong>', E_USER_WARNING);
				}

				$per_page = $this->Application->ConfigValue($config_mapping['PerPage']);

				if ($per_page) {
					return $per_page;
				}
			}

			// none of checked above per-page locations are useful, then try default value
			return $default;
		}

		/**
		 * Returns index where 1st changable sorting field begins
		 *
		 * @param kDBList $list
		 * @return int
		 * @todo 	This is copy of kDBTagProcessor::getUserSortIndex method.
		 * 			Can't call helper there, because it will slow down grid output
		 * 			when we have a lot of columns
		 */
		function getUserSortIndex(&$list)
		{
			$list_sortings = $this->Application->getUnitOption($list->Prefix, 'ListSortings', Array ());
			$sorting_prefix = getArrayValue($list_sortings, $list->Special) ? $list->Special : '';

			$user_sorting_start = 0;
			if ( $forced_sorting = getArrayValue($list_sortings, $sorting_prefix, 'ForcedSorting') ) {
				$user_sorting_start = count($forced_sorting);
			}
			return $user_sorting_start;
		}
	}