<?php
/**
* @version	$Id: pdf_renderer_tcpdf.php 14241 2011-03-16 20:24:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class kTCPDFRenderer extends kPDFRenderer {

	/**
	 * Enter description here...
	 *
	 * @var TCPDF
	 */
	public $PDF = null;

	/**
	 * Enter description here...
	 *
	 * @var Zend_Pdf_Page
	 */
	public $CurPage = null;

	public $CurFont = null;
	public $CurFontSize = null;

	function __construct()
	{
		$this->IncludeTCPDF();

		$this->PDF = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true);
		$this->PDF->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$this->PDF->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
		$this->PDF->setPrintHeader(false);
		$this->PDF->setPrintFooter(false);
		$this->PDF->AddPage();

//		$this->PDF->SetX(50);
//		$this->PDF->SetY(200);
//		$this->PDF->wr
	}

	function IncludeTCPDF()
	{
		static $included = false;
		if (!$included) {
			define('K_TCPDF_EXTERNAL_CONFIG', true);
			define('K_PATH_MAIN', FULL_PATH.'/tcpdf/');
			define('K_PATH_URL', PROTOCOL.SERVER_NAME.(defined('PORT')?':'.PORT : '').rtrim(BASE_PATH, '/').'/tcpdf/');
			define ("K_PATH_FONTS", K_PATH_MAIN."fonts/");
			define ("K_PATH_CACHE", K_PATH_MAIN."cache/");
			define ("K_PATH_URL_CACHE", K_PATH_URL."cache/");
			define ("K_PATH_IMAGES", K_PATH_MAIN."images/");
			define ("K_BLANK_IMAGE", K_PATH_IMAGES."_blank.png");
			define ("PDF_PAGE_FORMAT", "A4");
			define ("PDF_PAGE_ORIENTATION", "P");
			define ("PDF_CREATOR", "TCPDF");
			define ("PDF_AUTHOR", "TCPDF");
			define ("PDF_HEADER_TITLE", "0");
			define ("PDF_HEADER_STRING", "0");
			define ("PDF_HEADER_LOGO", "logo_example.png");
			define ("PDF_HEADER_LOGO_WIDTH", 0);
			define ("PDF_UNIT", "pt");
			define ("PDF_MARGIN_HEADER", 0);
			define ("PDF_MARGIN_FOOTER", 0);
			define ("PDF_MARGIN_TOP", 0);
			define ("PDF_MARGIN_BOTTOM", 0);
			define ("PDF_MARGIN_LEFT", 0);
			define ("PDF_MARGIN_RIGHT", 0);
			define ("PDF_FONT_NAME_MAIN", "vera"); //vera
			define ("PDF_FONT_SIZE_MAIN", 10);
			define ("PDF_FONT_NAME_DATA", "vera"); //verase
			define ("PDF_FONT_SIZE_DATA", 8);
			define ("PDF_IMAGE_SCALE_RATIO", 4);
			define("HEAD_MAGNIFICATION", 1.1);
			define("K_CELL_HEIGHT_RATIO", 1.25);
			define("K_TITLE_MAGNIFICATION", 1.3);
			define("K_SMALL_RATIO", 2/3);
			require_once(FULL_PATH.'/tcpdf/config/lang/eng.php');
			require_once(FULL_PATH.'/tcpdf/tcpdf.php');
			$included = true;
		}
	}

	function NextPage()
	{
		$this->PDF->AddPage();
	}

	function GetWidth()
	{
		return $this->PDF->getPageWidth();
	}

	function GetHeight()
	{
		return $this->PDF->getPageHeight();
	}

	function SetFont($family, $size, $weight=400, $style='normal', $variant='normal')
	{
		$this->CurFontSize = $size;

		$family = strtolower($family);
		switch ($family) {
			case 'serif':
				$font = 'FreeSerif';
				break;
			case 'cursive':
				$font = 'FreeSerif';
				break;
			case 'fantasy':
				$font = 'FreeSans';
				break;
			case 'monospace':
				$font = 'FreeMono';
				break;
			case 'sans-serif':
			default:
				$font = 'FreeSans';
				break;
		}

		$bold = $weight >= 700 ? 'B' : '';
		$italic = preg_match('/italic|oblique/i', $style) ? 'I' : '';

		return $this->PDF->SetFont($font, $bold.$italic, $size);
	}

	function SetFontSize($size)
	{
		$this->CurFontSize = $size;
		$this->PDF->SetFontSize($size);
	}

	function ProcessHTMLColor($color) {
		$mapping = array(
			'maroon' => '#800000',
			'red' => '#ff0000',
			'orange' => '#ffA500',
			'yellow' => '#ffff00',
			'olive' => '#808000',
			'purple' => '#800080',
			'fuchsia' => '#ff00ff',
			'white' => '#ffffff',
			'lime' => '#00ff00',
			'green' => '#008000',
			'navy' => '#000080',
			'blue' => '#0000ff',
			'aqua' => '#00ffff',
			'teal' => '#008080',
			'black' => '#000000',
			'silver' => '#c0c0c0',
			'gray' => '#808080',
		);
		foreach ($mapping as $named_color => $value) {
			$color = str_ireplace($named_color, $value, $color);
		}
		if ( preg_match('/^#([0-9a-f]{3})$/i', $color, $regs) ) {
			$color = $color.$regs[1];
		}
		if ( preg_match('/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i', $color, $regs) )
		{
			return array(hexdec($regs[1]), hexdec($regs[2]), hexdec($regs[3]));
		}
		return array(255,255,0);

	}

	function SetFillColor($color)
	{
		list($r,$g,$b) = $this->ProcessHTMLColor($color);
		$this->PDF->SetFillColor($r,$g,$b);
		$this->PDF->SetTextColor($r,$g,$b);
	}

	function SetLineColor($color)
	{
		list($r,$g,$b) = $this->ProcessHTMLColor($color);
		return $this->PDF->SetDrawColor($r,$g,$b);
	}

	function SetLineWidth($width)
	{
		return $this->PDF->setLineWidth($width);
	}

	function DrawLine($x1, $y1, $x2, $y2)
	{
		return $this->PDF->Line($x1, $y1, $x2, $y2);
	}

	function DrawRectangle($x1, $y1, $x2, $y2, $mode='D')
	{
		switch ($mode) {
			case kPDFRenderer::SHAPE_DRAW_FILL:
				$mode = 'F';
				break;
			case kPDFRenderer::SHAPE_DRAW_STROKE :
				$mode = 'D';
				break;
			case kPDFRenderer::SHAPE_DRAW_FILL_AND_STROKE :
				$mode = 'DF';
				break;

		}
		$w = $x2-$x1;
		$h = $y2-$y1;
		return $this->PDF->Rect($x1, $y1, $w, $h, $mode);
	}

	function DrawText($text, $x, $y)
	{
		return $this->PDF->text($x, $y, $text);
	}

	function DrawImage($filepath, $x, $y, $w=0, $h=0)
	{
		$info = pathinfo($filepath);
		if (preg_match('/jpg|jpeg|png/i', $info['extension'])) {
			return $this->PDF->Image($filepath, $x, $y, $w, $h);
		}
		if (preg_match('/gif/i', $info['extension'])) {
			$tmp_path = WRITEABLE.'/tmp';
			if (!file_exists($tmp_path)) {
				mkdir($tmp_path);
			}
			$converted_filepath = $tmp_path.'/'.$info['filename'].'.png';
			if (!file_exists($converted_filepath) || filemtime($converted_filepath) < filemtime($filepath)) {
				$im = @imagecreatefromgif ($filepath);
				imagepng($im, $converted_filepath);
			}

			return $this->PDF->Image($converted_filepath, $x, $y, $w, $h);
		}
	}

	function GetPDFString()
	{
		return $this->PDF->Output('', 'S');
	}

	function GetAscent()
	{
		//$this->CurrentFont['desc']
		$font = $this->PDF->GetFont();
		return ($font['desc']['Ascent'] / 1000) * $this->CurFontSize;
	}

	function GetDescent()
	{
		$font = $this->PDF->GetFont();
		return ($font['desc']['Descent'] / 1000) * $this->CurFontSize;
	}

	function GetLineGap()
	{
		return 0;
		$font = $this->PDF->GetFont();
		return (($font['Ascent'] - $font['Descent'])*0 / 1000) * $this->CurFontSize;
	}

	function GetStringWidth($string)
	{
		return $this->PDF->GetStringWidth($string);
	}
}