<?php
/**
* @version	$Id: visits_config.php 14198 2011-02-15 16:53:56Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array (
					'Prefix'			=>	'visits',
					'ItemClass'			=>	Array ('class' => 'kDBItem','file' => '','build_event' => 'OnItemBuild'),
					'ListClass'			=>	Array ('class' => 'VisitsList','file' => 'visits_list.php','build_event' => 'OnListBuild'),
					'EventHandlerClass'	=>	Array ('class' => 'VisitsEventHandler','file' => 'visits_event_handler.php','build_event' => 'OnBuild'),
					'TagProcessorClass' =>	Array ('class' => 'VisitsTagProcessor','file' => 'visits_tag_processor.php','build_event' => 'OnBuild'),
					'AutoLoad'			=>	true,

					'QueryString'		=>	Array (
												1 => 'id',
												2 => 'Page',
												3 => 'PerPage',
												4 => 'event',
												5 => 'mode',
											),

					'Hooks'				=>	Array (
													Array (
														'Mode' => hBEFORE,
														'Conditional' => false,
														'HookToPrefix' => 'adm',
														'HookToSpecial' => '',
														'HookToEvent' => Array ( 'OnStartup' ),
														'DoPrefix' => '',
														'DoSpecial' => '',
														'DoEvent' => 'OnRegisterVisit',
													),

													Array (
														'Mode' => hAFTER,
														'Conditional' => false,
														'HookToPrefix' => 'u',
														'HookToSpecial' => '*',
														'HookToEvent' => Array ( 'OnAfterLogin' ),
														'DoPrefix' => '',
														'DoSpecial' => '',
														'DoEvent' => 'OnUserLogin',
													),
											),

					'IDField' 			=>	'VisitId',
					'TableName'			=>	TABLE_PREFIX.'Visits',

					'PermSection'		=>	Array ('main' => 'in-portal:visits'),

					'Sections' => Array (
						'in-portal:visits' => Array (
							'parent'		=>	'in-portal:reports',
							'icon'			=>	'visits',
							'label'			=>	'la_tab_VisitorLog',
							'url'			=>	Array ('t' => 'logs/visits/visits_list', 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'delete'),
							'priority'		=>	6,
							'type'			=>	stTREE,
						),
					),

					'TitlePresets'		=>	Array (
										'visits_list' => Array (
											'prefixes' => Array ('visits_List'), 'format' => "!la_title_Visits!",
											'toolbar_buttons' => Array ('search', 'search_reset', 'refresh', 'delete', 'export', 'view'),
											),

										'visits.incommerce_list' =>	Array (
											'prefixes' => Array ('visits.incommerce_List'), 'format' => "!la_title_Visits!",
											'toolbar_buttons' => Array ('search', 'search_reset', 'refresh', 'delete', 'export', 'view'),
											),
										),

					'CalculatedFields' => Array (
								'' => Array (
										'UserName'	=>	'IF( ISNULL(u.Login), IF (%1$s.PortalUserId = ' . USER_ROOT . ', \'root\', IF (%1$s.PortalUserId = ' . USER_GUEST . ', \'Guest\', \'n/a\')), u.Login)',
									),
								'incommerce' => Array (
										'UserName'	=>	'IF( ISNULL(u.Login), IF (%1$s.PortalUserId = ' . USER_ROOT . ', \'root\', IF (%1$s.PortalUserId = ' . USER_GUEST . ', \'Guest\', \'n/a\')), u.Login)',
										'AffiliateUser'				=>	'IF( LENGTH(au.Login),au.Login,\'!la_None!\')',
										'AffiliatePortalUserId'		=>	'af.PortalUserId',
										'OrderTotalAmount'			=>	'IF(ord.Status = 4, ord.SubTotal+ord.ShippingCost+ord.VAT, 0)',
										'OrderAffiliateCommission'	=>	'IF(ord.Status = 4, ord.AffiliateCommission, 0)',
										'OrderNumber'				=>	'CONCAT(LPAD(Number,6,"0"),\'-\',LPAD(SubNumber,3,"0") )',
										'OrderId'					=>	'ord.OrderId',
									),
								),

					'ListSQLs'			=>	Array (	'' => '	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON %1$s.PortalUserId = u.PortalUserId',
													'incommerce' => '
															SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON %1$s.PortalUserId = u.PortalUserId
															LEFT JOIN '.TABLE_PREFIX.'Affiliates af ON %1$s.AffiliateId = af.AffiliateId
															LEFT JOIN '.TABLE_PREFIX.'PortalUser au ON af.PortalUserId = au.PortalUserId
															LEFT JOIN '.TABLE_PREFIX.'Orders ord ON %1$s.VisitId = ord.VisitId',
														),


					'ItemSQLs'			=>	Array (	'' => '	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON %1$s.PortalUserId = u.PortalUserId',
													'incommerce' => '	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON %1$s.PortalUserId = u.PortalUserId
															LEFT JOIN '.TABLE_PREFIX.'Affiliates af ON %1$s.AffiliateId = af.AffiliateId
															LEFT JOIN '.TABLE_PREFIX.'PortalUser au ON af.PortalUserId = au.PortalUserId
															LEFT JOIN '.TABLE_PREFIX.'Orders ord ON %1$s.VisitId = ord.VisitId',
														),

					'ListSortings'	=> 	Array (
																'' => Array (
																	'Sorting' => Array ('VisitDate' => 'desc'),
																)
															),

					'Fields' => Array (
										'VisitId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
										'VisitDate' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'custom_filter' => 'date_range', 'default' => NULL),
										'Referer' => Array ('type' => 'string','not_null' => '1','default' => ''),
            							'IPAddress' => Array ('type' => 'string','not_null' => '1','default' => ''),
										'AffiliateId' => Array ('type' => 'int','formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'options' => Array (0 => 'lu_None'), 'left_sql' => 'SELECT %s FROM '.TABLE_PREFIX.'Affiliates af LEFT JOIN '.TABLE_PREFIX.'PortalUser pu ON pu.PortalUserId = af.PortalUserId WHERE `%s` = \'%s\'','left_key_field' => 'AffiliateId','left_title_field' => 'Login','not_null'=>1,'default'=>0),
										'PortalUserId' => Array ('type' => 'int','not_null' => '1','default' => USER_GUEST),
							    ),

					'VirtualFields'	=> 	Array (
												'UserName'						=>	Array ('type' => 'string', 'default' => ''),
												'AffiliateUser'					=>	Array ('type' => 'string', 'default' => ''),
												'AffiliatePortalUserId'			=>	Array ('type' => 'int', 'default' => null),
												'OrderTotalAmount'				=>	Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'default' => '0.00', 'totals' => 'SUM'),
												'OrderTotalAmountSum'			=>	Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'default' => '0.00'),
												'OrderAffiliateCommission' 		=>	Array ('type' => 'double', 'formatter' => 'kFormatter','format' => '%.02f', 'default' => '0.0000', 'totals' => 'SUM'),
												'OrderAffiliateCommissionSum' 	=>	Array ('type' => 'double', 'formatter' => 'kFormatter','format' => '%.02f', 'default' => '0.0000'),
												'OrderNumber'					=>	Array ('type' => 'string', 'default' => ''),
												'OrderId'						=>	Array ('type' => 'int', 'default' => '0'),
											),

					'Grids'	=> Array (

						'Default' => Array (
							'Icons' => Array ('default' => 'icon16_item.png'),
							'Fields' => Array (
								'VisitDate' => Array ( 'title' => 'la_col_VisitDate', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_date_range_filter', 'width' => 145, ),
								'IPAddress' => Array ( 'title' => 'la_col_IP', 'filter_block' => 'grid_like_filter', 'width' => 130, ),
								'Referer' => Array ( 'title' => 'la_col_Referer', 'data_block' => 'grid_referer_td', 'filter_block' => 'grid_like_filter', 'width' => 250, ),
								'UserName' => Array ('title' => 'la_col_Username', 'data_block' => 'grid_userlink_td', 'user_field' => 'PortalUserId', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
							),
						),

						'visitsincommerce' => Array (
							'Icons' => Array ('default' => 'icon16_item.png'),
							'Fields' => Array (
								'VisitDate' => Array ( 'title' => 'la_col_VisitDate', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_date_range_filter', 'width' => 145, ),
								'IPAddress' => Array ( 'title' => 'la_col_IP', 'filter_block' => 'grid_like_filter', 'width' => 130, ),
								'Referer' => Array ( 'title' => 'la_col_Referer', 'data_block' => 'grid_referer_td', 'filter_block' => 'grid_like_filter', 'width' => 250, ),
								'UserName' => Array ( 'title' => 'la_col_Username', 'data_block' => 'grid_userlink_td', 'user_field' => 'PortalUserId', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
								'AffiliateUser'	=> Array ( 'title' => 'la_col_AffiliateUser', 'data_block' => 'grid_userlink_td', 'user_field' => 'AffiliatePortalUserId', 'filter_block' => 'grid_like_filter', 'width' => 105, ),
								'OrderTotalAmountSum' => Array ( 'title' => 'la_col_OrderTotal', 'filter_block' => 'grid_range_filter', 'width' => 95, ),
								'OrderAffiliateCommissionSum' => Array ( 'title' => 'la_col_Commission', 'filter_block' => 'grid_range_filter', 'width' => 160, ),
							),
						),
					),

	);