<?php

	class FormSubmissionTagProcessor extends kDBTagProcessor {

		/**
		 * Returns phrase translation by name
		 *
		 * @param Array $params
		 * @return string
		 * @access public
		 */
		function PhraseFromRequest($params)
		{
			$phrase_name = $this->Application->GetVar($params['name']);

			if (array_key_exists('default', $params) && !$phrase_name) {
				$phrase_name = $params['default'];
			}

			return $this->Application->Phrase($phrase_name);
		}

		/**
		 * Allows to retrieve for submission field by it's name or role in email communications
		 *
		 * @param Array $params
		 * @return string
		 */
		function FormField($params)
		{
			$object =& $this->getObject($params);
			/* @var $object kDBItem */

			$form_submission_helper =& $this->Application->recallObject('FormSubmissionHelper');
			/* @var $form_submission_helper FormSubmissionHelper */

			$formatted = !(array_key_exists('db', $params) && $params['db']);
			$format = $formatted ? (array_key_exists('format', $params) ? $params['format'] : null) : null;

			if (array_key_exists('role', $params)) {
				return $form_submission_helper->getFieldByRole($object, $params['role'], $formatted, $format);
			}

			return $form_submission_helper->getFieldByName($params['name'], $formatted, $format);
		}
	}
