<?php
/**
* @version	$Id: selectors_item.php 13086 2010-01-12 19:47:40Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	define('STYLE_INLINE',	' ');
	define('STYLE_FILE',	"\n");
	define('STYLE_PREVIEW', '<br>');

	class SelectorsItem extends kDBItem	{

		/**
		 * Returns compiled selector for inserting into css file
		 *
		 * @return string
		 */
		function CompileStyle($separator = STYLE_FILE)
		{
			$ret = $this->GetDBField('SelectorName')." {\n";
			$ret .= $this->CompileStyleBody($separator);
			$ret .= $separator."}\n";
			return $ret;
		}

		function CompileStyleBody($separator)
		{
			$ret = '';
			$selector_data = $this->GetDBField('SelectorData');
			if($selector_data)
			{
				foreach($selector_data as $property_name => $property_value)
				{
					if ($property_value == '') continue;
					$ret .= "\t$property_name: $property_value;".$separator;
				}
			}

			$advanced_css = $this->GetDBField('AdvancedCSS');
			if($separator != "\n") $advanced_css = str_replace("\n",$separator,$advanced_css);
			$ret .= $advanced_css;

			return $ret;
		}

		/**
		 * Resets all block style attributes to it's base style
		 *
		 */
		function ResetStyle()
		{
			if( $this->GetDBField('ParentId') )
			{
				$this->SetDBField( 'SelectorData', Array() );
				$this->Update();
			}
		}

	}