<?php
/**
* @version	$Id: draft_eh.php 13400 2010-04-25 12:37:19Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class DraftEventHandler extends kDBEventHandler
	{

		/**
		 * Sets user, who created draft
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemCreate(&$event)
		{
			parent::OnBeforeItemCreate($event);

			$object =& $event->getObject();
			/* @var $object kDBItem */

			$user_id = $this->Application->RecallVar('user_id');

			$object->SetDBField('CreatedById', $user_id);
		}

		/**
		 * Allows to load draft, that best matches given form submission
		 *
		 * @param kEvent $event
		 * @return int
		 */
		function getPassedID(&$event)
		{
			if ($event->Special == 'related') {
				$form_submission =& $this->Application->recallObject('formsubs');
				/* @var $form_submission kDBItem */

				return Array (
					'FormSubmissionId' => $form_submission->GetID(),
					'CreatedById' => $this->Application->RecallVar('user_id'),
				);
			}

			return parent::getPassedID($event);
		}
	}