<?php
/**
* @version	$Id: config_search_config.php 13545 2010-05-11 19:19:58Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'confs',

		'Clones' => Array (
			'confs-cf' => Array (
				'Prefix' => 'confs-cf',
				'ParentPrefix' => 'cf',
				'ParentTableKey' =>	'CustomFieldId',	// linked field in master table
				'ForeignKey' =>	'CustomFieldId',	// linked field in subtable
				'AutoClone'	=> false,				// because OnCreateCustomField hook does the stuff
				'AutoDelete' =>	true,

				'Hooks'	=>	Array (
					Array (
						'Mode' => hAFTER,
						'Conditional' => false,
						'HookToPrefix' => '#PARENT#',
						'HookToSpecial' => '*',
						'HookToEvent' => Array ('OnAfterItemCreate', 'OnAfterItemUpdate'),
						'DoPrefix' => '',
						'DoSpecial' => '*',
						'DoEvent' => 'OnCreateCustomField',
					),
				),
			),
		),

		'ItemClass'	=> Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass'	=> Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass'	=> Array ('class' => 'ConfigSearchEventHandler', 'file' => 'config_search_event_handler.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'ConfigSearchTagProcessor', 'file' => 'config_search_tag_processor.php', 'build_event' => 'OnBuild'),
		'AutoLoad' => true,
		'hooks' => Array (),
		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
		),

		'IDField' => 'SearchConfigId',

		'TitleField' => 'FieldName',

		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array ('confs' => '!la_title_Adding_ConfigSearch!'),
				'edit_status_labels' => Array ('confs' => '!la_title_Editing_ConfigSearch!'),
				'new_titlefield' => Array ('confs' => '!la_title_New_ConfigSearch!'),
			),
			'configsearch_edit' => Array ('prefixes' => Array ('confs'), 'format' => "#confs_status# '#confs_titlefield#' - !la_title_General!"),
			'config_list_search' => Array ('prefixes' => Array ('confs_List'), 'tag_params' => Array ('confs' => Array ('per_page' => -1) ), 'format' => "!la_updating_config!"),
		),

		'TableName' => TABLE_PREFIX.'SearchConfig',

		'CalculatedFields' => Array (
			''	=>	Array (
				'IsCustom'	=>	'IF(CustomFieldId IS NULL, 0, 1)',
			),
		),

		'ListSQLs' => Array ('' => 'SELECT %1$s.* %2$s FROM %1$s'),

		'ItemSQLs' => Array ('' => 'SELECT %1$s.* %2$s FROM %1$s'),

		'Fields' => Array (
            'TableName' => Array ('type' => 'string', 'not_null' => '1', 'required' => 1, 'default' => ''),
            'FieldName' => Array ('type' => 'string', 'not_null' => '1', 'required' => 1, 'default' => ''),
            'SimpleSearch' => Array (
            	'type' => 'int',
				'formatter' => 'kOptionsFormatter',
				'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
				'default' => 1, 'not_null' => 1,
			),
            'AdvancedSearch' =>	Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter',
				'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
				'default' => 1, 'not_null' => 1,
            ),
            'Description' => Array ('type' => 'string', 'default' => null),
            'DisplayName' => Array ('type' => 'string', 'required' => 1, 'default' => null),
            'ModuleName' =>	Array (
            	'type' => 'string',
            	'formatter' => 'kOptionsFormatter',
            	'options' => Array (
            		'' => '',
				),
				'options_sql' => 'SELECT %s 
									FROM '.TABLE_PREFIX.'Modules 
									WHERE Loaded = 1 ORDER BY LoadOrder',
				'option_key_field' => 'Name', 'option_title_field' => 'Name',
				'not_null' => '1', 'default' => 'In-Portal'
			),
            'ConfigHeader' => Array ('type' => 'string', 'required' => 1, 'default' => null),
            'DisplayOrder' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
            'SearchConfigId' =>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
            'Priority' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
            'FieldType' => Array (
            	'type' => 'string',
            	'formatter' => 'kOptionsFormatter',
            	'options' => Array (
            		'text' => 'text', 'range' => 'range',
            		'boolean' => 'boolean', 'date' => 'date',
				),
				'not_null' => '1', 'required' => 1, 'default' => 'text'
			),
            'ForeignField' => Array ('type' => 'string', 'default' => null),
            'JoinClause' =>	Array ('type' => 'string', 'default' => null),
            'IsWhere' => Array ('type' => 'string', 'default' => null),
            'IsNotWhere' => Array ('type' => 'string', 'default' => null),
            'ContainsWhere' => Array ('type' => 'string', 'default' => null),
            'NotContainsWhere' => Array ('type' => 'string', 'default' => null),
            'CustomFieldId' => Array ('type' => 'int', 'default' => null),
		),

		'VirtualFields' => Array (
			'IsCustom' => Array ('type' => 'int', 'default' => 0),
		),

		'ListSortings' => Array (
			'' => Array (
				'ForcedSorting' => Array ('IsCustom' => 'asc'),
				'Sorting' => Array ('DisplayOrder' => 'asc'),
			),
		),

		'Grids'	=> Array (
			'Default' => Array (
				'Icons' => Array ('default' => 'icon16_item.png'),	// icons for each StatusField values, if no matches or no statusfield selected, then "default" icon is used
				'Fields' => Array (
					'TableName' => Array ('title' => 'la_col_TableName', 'data_block' => 'grid_data_td'),
					'FieldName' => Array ('title' => 'la_col_FieldName', 'data_block' => 'grid_data_td' ),
					'SimpleSearch' => Array ('title' => 'la_col_SimpleSearch', 'data_block' => 'grid_data_td'),
				),
			),
		),
	);