<?php
/**
* @version	$Id: visits_list.php 13086 2010-01-12 19:47:40Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class VisitsList extends kDBList {
		/**
		* Counts the total number of records base on the query resulted from {@link kDBList::GetSelectSQL()}
		*
		* The method modifies the query to substitude SELECT part (fields listing) with COUNT(*).
		* Special care should be applied when working with lists based on grouped queries, all aggregate function fields
		* like SUM(), AVERAGE() etc. should be added to CountedSQL by using {@link kDBList::SetCountedSQL()}
		*
		* @access public
		* @param string
		* @return void
		*/
		function CountRecs()
		{
			$system_sql = $this->GetSelectSQL(true,true);
			$sql = $this->getCountSQL($system_sql);
			if( $this->GetGroupClause() ) {
				if (!isset($this->OriginalParams['types']) && $this->Special == 'incommerce') {
					//$sql = preg_replace('/GROUP BY.*/', '', $sql);
					$sql = 'SELECT COUNT(*) FROM '.$this->TableName;
					$this->NoFilterCount = (int)$this->Conn->GetOne($sql);
				}
				else {
		    		$this->NoFilterCount = count( $this->Conn->GetCol($sql) );
				}
			}
			else {
				$this->NoFilterCount = (int)$this->Conn->GetOne($sql);
			}

			$all_sql = $this->GetSelectSQL(true,false);
			if($system_sql == $all_sql) { //no need to query the same again
	    		$this->RecordsCount = $this->NoFilterCount;
	    		return;
	    	}

			$sql = $this->getCountSQL($all_sql);

			if( $this->GetGroupClause() ) {
	    		$this->RecordsCount = count( $this->Conn->GetCol($sql) );
			}
			else {
				$this->RecordsCount = (int)$this->Conn->GetOne($sql);
			}

		    $this->Counted = true;
		}

	}