<?php
/**
* @version	$Id: users_config.php 13962 2010-09-25 18:38:45Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'u',
					'ItemClass'			=>	Array('class'=>'UsersItem','file'=>'users_item.php','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'UsersEventHandler','file'=>'users_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'UsersTagProcessor','file'=>'users_tag_processor.php','build_event'=>'OnBuild'),
					'RegisterClasses'	=>	Array(
												Array('pseudo' => 'UsersSyncronizeManager', 'class' => 'UsersSyncronizeManager', 'file' => 'users_syncronize.php', 'build_event' => ''),
											),

					'AutoLoad'			=>	true,
					'ConfigPriority' => 0,
					'Hooks' => Array (
						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => 'affil',
							'HookToSpecial' => '*',
							'HookToEvent' => Array('OnCheckAffiliateAgreement'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnSubstituteSubscriber',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => '',
							'HookToSpecial' => '*',
							'HookToEvent' => Array('OnAfterConfigRead'),
							'DoPrefix' => 'cdata',
							'DoSpecial' => '*',
							'DoEvent' => 'OnDefineCustomFields',
						),

						Array (
							'Mode' => hAFTER,
							'Conditional' => false,
							'HookToPrefix' => 'adm',
							'HookToSpecial' => '*',
							'HookToEvent' => Array('OnStartup'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnAutoLoginUser',
						),

						Array (
							'Mode' => hBEFORE,
							'Conditional' => false,
							'HookToPrefix' => 'img',
							'HookToSpecial' => '*',
							'HookToEvent' => Array ('OnAfterConfigRead'),
							'DoPrefix' => '',
							'DoSpecial' => '*',
							'DoEvent' => 'OnCloneSubItem',
						),

						// Captcha processing
						Array (
							'Mode' => hAFTER,
							'Conditional' => false,
							'HookToPrefix' => '',
							'HookToSpecial' => '*',
							'HookToEvent' => Array('OnAfterConfigRead'),
							'DoPrefix' => 'captcha',
							'DoSpecial' => '*',
							'DoEvent' => 'OnPrepareCaptcha',
						),

						/*Array (
							'Mode' => hAFTER,
							'Conditional' => false,
							'HookToPrefix' => '',
							'HookToSpecial' => '*',
							'HookToEvent' => Array('OnBeforeItemCreate'),
							'DoPrefix' => 'captcha',
							'DoSpecial' => '*',
							'DoEvent' => 'OnValidateCode',
						),*/
					),

					'QueryString'		=>	Array(
												1 => 'id',
												2 => 'Page',
												3 => 'PerPage',
												4 => 'event',
												5 => 'mode',
											),

					'RegularEvents' => Array(
						'membership_expiration' => Array('EventName' => 'OnCheckExpiredMembership', 'RunInterval' => 1800, 'Type' => reAFTER),
						'delete_expired_sessions' => Array('EventName' => 'OnDeleteExpiredSessions', 'RunInterval' => 43200, 'Type' => reAFTER),
					),

					'IDField' 			=>	'PortalUserId',

					'StatusField'		=>	Array('Status'),

					'TitleField'		=>	'Login',

					'ItemType'			=>	6,	// used for custom fields only (on user's case)

					'StatisticsInfo'	=>	Array(
									'pending'	=>	Array(
										'icon'		=>	'icon16_user_pending.gif',
										'label'		=>	'la_Text_Users',
										'js_url' 	=>	'#url#',
										'url'		=>	Array('t' => 'users/users_list', 'pass' => 'm,u', 'u_event' => 'OnSetFilterPattern', 'u_filters' => 'show_active=0,show_pending=1,show_disabled=0'),
										'status'	=>	STATUS_PENDING,
										),
								),

					'TitlePresets' => Array (
						'default' => Array (
							'new_status_labels' => Array ('u' => '!la_title_Adding_User!'),
							'edit_status_labels' => Array ('u' => '!la_title_Editing_User!'),
						),

						'users_list' => Array (
							'prefixes' => Array ('u_List'), 'format' => "!la_title_Users!",
							'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'approve', 'decline', 'e-mail', 'export', 'view', 'dbl-click'),
						),

						'users_edit' => Array (
							'prefixes' => Array ('u'), 'format' => "#u_status# #u_titlefield#",
							'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
							),

						'user_edit_images' => Array (
							'prefixes' => Array ('u', 'u-img_List'), 'format' => "#u_status# '#u_titlefield#' - !la_title_Images!",
							'toolbar_buttons' =>  Array ('select', 'cancel', 'prev', 'next', 'new_item', 'edit', 'delete', 'approve', 'decline', 'setprimary', 'move_up', 'move_down', 'view', 'dbl-click'),
							),

						'user_edit_groups' => Array (
							'prefixes' => Array ('u', 'u-ug_List'), 'format' => "#u_status# '#u_titlefield#' - !la_title_Groups!",
							'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next', 'select_user', 'edit', 'delete', 'setprimary', 'view', 'dbl-click'),
							),

						'user_edit_items' => Array (
							'prefixes' => Array ('u'), 'format' => "#u_status# '#u_titlefield#' - !la_title_Items!",
							'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next', 'edit', 'delete', 'view', 'dbl-click'),
							),

						'user_edit_custom' => Array (
							'prefixes' => Array ('u'), 'format' => "#u_status# '#u_titlefield#' - !la_title_Custom!",
							'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next'),
							),

						'admin_list' => Array (
							'prefixes' => Array ('u.admins_List'), 'format' => "!la_title_Administrators!",
							'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'clone', 'refresh', 'view', 'dbl-click'),
							),

						'admins_edit' => Array (
							'prefixes' => Array ('u'), 'format' => "#u_status# #u_titlefield#",
							'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
							),

						'regular_users_list' => Array (
							'prefixes' => Array ('u.regular_List'), 'format' => "!la_title_Users!",
							'toolbar_buttons' => Array (),
							),

						'root_edit' => Array (
							'prefixes' => Array ('u'), 'format' => "!la_title_Editing_User! 'root'",
							'toolbar_buttons' => Array ('select', 'cancel'),
							),

						'user_edit_group' => Array (
							'prefixes' => Array ('u', 'u-ug'),
							'edit_status_labels' => Array ('u-ug' => '!la_title_EditingMembership!'),
							'format' => "#u_status# '#u_titlefield#' - #u-ug_status# '#u-ug_titlefield#'",
							'toolbar_buttons' => Array ('select', 'cancel'),
						),

						'user_image_edit' => Array (
							'prefixes' => Array ('u', 'u-img'),
							'new_status_labels' => Array ('u-img' => '!la_title_Adding_Image!'),
							'edit_status_labels' => Array ('u-img' => '!la_title_Editing_Image!'),
							'new_titlefield' => Array ('u-img' => '!la_title_New_Image!'),
							'format' => "#u_status# '#u_titlefield#' - #u-img_status# '#u-img_titlefield#'",
							'toolbar_buttons' => Array ('select', 'cancel'),
						),

						'user_select'	=>	Array (
							'prefixes' => Array ('u_List'), 'format' => "!la_title_Users! - !la_title_SelectUser!",
							'toolbar_buttons' => Array ('select', 'cancel', 'dbl-click'),
							),

						'group_user_select'	=>	Array (
							'prefixes' => Array ('u.group_List'), 'format' => "!la_title_Users! - !la_title_SelectUser!",
							'toolbar_buttons' => Array ('select', 'cancel', 'view', 'dbl-click'),
							),
						'tree_users'		=>	Array('format' => '!la_section_overview!'),
					),

					'EditTabPresets' => Array (
   						'Default' => Array (
   							'general' => Array ('title' => 'la_tab_General', 't' => 'users/users_edit', 'priority' => 1),
   							'groups' => Array ('title' => 'la_tab_Groups', 't' => 'users/users_edit_groups', 'priority' => 2),
   							'images' => Array ('title' => 'la_tab_Images', 't' => 'users/user_edit_images', 'priority' => 3),
   							'items' => Array ('title' => 'la_tab_Items', 't' => 'users/user_edit_items', 'priority' => 4),
   							'custom' => Array ('title' => 'la_tab_Custom', 't' => 'users/users_edit_custom', 'priority' => 5),
   						),

   						'Admins' => Array (
   							'general' => Array ('title' => 'la_tab_General', 't' => 'users/admins_edit', 'priority' => 1),
   							'groups' => Array ('title' => 'la_tab_Groups', 't' => 'users/admins_edit_groups', 'priority' => 2),
   						),
   					),

					'PermSection'		=>	Array('main' => 'in-portal:user_list', 'custom' => 'in-portal:user_custom'),

					'Sections' => Array (
						'in-portal:user_list' => Array (
							'parent'		=>	'in-portal:users',
							'icon'			=>	'users',
							'label'			=>	'la_title_Users', // 'la_tab_User_List',
							'url'			=>	Array ('t' => 'users/users_list', 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'add', 'edit', 'delete', 'advanced:ban', 'advanced:send_email', /*'advanced:add_favorite', 'advanced:remove_favorite',*/),
							'priority'		=>	1,
							'type'			=>	stTREE,
						),

						'in-portal:admins' => Array (
							'parent'		=>	'in-portal:users',
							'icon'			=>	'administrators',
							'label'			=>	'la_title_Administrators',
							'url'			=>	Array ('t' => 'users/admins_list', 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'add', 'edit', 'delete'),
							'perm_prefix'	=>	'u',
							'priority'		=>	2,
							'type'			=>	stTREE,
						),

						// user settings
						'in-portal:user_setting_folder' => Array (
							'parent'		=>	'in-portal:system',
							'icon'			=>	'conf_users',
							'label'			=>	'la_title_Users',
							'use_parent_header' => 1,
							'url'			=>	Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view'),
							'priority'		=>	2,
							'container'		=>	true,
							'type'			=>	stTREE,
						),

						'in-portal:configure_users' => Array (
							'parent'		=>	'in-portal:user_setting_folder',
							'icon'			=>	'conf_users_general',
							'label'			=>	'la_tab_ConfigSettings',
							'url'			=>	Array ('t' => 'config/config_universal', 'module' => 'In-Portal:Users', 'pass_section' => true, 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'edit'),
							'priority'		=>	1,
							'type'			=>	stTREE,
						),

						'in-portal:user_custom' => Array (
							'parent'		=>	'in-portal:user_setting_folder',
							'icon'			=>	'conf_customfields',
							'label'			=>	'la_tab_ConfigCustom',
							'url'			=>	Array ('t' => 'custom_fields/custom_fields_list', 'cf_type' => 6, 'pass_section' => true, 'pass' => 'm,cf'),
							'permissions'	=>	Array ('view', 'add', 'edit', 'delete'),
							'priority'		=>	2,
							'type'			=>	stTREE,
						),
					),

					'TableName'			=>	TABLE_PREFIX.'PortalUser',

					'ListSQLs'			=>	Array(	''	=>	'	SELECT %1$s.* %2$s FROM %1$s
																LEFT JOIN '.TABLE_PREFIX.'UserGroup ug ON %1$s.PortalUserId = ug.PortalUserId AND ug.PrimaryGroup = 1
																LEFT JOIN '.TABLE_PREFIX.'PortalGroup g ON ug.GroupId = g.GroupId
																LEFT JOIN '.TABLE_PREFIX.'%3$sPortalUserCustomData cust ON %1$s.ResourceId = cust.ResourceId',

												'online' =>	'	SELECT %1$s.* %2$s FROM %1$s
																LEFT JOIN '.TABLE_PREFIX.'UserSession s ON s.PortalUserId = %1$s.PortalUserId
																LEFT JOIN '.TABLE_PREFIX.'UserGroup ug ON %1$s.PortalUserId = ug.PortalUserId AND ug.PrimaryGroup = 1
																LEFT JOIN '.TABLE_PREFIX.'PortalGroup g ON ug.GroupId = g.GroupId
																LEFT JOIN '.TABLE_PREFIX.'%3$sPortalUserCustomData cust ON %1$s.ResourceId = cust.ResourceId',
											),

					'ItemSQLs'			=>	Array(	''	=>	'	SELECT %1$s.* %2$s FROM %1$s
																LEFT JOIN '.TABLE_PREFIX.'UserGroup ug ON %1$s.PortalUserId = ug.PortalUserId AND ug.PrimaryGroup = 1
																LEFT JOIN '.TABLE_PREFIX.'PortalGroup g ON ug.GroupId = g.GroupId
																LEFT JOIN '.TABLE_PREFIX.'%3$sPortalUserCustomData cust ON %1$s.ResourceId = cust.ResourceId',
											),

					'ListSortings'	=> 	Array (
						'' => Array (
							'Sorting' => Array ('Login' => 'asc'),
						)
					),

					'SubItems'		=> Array('addr', 'u-cdata', 'u-ug', 'u-img', 'fav', 'user-profile'),

					/**
					 * Required for depricated public profile templates to work
					 */
					'UserProfileMapping' => Array (
						'pp_firstname' => 'FirstName',
						'pp_lastname' => 'LastName',
						'pp_dob' => 'dob',
						'pp_email' => 'Email',
						'pp_phone' => 'Phone',
						'pp_street' => 'Street',
						'pp_city' => 'City',
						'pp_state' => 'State',
						'pp_zip' => 'Zip',
						'pp_country' => 'Country',
					),

					'CalculatedFields'	=>	Array(
						''	=>	Array(
							'PrimaryGroup'	=>	'g.Name',
							'FullName' => 'CONCAT(FirstName, " ",  LastName)',
						),
					),

					'Fields' => Array
							    (
							        'PortalUserId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
							        'Login' => Array ('type' => 'string', 'unique'=>Array('Login'), 'default' => null,'required'=>1, 'error_msgs' => Array('unique'=>'!lu_user_already_exist!')),
							        'Password' => Array ('type' => 'string', 'formatter' => 'kPasswordFormatter', 'encryption_method' => 'md5', 'verify_field' => 'VerifyPassword', 'skip_empty' => 1, 'default' => md5('')),
							        'FirstName' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
							        'LastName' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
							        'Company' => Array ('type' => 'string','not_null' => '1','default' => ''),
							        'Email' => Array (
							        	'type' => 'string', 'formatter' => 'kFormatter',
							        	'regexp'=>'/^(' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . ')$/i',
							        	'sample_value' => 'email@domain.com', 'unique' => Array ('Email'), 'not_null' => 1,
							        	'required' => 1,
							        	'default' => '',
							        	'error_msgs' => Array (
							        		'invalid_format'=>'!la_invalid_email!', 'unique'=>'!lu_email_already_exist!'
							        	),
							        ),
							        'CreatedOn' => Array('type'=>'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
							        'Phone' => Array('type' => 'string','default' => null),
							        'Fax' => Array('type' => 'string', 'not_null' => 1, 'default' => ''),
							        'Street' => Array('type' => 'string', 'default' => null),
							        'Street2' => Array('type' => 'string', 'not_null' => '1', 'default' => ''),
							        'City' => Array('type' => 'string','default' => null),
							        'State' => Array(
							        	'type' => 'string',
							        	'formatter' => 'kOptionsFormatter', 'options' => Array(),
										'not_null' => 1,
										'default' => ''
							        ),
							        'Zip' => Array('type' => 'string','default' => null),
							        'Country' => Array(
							        	'type' => 'string',
							        	'formatter' => 'kOptionsFormatter',
			            				'options_sql' => '	SELECT IF(l%2$s_Name = "", l%3$s_Name, l%2$s_Name) AS Name, IsoCode
															FROM ' . TABLE_PREFIX . 'CountryStates
															WHERE Type = ' . DESTINATION_TYPE_COUNTRY . '
															ORDER BY Name',
										'option_key_field' => 'IsoCode', 'option_title_field' => 'Name',
										'not_null' => 1, 'default' => ''
							        ),
							        'ResourceId' => Array('type' => 'int','not_null' => 1, 'default' => 0),
							        'Status' => Array('type' => 'int', 'formatter'=>'kOptionsFormatter', 'options'=>Array(1=>'la_Enabled', 0=>'la_Disabled', 2=>'la_Pending'), 'use_phrases'=>1, 'not_null' => '1','default' => 1),
							        'Modified' => Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
							        'dob' => Array('type'=>'int', 'formatter' => 'kDateFormatter', 'default' => null),
							        'tz' => Array('type' => 'int', 'default' => NULL),
							        'ip' => Array('type' => 'string','default' => null),
							        'IsBanned' => Array('type' => 'int','not_null' => 1, 'default' => 0),
							        'PassResetTime' => Array('type' => 'int','default' => null),
							        'PwResetConfirm' => Array('type' => 'string','default' => null),
							        'PwRequestTime' => Array('type' => 'int','default' => null),
							        'MinPwResetDelay' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(300 => '5', 600 => '10', 900 => '15', 1800 => '30', 3600 => '60'), 'use_phrases' => 0, 'not_null' => '1',  'default' => 1800),
									'AdminLanguage' => Array (
										'type' => 'int',
										'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Language ORDER BY PackName', 'option_key_field' => 'LanguageId', 'option_title_field' => 'LocalName',
										'default' => NULL
									),
									'DisplayToPublic' => Array (
										'type' => 'string',
										'formatter' => 'kOptionsFormatter', 'options' => Array (
											'FirstName' => 'lu_fld_FirstName', 'LastName' => 'lu_fld_LastName', 'dob' => 'lu_fld_BirthDate',
											'Email' => 'lu_fld_Email', 'Phone' => 'lu_fld_Phone', 'Street' => 'lu_fld_AddressLine1',
											'Street2' => 'lu_fld_AddressLine2', 'City' => 'lu_fld_City', 'State' => 'lu_fld_State',
											'Zip' => 'lu_fld_Zip', 'Country' => 'lu_fld_Country',
										), 'use_phrases' => 1, 'multiple' => 1,
										'default' => NULL
									),
							    ),

					'VirtualFields'	=> 	Array(
						'ValidateLogin' => Array('type'=>'string','default'=>''),
						'SubscribeEmail' => Array('type'=>'string','default'=>''),
						'PrimaryGroup'	=>	Array('type' => 'string', 'default' => ''),
						'RootPassword' => Array('type' => 'string', 'formatter' => 'kPasswordFormatter', 'encryption_method' => 'md5', 'verify_field' => 'VerifyRootPassword', 'skip_empty' => 1, 'default' => md5('') ),

						'FullName' => Array ('type' => 'string', 'default' => ''),
						'UserGroup' => Array (
							'type' => 'int',
							'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %1$s FROM ' . TABLE_PREFIX . 'PortalGroup WHERE Enabled = 1 AND FrontRegistration = 1', 'option_key_field' => 'GroupId', 'option_title_field' => 'Name',
							'default' => 0,
						),
					),

					'Grids'	=> Array(
						// not in use
						'Default'	=>	Array(
							'Icons' => Array(
								0 => 'icon16_user_disabled.png',
								1 => 'icon16_user.png',
								2 => 'icon16_user_pending.png'
							),
							'Fields' => Array(
									'Login'			=> Array('title' => 'la_col_Username', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_like_filter'),
									'LastName'		=> Array( 'title'=>'la_col_LastName', 'filter_block' => 'grid_like_filter'),
									'FirstName'		=> Array( 'title'=>'la_col_FirstName', 'filter_block' => 'grid_like_filter'),
									'Email'			=> Array( 'title'=>'la_col_Email', 'filter_block' => 'grid_like_filter'),
									'PrimaryGroup'	=> Array( 'title'=>'la_col_PrimaryGroup', 'filter_block' => 'grid_like_filter'),
									'CreatedOn'	=>	Array('title' => 'la_col_CreatedOn', 'filter_block' => 'grid_date_range_filter'),
									'Status'		=> Array ('title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 100, ),
								),
						),

						// used
						'UserSelector'	=>	Array(
							'Icons' => Array(
								0 => 'icon16_user_disabled.png',
								1 => 'icon16_user.png',
								2 => 'icon16_user_pending.png'
							),
							'Selector' => 'radio',
							'Fields' => Array(
								'Login'			=> Array ('title' => 'la_col_Username', 'data_block' => 'grid_login_td', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
								'FirstName'		=> Array ('title' => 'la_col_FirstName', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
								'LastName'		=> Array ('title' => 'la_col_LastName', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
								'Email'			=> Array ('title' => 'la_col_Email', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
								'PrimaryGroup'	=> Array( 'title'=>'la_col_PrimaryGroup', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
								'CreatedOn'	=>	Array('title' => 'la_col_CreatedOn', 'filter_block' => 'grid_date_range_filter', 'width' => 150, ),
								'Status'		=> Array ('title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 100, ),
							),
						),

						// used
						'Admins' => Array (
							'Icons' => Array(
								0 => 'icon16_admin_disabled.png',
								1 => 'icon16_admin.png',
								2 => 'icon16_admin_disabled.png',
							),
							'Fields' => Array (
								'PortalUserId'	=> Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 70),
								'Login'			=> Array ('title' => 'la_col_Username', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
								'FirstName'		=> Array ('title' => 'la_col_FirstName', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
								'LastName'		=> Array ('title' => 'la_col_LastName', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
								'Email'			=> Array ('title' => 'la_col_Email', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
								'Status'		=> Array ('title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 100, ),
							),
						),

						// used
						'RegularUsers' => Array (
							'Icons' => Array(
								0 => 'icon16_user_disabled.png',
								1 => 'icon16_user.png',
								2 => 'icon16_user_pending.png'
							),
							'Fields' => Array(
								'PortalUserId'	=> Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 70),
								'Login'			=> Array ('title' => 'la_col_Username', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
								'FirstName'		=> Array ('title' => 'la_col_FirstName', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
								'LastName'		=> Array ('title' => 'la_col_LastName', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
								'Email'			=> Array ('title' => 'la_col_Email', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
								'PrimaryGroup'	=> Array ('title' => 'la_col_PrimaryGroup', 'filter_block' => 'grid_like_filter', 'width' => 140),
								'Status'		=> Array ('title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 100, ),
								'CreatedOn'		=> Array ('title' => 'la_col_CreatedOn', 'filter_block' => 'grid_date_range_filter', 'width' => 100),
							),
						),
					),

	);