<?php
/**
* @version	$Id: configuration.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class ConfigurationItem extends kDBItem {

		/**
		 * Returns key clause for Load,Update,Delete operations
		 * Applies current section filter to affect only configuration values,
		 * that are allowed by section in get, which is permission checked before
		 *
		 * @param string $method
		 * @param Array $keys_hash
		 * @return string
		 */
		function GetKeyClause($method=null, $keys_hash = null)
		{
			$keys_hash['Section'] = $this->Application->GetVar('section');
			$keys_hash[$this->IDField] = $this->ID;
			return parent::GetKeyClause($method, $keys_hash);
		}

		/**
		 * Set's field error, if pseudo passed not found then create it with message text supplied.
		 * Don't owerrite existing pseudo translation.
		 *
		 * @param string $field
		 * @param string $pseudo
		 * @param string $error_label
		 */
		function SetError($field, $pseudo, $error_label = null, $error_params = null)
		{
			if (!parent::SetError($field, $pseudo, $error_label, $error_params)) {
				// this field already has an error -> don't overwrite it
				return false;
			}

			$list_errors = $this->Application->GetVar('errors_' . $this->getPrefixSpecial(), Array ());
			$list_errors[ $this->GetDBField('VariableName') ] = $this->GetErrorMsg($field);
			$this->Application->SetVar('errors_' . $this->getPrefixSpecial(), $list_errors);
		}

	}