/*
(c) Intechnic Europe 2007 http://www.intechnic.lv
Author: Konstantin Tjuterev

The class adds a dynamic drop-down to the edit-box
Usage:

<input type="text" id="combo_input" style="width: 200px"><br/>
<input type="text" id="combo_input1" style="width: 200px"><br/>
<script type="text/javascript">
	new AJAXDropDown('combo_input', function(cur_value) {return 'items.xml?'}, function(item) {
			var val = item.getAttribute('a');
			return val ? val : item.innerHTML;
		});
	new AJAXDropDown('combo_input1', function(cur_value) {return 'items1.xml?cur='+encodeURIComponent(cur_value)});

	new AJAXDropDown('curr_search_keyword', function(cur_value) {
			var $url = '<inp2:m_Link template="dummy" pass="m,curr" curr_event="OnSuggestValues" field="Name" cur_value="#CUR_VALUE#" no_amp="1"/>';
			return $url.replace('#CUR_VALUE#', encodeURIComponent(cur_value));
		}
	);
</script>

The AJAXDropDown constructor takes the following arguments:
	input_id - id of textbox to attach to
	suggest_url_callback - function which should return URL which returns XML of suggested values,
		function takes one argument - it is current value of the text_box
	[get_value_callback] - optional argument - function which returns the value to be set in the textbox,
		based on currently selected item (out of suggested). If the argument is skipped - the node value of
		<item> element will be used as the value
		<item> element in the suggestions XML may have unlimited number of attribuets, all the attributes will be set
		to the corresponding DIV element and this DIV element will be passed as argument to the get_value_callback,
		so one may use the argument to alter the value set into textbox as in the example above

Response XML structure:
	The script will look for ALL elements with tagname = 'item', so basically the structure should look like this:

	<suggestions>
		<item>Suggestion 1</item>
		<item>Suggestion 2</item>
		<item>Suggestion 3</item>
	</suggestions>

Design & CSS
	The script will automatically display a div which width will match the width of the text-box
	You may control the div look by changing .suggest-box CSS selector
	The items inside the box will have .suggest-item and .suggest-item-over

	The default styles which may be used is:

	<style type="text/css">
		.suggest-box {
			border: 1px solid #999;
			background-color: #fff;
		}

		.suggest-item, .suggest-item-over {
			padding: 1px 2px 0px 2px;
			font-family: arial,verdana;
			font-size: 12px;
		}

		.suggest-item-over {
			background-color: #3366CC;
			color: #fff;
		}
	</style>

*/


function AJAXDropDown(input_id, suggest_url_callback, get_value_callback)
{
	this.Input = document.getElementById(input_id);
	this.KeyUpWaiting = false;
	this.KeyUpTimer = false;
	this.Box = '';
	this.SuggestURLCallback = suggest_url_callback;
	if (!get_value_callback) get_value_callback = this.GetValue;
	this.GetValueCallback = get_value_callback;
	this.BoxOpen = false;
	this.SelectedItem = false;
	var obj = this;
	addLoadEvent(function() {obj.Init()});
}

AJAXDropDown.prototype.Init = function()
{
	// draw box
	this.Box = document.createElement('DIV');
	document.body.appendChild(this.Box);

//	this.Box = addElement(this.Input.parentNode, 'div');
	this.Box.style.display = 'none';
	this.Box.style.zIndex = 99;
	this.Box.style.position = 'absolute';
	this.Box.style.overflow = 'auto';
	this.Box.className = 'suggest-box'

	this.Input.setAttribute('autocomplete', 'off');
	// add onkeyup
	var obj = this;
	addEvent(this.Input, 'keyup', function(ev) {obj.KeyUp(ev)})
	addEvent(this.Input, 'blur', function(ev) {obj.Blur(ev)})
	addEvent(this.Box, 'scroll', function(ev) {if (obj.BlurWaiting) {window.clearTimeout(obj.BlurTimer);}});
	addEvent(this.Box, 'mouseup', function(ev) {obj.BlurWaiting = false});
}

AJAXDropDown.prototype.Blur = function(ev)
{
	if (this.BlurWaiting) return;
	this.BlurWaiting = true;
	var obj = this;
	this.BlurTimer = window.setTimeout(function() {
			obj.CloseBox();
			this.BlurWaiting = false;
		}, 300)
}

AJAXDropDown.prototype.KeyUp = function(ev)
{
	var e = !is.ie ? ev : window.event;
	switch (e.keyCode) {
		case 38: //arrow up
			if (!this.BoxOpen) break;
			this.SelectPrev();
			break;
		case 40: //arrow down
			if (!this.BoxOpen) break;
			this.SelectNext();
			break;
		case 27: //Enter
			this.Input.value = this.OriginalValue;
			this.CloseBox();
			break;
		case 13: //Escape
			this.CloseBox();
			break;
		default:
			if (this.Input.value == '') return;
			var obj = this;
			if (this.KeyUpWaiting && this.KeyUpTimer) {
				window.clearTimeout(this.KeyUpTimer);
				this.KeyUpTimer = false;
			}
			this.KeyUpWaiting = true;
			this.KeyUpTimer = window.setTimeout(function() {
					obj.RequestSuggestions();
				}, 300)
	}
}

AJAXDropDown.prototype.RequestSuggestions = function()
{
	Request.makeRequest(this.SuggestURLCallback(this.Input.value), false, '', this.successCallback, this.errorCallback, 'reload', this);
}

AJAXDropDown.prototype.successCallback = function (request, params, object) {
	object.OriginalValue = object.Input.value;
	object.OpenBox();
	object.KeyUpWaiting = false;
	var items = request.responseXML.getElementsByTagName('item');
	object.ClearItems();
	for (var i=0; i<items.length; i++)
	{
		object.AddItem(items[i].firstChild.nodeValue, items[i].attributes);
	}
}

AJAXDropDown.prototype.errorCallback = function (request, params, object) {
	this.KeyUpWaiting = false;
}

AJAXDropDown.prototype.ClearItems = function()
{
	this.Box.scrollTop = 0;
	this.UnselectItem();
	for (var i=this.Box.childNodes.length-1; i>=0; i--)
	{
		this.Box.removeChild(this.Box.childNodes[i]);
	}
}

AJAXDropDown.prototype.OpenBox = function()
{
	var pos = findPos(this.Input);
	var dim = getDimensions(this.Input);
	this.Box.style.left = pos[0] + 'px';
	this.Box.style.top = (pos[1] + dim.innerHeight + dim.borders[0] + dim.borders[2]) + 'px';
	this.Box.style.width = (dim.innerWidth + dim.borders[1] + (is.ie ? dim.borders[3] : 0 ) ) + 'px';
	this.Box.style.display = 'block';
//	alert('box opened at '+this.Box.style.left+','+this.Box.style.top+' pos x:'+pos[0])
	this.BoxOpen = true;
}

AJAXDropDown.prototype.CloseBox = function()
{
	if (!this.BoxOpen) return;
	this.Box.style.display = 'none';
	this.BoxOpen = false;
}

AJAXDropDown.prototype.AddItem = function(value, attributes)
{
	var item = addElement(this.Box, 'div');
	for (var i=0; i<attributes.length; i++) {
		item.setAttribute(attributes[i].nodeName, attributes[i].nodeValue)
	}
	item.className = 'suggest-item';
	item.innerHTML = value;
	var obj = this;
	addEvent(item, 'mousemove', function() {obj.SelectItem(item)});
	addEvent(item, 'mousedown', function() {obj.ClickItem(item)});
}

AJAXDropDown.prototype.ClickItem = function(item)
{
	this.Input.value = this.GetValueCallback(item);
	this.CloseBox();
}

AJAXDropDown.prototype.SelectNext = function()
{
	if (!this.SelectedItem) {
		this.SelectItem(this.Box.firstChild, true);
		return;
	}
	if (isset(this.SelectedItem.nextSibling)) {
		this.SelectItem(this.SelectedItem.nextSibling, true)
	}
	else { // down from last
		this.UnselectItem();
		this.Input.value = this.OriginalValue;
	}
}

AJAXDropDown.prototype.SelectPrev = function()
{
	if (!this.SelectedItem) {
		this.SelectItem(this.Box.lastChild, true);
		return;
	}
	if (isset(this.SelectedItem.previousSibling)) {
		this.SelectItem(this.SelectedItem.previousSibling, true)
	}
	else { // up from first
		this.UnselectItem();
		this.Input.value = this.OriginalValue;
	}
}

AJAXDropDown.prototype.UnselectItem = function(item)
{
	if (!item) item = this.SelectedItem;
	if (!item) return;
	item.className = 'suggest-item';
	this.SelectedItem = false;
}


AJAXDropDown.prototype.SelectItem = function(item, setvalue)
{
	if (this.SelectedItem) {
		this.UnselectItem(this.SelectedItem);
	}
	item.className = 'suggest-item-over';
	this.SelectedItem = item;
	item.scrollIntoView(false);

	if (setvalue) {
		this.Input.value = this.GetValueCallback(item);
	}
}

AJAXDropDown.prototype.GetValue = function(item)
{
	return item.innerHTML;
}
