<?php
/**
* @version	$Id: cron.php 13086 2010-01-12 19:47:40Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	// Use this line to invoke from cron.
	// wget http://<server_address>/tools/cron.php -O /dev/null > /dev/null 2>&1

	$start = getmicrotime();

	define('CRON', 1);
	define('ADMIN', 1);
	define('REL_PATH', 'tools');
	define('FULL_PATH', realpath(dirname(__FILE__) . '/..'));
	define('CMD_MODE', isset($argv) && count($argv) ? 1 : 0);

	if (CMD_MODE) {
		define('DBG_SKIP_REPORTING', 1);
		$_SERVER['HTTP_USER_AGENT'] = 'gecko';
		$_SERVER['HTTP_HOST'] = 'localhost';
	}

	include_once(FULL_PATH . '/core/kernel/startup.php');

	$application =& kApplication::Instance();
	$application->Init();

	// events from request are not processed, only predefined regular events
	$application->EventManager->RunRegularEvents(reBEFORE, true);
	$application->EventManager->RunRegularEvents(reAFTER, true);

	$application->Done();

	$end = getmicrotime();

	function getmicrotime()
	{
	    list($usec, $sec) = explode(" ", microtime());
	    return ((float)$usec + (float)$sec);
	}