<?php
/**
* @version	$Id: country_states_config.php 13545 2010-05-11 19:19:58Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2010 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'country-state',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'CountryStateEventHandler', 'file' => 'country_state_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'event',
			4 => 'mode',
		),

		'IDField' => 'CountryStateId',

		'TableName' => TABLE_PREFIX . 'CountryStates',

		'TitleField' => 'Translation',

		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array ('country-state' => '!la_title_AddingCountryState!'),
				'edit_status_labels' => Array ('country-state' => '!la_title_EditingCountryState!'),
			),

			'country_state_list' => Array (
				'prefixes' => Array ('country-state_List'), 'format' => "!la_title_CountryStates!",
				'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'view', 'dbl-click'),
			),

			'country_state_edit' => Array (
				'prefixes' => Array ('country-state'), 'format' => "#country-state_status# '#country-state_titlefield#'",
				'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
			),
		),

		'PermSection' => Array('main' => 'in-portal:country_states'),

		'Sections' => Array (
			'in-portal:country_states' => Array (
				'parent'		=>	'in-portal:website_setting_folder',
				'icon'			=>	'conf_country_states',
				'label'			=>	'la_title_CountryStates',
				'url'			=>	Array('t' => 'country_states/country_state_list', 'pass' => 'm'),
				'permissions'	=>	Array('view', 'add', 'edit', 'delete'),
				'priority'		=>	10,
				'type'			=>	stTREE,
			),
		),

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s FROM %1$s',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('Type' => 'asc', 'Translation' => 'asc'),
			)
		),

		'CalculatedFields' => Array (
			'' => Array (
				'Translation' => 'l%2$s_Name',
			),
		),

		'Fields' => Array (
			'CountryStateId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),

			'Type' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_Country', 2 => 'la_opt_State'), 'use_phrases' => 1,
				'not_null' => 1, 'required' => 1, 'default' => 1
			),

			'StateCountryId' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter',
				'options_sql' => '	SELECT IF(l%2$s_Name = "", l%3$s_Name, l%2$s_Name) AS Name, CountryStateId
									FROM ' . TABLE_PREFIX . 'CountryStates
									WHERE Type = ' . DESTINATION_TYPE_COUNTRY . '
									ORDER BY Name',
				'option_key_field' => 'CountryStateId', 'option_title_field' => 'Name',
				'default' => NULL
			),

			'Name' => Array (
				'type' => 'string', 'max_len' => 255,
				'formatter' => 'kMultiLanguage', 'db_type' => 'varchar(255)',
				'not_null' => 1, 'required' => 1, 'default' => ''
			),

			'IsoCode' => Array ('type' => 'string', 'max_len' => 3, 'not_null' => 1, 'unique' => Array ('Type', 'StateCountryId'), 'required' => 1, 'default' => ''),
			'ShortIsoCode' => Array ('type' => 'string', 'max_len' => 2, 'default' => NULL),
		),

		'VirtualFields' => Array (
			'Translation' => Array ('type' => 'string', 'default' => ''),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array ('default' => 'icon16_item.png'),
				'Fields' => Array (
					'CountryStateId' => Array ('title' => 'la_col_Id', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
					'Name' => Array ('title' => 'la_col_Name', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
					'IsoCode' => Array ('title' => 'la_col_IsoCode', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
					'Type' => Array ('title' => 'la_col_Type', 'filter_block' => 'grid_options_filter', 'width' => 100, ),
					'StateCountryId' => Array ('title' => 'la_col_StateCountry', 'filter_block' => 'grid_options_filter', 'width' => 200, ),
					'ShortIsoCode' => Array ('title' => 'la_col_ShortIsoCode', 'filter_block' => 'grid_like_filter', 'width' => 125, ),
				),
			),
		),
	);
