<?php
/**
* @version	$Id: agents_config.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'agent',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'AgentEventHandler', 'file' => 'agent_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'event',
			4 => 'mode',
		),

		'Hooks'	=>	Array (
			Array (
				'Mode' => hAFTER,
				'Conditional' => false,
				'HookToPrefix' => 'adm',
				'HookToSpecial' => '*',
				'HookToEvent' => Array ('OnAfterCacheRebuild'),
				'DoPrefix' => '',
				'DoSpecial' => '*',
				'DoEvent' => 'OnRefreshAgents',
			),
		),

		'IDField' => 'AgentId',

		'TableName' => TABLE_PREFIX . 'Agents',

		'TitleField' => 'AgentName',

		'StatusField' => Array ('Status'),

		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array ('agent' => '!la_title_AddingAgent!'),
				'edit_status_labels' => Array ('agent' => '!la_title_EditingAgent!'),
				'new_titlefield' => Array ('agent' => '!la_title_NewAgent!'),
			),

			'agent_list' => Array (
				'prefixes' => Array ('agent_List'), 'format' => "!la_title_Agents!",
				'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'approve', 'decline', 'cancel', 'view', 'dbl-click'),
				),

			'agent_edit' => Array ('prefixes' => Array ('agent'), 'format' => "#agent_status# '#agent_titlefield#'",
				'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
				),
		),

		'PermSection' => Array('main' => 'in-portal:agents'),

		'Sections' => Array (
			'in-portal:agents' => Array (
				'parent'		=>	'in-portal:website_setting_folder',
				'icon'			=>	'conf_agents',
				'label'			=>	'la_title_Agents',
				'url'			=>	Array('t' => 'agents/agent_list', 'pass' => 'm'),
				'permissions'	=>	Array('view', 'add', 'edit', 'delete'),
				'priority'		=>	6,
				'type'			=>	stTREE,
			),
		),

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s FROM %1$s',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('AgentName' => 'asc'),
			)
		),

		'Fields' => Array (
			'AgentId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),

			'AgentName' => Array (
				'type' => 'string', 'max_len' => 255,
				'unique' => Array (),
				'required' => 1, 'not_null' => 1, 'default' => ''
			),

			'AgentType' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_User', 2 => 'la_opt_System'), 'use_phrases' => 1,
				'required' => 1, 'not_null' => 1, 'default' => 1
			),
			'Status' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_Active', 0 => 'la_opt_Disabled'), 'use_phrases' => 1,
				'required' => 1, 'not_null' => 1, 'default' => 1
			),
			'Event' => Array (
				'type' => 'string', 'max_len' => 255,
				'formatter' => 'kFormatter', 'regexp' => '/^[a-z-]*[.]{0,1}[a-z-]*:On[A-Za-z0-9]*$/',
				'required' => 1, 'not_null' => 1, 'default' => ''
			),
			'RunInterval' => Array ('type' => 'int', 'required' => 1, 'not_null' => 1, 'default' => 0),
			'RunMode' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (reBEFORE => 'la_opt_Before', reAFTER => 'la_opt_After'), 'use_phrases' => 1,
				'required' => 1, 'not_null' => 1, 'default' => 2
			),
			'LastRunOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),

			'LastRunStatus' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_Success', 0 => 'la_opt_Failed', 2 => 'la_opt_Running'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 1
			),

			'NextRunOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'required' => 1, 'default' => '#NOW#'),
			'RunTime' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array (
					'default' => 'icon16_item.png',
					0 => 'icon16_disabled.png',
				),
				'Fields' => Array (
					'AgentId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 50, ),
					'AgentName' => Array ('title' => 'la_col_Name', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
					'AgentType' => Array ('title' => 'la_col_Type', 'filter_block' => 'grid_options_filter', 'width' => 60, ),
					'Event' => Array ('title' => 'la_col_Event', 'filter_block' => 'grid_like_filter', 'width' => 280, ),
//					'Status' => Array ('title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 65, ),
					'RunInterval' => Array ('title' => 'la_col_RunInterval', 'filter_block' => 'grid_range_filter', 'width' => 100, ),
					'RunMode' => Array ('title' => 'la_col_RunMode', 'filter_block' => 'grid_options_filter', 'width' => 85, ),
					'LastRunOn' => Array ('title' => 'la_col_LastRunOn', 'filter_block' => 'grid_date_range_filter', 'width' => 145, ),
					'LastRunStatus' => Array ('title' => 'la_col_LastRunStatus', 'filter_block' => 'grid_options_filter', 'width' => 120, ),
					'NextRunOn' => Array ('title' => 'la_col_NextRunOn', 'filter_block' => 'grid_date_range_filter', 'width' => 145, ),
				),
			),
		),
	);